<?php 
/*
Fungsi : Controller untuk accounting report
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Acc_report extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_branch_cpv_gl_rpt  = 129;
	var $menu_pusat_cpv_gl_rpt  = 128;
	var $menu_branch_bal_rpt  = 130;
	
	var $menu_branch_bank_bal_hist_rpt  = 131;
	var $menu_branch_pcuo_bal_hist_rpt  = 132;
	var $menu_branch_pcop_bal_hist_rpt  = 133;
	
	var $menu_branch_stock_hist_rpt  = 134;
	
	var $menu_miro_hist_rpt  = 135;
	
	var $menu_acc_branch_bal_detail = 141;
	
	var $menu_acc_branch_po_rpt = 145;
	var $menu_acc_branch_pc_op_rpt = 151;
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	


/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('accounting/acc_report_model', '', TRUE);
		$this->load->model('admin/branch_report_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->acc_cpv_gl_post_pusat();
		
	}
	
	function acc_branch_pc_op_rpt()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_acc_branch_pc_op_rpt);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH PETTY CASH OPERATIONAL REPORT';
		if($this->session->userdata('idcab')==1)
		{
			$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		}
		else
		{
			$data['cab'] =   $this->acc_report_model->get_cabang_byidcab($this->session->userdata('idcab'))->result();
		}
		$data['form_action']= site_url('accounting/acc_report/acc_branch_pc_op_rpt_disp');
		$this->load->view('accounting/acc_branch_pc_op_rpt_form', $data);	
		
	}
	
	function acc_branch_pc_op_rpt_disp()
	{
		
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH PETTY CASH OPERATIONAL REPORT > '.strtoupper($cabs->cabname).' FROM : '.$this->input->post('txt_date1').' TO : '.$this->input->post('txt_date2');
		
		$data['bpkk'] = $this->acc_report_model->get_bpkk_byidcab(date("Y-m-d", strtotime($this->input->post('txt_date1'))),date("Y-m-d", strtotime($this->input->post('txt_date2'))),$this->input->post('cb_idcab'))->result();
		
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_branch_pc_op_rpt','Back', array('class' => 'back')));
		
		$data['form_action']= site_url('accounting/acc_report/acc_branch_pc_op_rpt_disp_xls/'.$this->input->post('cb_idcab').'/'.$this->input->post('txt_date1').'/'.$this->input->post('txt_date2').'/'.'xls');
		
		$this->load->view('accounting/acc_branch_pc_op_rpt_disp_form', $data);	
		
	}
	
	function acc_branch_pc_op_rpt_disp_xls()
	{
		
		$data['bpkk'] = $this->acc_report_model->get_bpkk_byidcab(date("Y-m-d", strtotime($this->uri->segment(5))),date("Y-m-d", strtotime($this->uri->segment(6))),$this->uri->segment(4))->result();
		$data['xls'] = 1;
		$this->load->view('accounting/acc_branch_pc_op_rpt_disp_form', $data);	
		
	}
	
	function acc_branch_po_rpt()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_acc_branch_po_rpt);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH PURCHASE ORDER REPORT';
		if($this->session->userdata('idcab')==1)
		{
			$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		}
		else
		{
			$data['cab'] =   $this->acc_report_model->get_cabang_byidcab($this->session->userdata('idcab'))->result();
		}
		$data['form_action']= site_url('accounting/acc_report/acc_branch_po_rpt_disp');
		$this->load->view('accounting/acc_branch_po_rpt_form', $data);	
		
	}
	
	function acc_branch_po_rpt_disp()
	{
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH PURCHASE ORDER REPORT > '.strtoupper($cabs->cabname).' FROM : '.$this->input->post('txt_date1').' TO : '.$this->input->post('txt_date2');
		
		$data['po'] = $this->acc_report_model->get_po_byidcab(date("Y-m-d", strtotime($this->input->post('txt_date1'))),date("Y-m-d", strtotime($this->input->post('txt_date2'))),$this->input->post('cb_idcab'))->result();
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_branch_po_rpt','Back', array('class' => 'back')));
		
		$data['form_action']= site_url('accounting/acc_report/acc_branch_po_rpt_disp_xls/'.$this->input->post('cb_idcab').'/'.$this->input->post('txt_date1').'/'.$this->input->post('txt_date2').'/'.'xls');
		
		$this->load->view('accounting/acc_branch_po_rpt_disp_form', $data);	
	}
	
	function acc_branch_po_rpt_disp_xls()
	{
		
		$data['po'] = $this->acc_report_model->get_po_byidcab(date("Y-m-d", strtotime($this->uri->segment(5))),date("Y-m-d", strtotime($this->uri->segment(6))),$this->uri->segment(4))->result();
		$data['xls'] = 1;
		$this->load->view('accounting/acc_branch_po_rpt_disp_form', $data);	
		
	}

	
	function acc_branch_bal_detail()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_acc_branch_bal_detail);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH BALANCE DETAIL';
		
		if($this->session->userdata('idcab')==1)
		{
			$data['cab'] =   $this->branch_report_model->get_cabang()->result();
		}
		else
		{
			$data['cab'] =   $this->branch_report_model->get_cabang_byidcab($this->session->userdata('idcab'))->result();
		}
		
		//$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		$data['form_action']= site_url('accounting/acc_report/acc_branch_bal_detail_disp');
		$this->load->view('accounting/acc_branch_bal_detail_form', $data);	
		
	}
	
	function acc_branch_bal_detail_disp()
	{
	
	

	$query_sum_1 = $this->db->query("SELECT sum( (( quantity * net_price )- disc ) + tax) as total 
from t_po
where t_po.nocpvform = ' '
and t_po.idtop <> 1
and idcab = '".$this->input->post('cb_idcab')."'")->result();
foreach ($query_sum_1  as $query_sum_1s);
$data['sum_1'] = $query_sum_1s->total;

$query_sum_2 = $this->db->query(" SELECT `ebeln`, ceil(( ( quantity * net_price ) - disc ) + tax) as total FROM `t_po` WHERE `mblnr` != '' and miro = '' AND idcab ='".$this->input->post('cb_idcab')."'")->result();
foreach($query_sum_2  as $query_sum_2s)
{
$data['sum_2'] = $data['sum_2'] + $query_sum_2s->total;
}

$query_sum_3 = $this->db->query("SELECT
  Sum(t_cpv.amount_trf) AS total
FROM
  t_cpv
WHERE
  t_cpv.accglpost = 0 AND
  t_cpv.status = 1 AND
  t_cpv.nocpdu = '' AND
  t_cpv.idcab = '".$this->input->post('cb_idcab')."'
")->result();
foreach ($query_sum_3  as $query_sum_3s);
$data['sum_3'] = $query_sum_3s->total;

$query_sum_4 = $this->db->query("SELECT Sum(t_cpv.amount_trf) AS total 
from t_cpv 
where accglpost = 0 
and status = 1
and nocpdu <> ''
and pctyp not in (0, 1)
AND idcab =  '".$this->input->post('cb_idcab')."'
")->result();
foreach ($query_sum_4  as $query_sum_4s);
$data['sum_4'] = $query_sum_4s->total;

$query_sum_5 = $this->db->query("SELECT
  sum(m_op.pur) + sum(m_op.fee) as total 
FROM
  t_pr
  INNER JOIN m_op ON t_pr.preq_no = m_op.prnumb
WHERE
  t_pr.closed = 0  
AND
t_pr.idcab = '".$this->input->post('cb_idcab')."'
AND
m_op.cancel = 0
")->result();
foreach ($query_sum_5  as $query_sum_5s);
$data['sum_5'] = $query_sum_5s->total;

/*$query_sum_6 = $this->db->query("select
sum(amount) as total
from t_bankbal
where
idcab = '".$this->input->post('cb_idcab')."'")->result();
foreach ($query_sum_6  as $query_sum_6s);
$data['sum_6'] = $query_sum_6s->total;*/

//Select PC bank account
$query_sum_6 = $this->db->query("select
*
from m_cab
where
idcab = '".$this->input->post('cb_idcab')."'")->result();
foreach ($query_sum_6  as $query_sum_6s);
$data['sum_6'] = $this->fungsi->get_bank_bal($query_sum_6s->pcbankglacc);

$query_sum_7 = $this->db->query(" select
sum(amount) as total
from t_pcbal
where
idcab = '".$this->input->post('cb_idcab')."'
")->result();
foreach ($query_sum_7  as $query_sum_7s);
$data['sum_7'] = $query_sum_7s->total;

$query_sum_8 = $this->db->query("select
sum(amount) as total
from t_pcbal_op
where
idcab = '".$this->input->post('cb_idcab')."'")->result();
foreach ($query_sum_8  as $query_sum_8s);
$data['sum_8'] = $query_sum_8s->total;

$query_sum_9 = $this->db->query("select
sum(total) as total
from t_rmb_header
where status = 0
and idcab = '".$this->input->post('cb_idcab')."'")->result();
foreach ($query_sum_9  as $query_sum_9s);
$data['sum_9'] = $query_sum_9s->total;

$query_sum_10 = $this->db->query("SELECT
  sum(total) as total
FROM
  t_bpkk_header 
where status = 0
and idcab = '".$this->input->post('cb_idcab')."'")->result();
foreach ($query_sum_10  as $query_sum_10s);
$data['sum_10'] = $query_sum_10s->total;

$query_sum_11 = $this->db->query("SELECT
  Sum(t_cpv.amount_trf) AS total
FROM
  t_cpv
WHERE
  t_cpv.status = 0
AND
  t_cpv.idcab = '".$this->input->post('cb_idcab')."'
")->result();
foreach ($query_sum_11  as $query_sum_11s);
$data['sum_11'] = $query_sum_11s->total;


$query_sum_12 = $this->db->query("SELECT
  SUM(m_op.fee) as total
FROM
  t_po
  INNER JOIN m_op ON m_op.prnumb = t_po.preq_no
WHERE
  t_po.idtop = 1 AND
  m_op.pur = 0 AND
  t_po.nocpvform = ''
AND t_po.idcab = '".$this->input->post('cb_idcab')."'
AND m_op.cancel = 0")->result();
foreach ($query_sum_12  as $query_sum_12s);
$data['sum_12'] = $query_sum_12s->total;

//print_r($query);

//Get total saldo cabang
$query_tot_sal_cab = $this->db->query("SELECT
  sal_tot
FROM
  m_cab
WHERE idcab = '".$this->input->post('cb_idcab')."'
")->result();
foreach ($query_tot_sal_cab  as $query_tot_sal_cabs);
$data['sal_tot_cab'] = $query_tot_sal_cabs->sal_tot;

$data['balance'] = $query;
		
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH BALANCE DETAIL >'.strtoupper($cabs->cabname);
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_branch_bal_detail','Back', array('class' => 'back')));
		$this->load->view('accounting/acc_branch_bal_detail_disp', $data);			
	}
	
	function acc_miro_hist_report()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_miro_hist_rpt);
		
		$data['menu_path'] = 'ACCOUNTING > MIRO HISTORY REPORT';
		
		$data['form_action']= site_url('accounting/acc_report/acc_miro_hist_disp');
		$this->load->view('accounting/acc_miro_hist_form', $data);	
		
	}
	
	function acc_miro_hist_disp()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_miro_hist_rpt);
		
		$data['menu_path'] = 'ACCOUNTING > MIRO HISTORY REPORT > DATE FROM '.$this->input->post('txt_date1').' TO '.$this->input->post('txt_date2');
		
		$miro = $this->acc_report_model->get_list_miro(date("Y-m-d", strtotime($this->input->post('txt_date1'))),date("Y-m-d", strtotime($this->input->post('txt_date2'))))->result();
		$data['miro'] = $miro;
		
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_miro_hist_report','Back', array('class' => 'back')));
		$this->load->view('accounting/acc_miro_hist_disp_form', $data);	
		
	}
	
	function acc_branch_stock_hist_report()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_branch_stock_hist_rpt);
		
		$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		$data['menu_path'] = 'ACCOUNTING > BRANCH STOCK HISTORY REPORT';
		
		$data['form_action']= site_url('accounting/acc_report/acc_branch_stock_hist_disp');
		$this->load->view('accounting/acc_branch_stock_hist_form', $data);	
		
	}
	
	function acc_branch_stock_hist_disp()
	{
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH '.strtoupper($cabs->cabname).' BRANCH STOCK HISTORY REPORT > DATE FROM '.$this->input->post('txt_date1').' TO '.$this->input->post('txt_date2');
		
		$stock_hist = $this->acc_report_model->get_stock_hist_bydate_idcab(date("Y-m-d", strtotime($this->input->post('txt_date1'))),date("Y-m-d", strtotime($this->input->post('txt_date2'))),$this->input->post('cb_idcab'))->result();
		
		$data['stock_hist'] = $stock_hist;
		
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_branch_stock_hist_report','Back', array('class' => 'back')));
		$this->load->view('accounting/acc_branch_stock_hist_disp_form', $data);	
		
	}
	function acc_branch_pcop_bal_hist_report()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_branch_pcop_bal_hist_rpt);
		
		$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		$data['menu_path'] = 'ACCOUNTING > BRANCH PC OP BALANCE HISTORY REPORT';
		
		$data['form_action']= site_url('accounting/acc_report/acc_pcop_branch_bal_hist_disp');
		$this->load->view('accounting/acc_branch_bal_hist_form', $data);	
		
	}
	
	function acc_pcop_branch_bal_hist_disp()
	{
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH '.strtoupper($cabs->cabname).' PC OP BALANCE HISTORY REPORT > DATE FROM '.$this->input->post('txt_date1').' TO '.$this->input->post('txt_date2');
		
		$pcop_bal = $this->acc_report_model->get_pcop_bal_bydate_idcab(date("Y-m-d", strtotime($this->input->post('txt_date1'))),date("Y-m-d", strtotime($this->input->post('txt_date2'))),$this->input->post('cb_idcab'))->result();
		
		$data['pcop_bal'] = $pcop_bal;
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_branch_pcop_bal_hist_report','Back', array('class' => 'back')));
		$this->load->view('accounting/acc_branch_pcop_bal_disp_form', $data);	
		
	}
	
	function acc_branch_pcuo_bal_hist_report()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_branch_pcuo_bal_hist_rpt);
		
		$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		$data['menu_path'] = 'ACCOUNTING > BRANCH PC UO BALANCE HISTORY REPORT';
		
		$data['form_action']= site_url('accounting/acc_report/acc_pcuo_branch_bal_hist_disp');
		$this->load->view('accounting/acc_branch_bal_hist_form', $data);	
		
	}
	
	function acc_pcuo_branch_bal_hist_disp()
	{
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH '.strtoupper($cabs->cabname).' PC UO BALANCE HISTORY REPORT > DATE FROM '.$this->input->post('txt_date1').' TO '.$this->input->post('txt_date2');
		
		$pcuo_bal = $this->acc_report_model->get_pcuo_bal_bydate_idcab(date("Y-m-d", strtotime($this->input->post('txt_date1'))),date("Y-m-d", strtotime($this->input->post('txt_date2'))),$this->input->post('cb_idcab'))->result();
		
		$data['pcuo_bal'] = $pcuo_bal;
		
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_branch_pcuo_bal_hist_report','Back', array('class' => 'back')));
		$this->load->view('accounting/acc_branch_pcuo_bal_disp_form', $data);	
		
	}
	
	function acc_branch_bank_bal_hist_report()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_branch_bank_bal_hist_rpt);
		
		$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		$data['menu_path'] = 'ACCOUNTING > BRANCH BANK BALANCE HISTORY REPORT';
		
		$data['form_action']= site_url('accounting/acc_report/acc_bank_branch_bal_hist_disp');
		$this->load->view('accounting/acc_branch_bal_hist_form', $data);	
		
	}
	
	function acc_bank_branch_bal_hist_disp()
	{
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH '.strtoupper($cabs->cabname).' BANK BALANCE HISTORY REPORT > DATE FROM '.$this->input->post('txt_date1').' TO '.$this->input->post('txt_date2');
		
		$bankbal = $this->acc_report_model->get_bank_bal_bydate_idcab(date("Y-m-d", strtotime($this->input->post('txt_date1'))),date("Y-m-d", strtotime($this->input->post('txt_date2'))),$this->input->post('cb_idcab'))->result();
		
		$data['bank_bal'] = $bankbal;
		
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_branch_bank_bal_hist_report','Back', array('class' => 'back')));
		$this->load->view('accounting/acc_branch_bank_bal_disp_form', $data);	
		
	}
	
	
	function acc_branch_bal_report()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_pusat_cpv_gl_rpt);
		
		$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		$data['menu_path'] = 'ACCOUNTING > BRANCH '.strtoupper($cabs->cabname).' BALANCE REPORT';
		
		$data['form_action']= site_url('accounting/acc_report/acc_branch_bal_disp');
		$this->load->view('accounting/acc_branch_bal_form', $data);	
		
	}
	
	function acc_branch_bal_disp()
	{
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH '.strtoupper($cabs->cabname).' BALANCE REPORT';
		
		$data['bankbal'] = $this->fungsi->get_bank_bal($this->input->post('cb_idcab'));
		$data['pcuo'] = $this->fungsi->get_pc_bal($this->input->post('cb_idcab'));
		$data['pcop'] = $this->fungsi->get_pc_bal_op($this->input->post('cb_idcab'));
		
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_branch_bal_report','Back', array('class' => 'back')));
		
		$this->load->view('accounting/acc_branch_bal_disp_form', $data);	
		
	}
	
	
	function acc_cpv_gl_post_branch()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_pusat_cpv_gl_rpt);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH POST G/L CPV REPORT';
		$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		$data['form_action']= site_url('accounting/acc_report/acc_cpv_gl_post_branch_disp');
		$this->load->view('accounting/acc_gl_post_report_branch_form', $data);	
		
	}
	
	
	function acc_cpv_gl_post_branch_disp()
	{
		
		$data['cpv_data'] =  $this->acc_report_model->get_cpv_cab_bydate( date("Y-m-d", strtotime($this->input->post('txt_date1'))),date("Y-m-d", strtotime($this->input->post('txt_date2'))))->result();
		
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		
		$data['menu_path'] = 'ACCOUNTING > BRANCH '.strtoupper($cabs->cabname).' > POST G/L CPV REPORT > DATE FROM '.$this->input->post('txt_date1').' TO '.$this->input->post('txt_date2');
		$data['link'] = array('link_back' => anchor('accounting/acc_report/acc_cpv_gl_post_branch','Back', array('class' => 'back')));
		$this->load->view('accounting/acc_gl_post_report_branch_disp_form', $data);	
	}


	function acc_cpv_gl_post_pusat()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_pusat_cpv_gl_rpt);
		
		
		$data['menu_path'] = 'ACCOUNTING > ACCOUNTING REPORT > BRANCH PUSAT POST G/L CPV REPORT';
		$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		$data['form_action']= site_url('accounting/acc_report/acc_cpv_gl_post_pusat_disp');
		$this->load->view('accounting/acc_gl_post_report_form', $data);	
		
	}
	
	function acc_cpv_gl_post_pusat_disp()
	{
		
		$data['cpv_data'] =  $this->acc_report_model->get_cpv_pusat_bydate( date("Y-m-d", strtotime($this->input->post('txt_date1'))),date("Y-m-d", strtotime($this->input->post('txt_date2'))),$this->input->post('cb_idcab'))->result();
		$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
		foreach ($cab  as $cabs);
		$data['menu_path'] = 'ACCOUNTING > BRANCH PUSAT POST G/L CPV REPORT > BRANCH '.strtoupper($cabs->cabname).' DATE FROM '.$this->input->post('txt_date1').' TO '.$this->input->post('txt_date2');
		$data['link'] = array('link_back' => anchor('accounting/acc_report/','Back', array('class' => 'back')));
		$this->load->view('accounting/acc_gl_post_report_disp_form', $data);	
	}
}