<?php 
/*
Fungsi : Controller untuk Post Clearing
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Postclr extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_post_clearing  = 80;

/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	


/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('accounting/acc_model', '', TRUE);
		$this->load->model('admin/admin_model', '', TRUE);
		$this->load->model('finance/fin_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->acc_postclr_pending();
		
	}
	
	function acc_postclr_pending()
	{
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//print_r($this->fin_model->get_list_cpv_pend_paging($this->config->item('paging_limit'), $offset)->result());
		 
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_post_clearing);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$po = $this->acc_model->get_list_po_clr($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->acc_model->get_list_po_count_clr();
		
		$config['base_url'] = site_url('accounting/postclr/acc_postclr_pending/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. PO', 'Vendor', 'Branch', 'Price/Liter', 'Total Liter', 'Total', 'Add by','Add date','Options');
					
					foreach ($po  as $pos)
					{	
						$this->table->add_row($pos->ebeln, $pos->vendor, $pos->cabname, $this->fungsi->format_idr($pos->net_price), number_format($pos->quantity),$this->fungsi->format_idr($pos->net_price * $pos->quantity), $pos->addby, $pos->adddate, anchor('accounting/postclr/postclr_form/'.$pos->ebeln.'/'.$pos->year,'Posting',array('class' => 'update')));	
					}
					
					$data['table'] = $this->table->generate();
				}
				
				else
				{
					$data['message'] = 'No data';
				}
					
		$data['menu_path'] = 'ACCOUNTING > LIST POST WITH CLEARING PENDING';
		$this->load->view('accounting/acc_po_list', $data);
		
		
	}
	
function postclr_form()
{	

	//Get data cabang get_cab_detail($idcab)
		$query_get_cab = $this->admin_model->get_cab_detail($this->uri->segment(6));
		foreach ($query_get_cab->result() as $row_cab);
		
		$data['pcglaccuo'] = $row_cab->pcglaccuo;
		$data['pcbankglacc'] = $row_cab->pcbankglacc;
		
		
	$query_cpv_detail = $this->fin_model->get_cpv_bynoyear($this->uri->segment(4),$this->uri->segment(5));
	foreach ($query_cpv_detail->result() as $row_cpv)
		{
			$data['cpvappby'] = $row_cpv->appby;
			$data['cpvappdate'] = $row_cpv->appdate;
			$data['default']['txt_bktxt'] = $row_cpv->nocpvform;
			$data['nocpvform'] = $row_cpv->nocpvform;
			$data['default']['txt_xblnr'] = $row_cpv->nocpdu;
			
			$data['default']['txt_zounr'] = strtoupper($row_cab->cabshorttxt.' - '.date('M').'\''.date('y'));
			$data['default']['txt_zounr2'] = strtoupper($row_cab->cabshorttxt.' - '.date('M').'\''.date('y'));
			$data['default']['txt_zounr3'] = strtoupper($row_cab->cabshorttxt.' - '.date('M').'\''.date('y'));
			$data['default']['txt_zounr4'] = strtoupper($row_cab->cabshorttxt.' - '.date('M').'\''.date('y'));
			
			$data['default']['txt_sgtxt2'] = '3101 -'.strtoupper($row_cab->cabshorttxt).'- P.Cash Used Oil '.$row_cpv->nocpvform;
			$data['default']['txt_sgtxt'] = strtoupper($row_cab->cabshorttxt).'- P.Cash Used Oil '.$row_cpv->nocpvform;
			$data['default']['txt_sgtxt3'] = '1401 -'.strtoupper($row_cab->cabshorttxt).'- P.Cash Used Oil '.$row_cpv->nocpvform;
			$data['default']['txt_sgtxt4'] = strtoupper($row_cab->cabshorttxt).'- P.Cash Used Oil '.$row_cpv->nocpvform;
			
		}
		
		$query_po_detail = $this->acc_model->get_po_detail_bycpv($row_cpv->nocpvform);
		foreach ($query_po_detail->result() as $row_po)
		{
			$data['ebeln'] = $row_po->ebeln;
			$data['poyear'] = $row_po->year;
			$data['preq_no'] = $row_po->preq_no;
			$data['cabname'] = $row_po->cabname;
			$data['migo'] = $row_po->mblnr;
			$data['miro'] = $row_po->miro;
			$data['miraddby'] = $row_po->miraddby;
			$data['miradddate'] = $row_po->miradddate;
			$data['quantity'] = $row_po->quantity;
			$data['net_price'] = $row_po->net_price;
			$data['vendor'] = $row_po->vendor;
			$data['add_by'] = $row_po->addby;
			$data['add_date'] = $row_po->adddate;
			$data['total'] = ($row_po->net_price * $row_po->quantity) - $row_po->disc; //Before PPN
			$data['disc'] = $row_po->disc;
			$data['totalall'] = (($row_po->net_price * $row_po->quantity) - $row_po->disc) + round($row_po->tax); //After PPN
			$data['ppn'] = round($row_po->tax);
			
			$data['mirogl'] = $this->fungsi_sap->fm_accno_miro($row_po->miro.$row_po->year);
			
			
		}
	
	$data['menu_path'] = 'ACCOUNTING > DETAIL CPV > '.$row_cpv->nocpvform;
	$data['form_action']= site_url('accounting/postclr/postclr_proc'.'/'.$this->uri->segment(4).'/'.$this->uri->segment(5).'/'.$this->uri->segment(6));
	$this->load->view('accounting/acc_postclr_form', $data);
}

function postclr_proc()
{
		//Cek dulu document CPV sudah ada pada database atau belom ?
	/*if($this->fungsi->check_cpv_bank($this->input->post('txt_nocpvform')) == TRUE)
	{*/
$config = array(
               array(
                     'field'   => 'txt_xblnr',
                     'label'   => 'Reference',
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'txt_bktxt',
                     'label'   => 'Doc Header Text',
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'txt_zounr',
                     'label'   => 'Vendor Assignment',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'txt_sgtxt',
                     'label'   => 'G/L Account Text',
                     'rules'   => 'required'
                  )
            );
	
	
		//Check validasi form
		$this->form_validation->set_rules($config); 	
	
if ($this->form_validation->run() == TRUE)
			{	
			
	//$this->fungsi_sap->fm_post_clr($this->input->post('txt_xblnr'),$this->input->post('txt_bktxt'),$this->input->post('txt_vendor'),$this->input->post('txt_total'),$this->input->post('txt_zounr'),$this->input->post('txt_sgtxt'),$this->input->post('txt_newko2'),$this->input->post('txt_zounr2'),$this->input->post('txt_sgtxt2'));
	/*
	$this->fungsi_sap->fm_post_clr($this->input->post('txt_bldat'), $this->input->post('txt_budat'), $this->input->post('txt_monat'), $this->input->post('txt_xblnr'),$this->input->post('txt_bktxt'),$this->input->post('txt_vendor'),$this->input->post('txt_total2'),$this->input->post('txt_zounr'),$this->input->post('txt_sgtxt2'),$this->input->post('txt_newko2'),$this->input->post('txt_zounr2'),$this->input->post('txt_sgtxt'),$this->input->post('txt_newko3'),$this->input->post('txt_zounr3'),$this->input->post('txt_sgtxt3'),$this->input->post('txt_newko4'),$this->input->post('txt_zounr4'),$this->input->post('txt_sgtxt4'));
*/
//Post vendor payment
$this->fungsi_sap->fm_post_out_pay($this->input->post('txt_bldat'),$this->input->post('txt_budat'),$this->input->post('txt_monat'),$this->input->post('txt_xblnr'),$this->input->post('txt_bktxt'),$this->input->post('txt_newko2'),$this->input->post('txt_total2'),$this->input->post('txt_sgtxt'),$this->input->post('txt_zounr'),$this->input->post('txt_vendor'),$this->input->post('txt_miro'),$this->input->post('txt_sgtxt2'));

	if($this->session->userdata('sap_post_pay_no') != '')
	{	
	
	/* Insert data 
			$bankbal = array( 	'idcab'		 => $this->uri->segment(6),
								'sap_ref'	 => $this->session->userdata('sap_clr_num'),
								'rlis_ref'	 => $this->input->post('txt_nocpvform'),
								'amount'	 => $this->input->post('txt_total2'),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
		*/
			
			
	/* Update data CPV */	
	$cpv = array( 				//'accglpost'		=> 1,
								'clrno' => $this->session->userdata('sap_post_pay_no'),
								'accglpostby'	=> $this->session->userdata('uid'),
								'accglpostdate' => date( 'Y-m-d H:i:s'),
								);
								
	/*Update data PO*/
	$po = array( 		
										'clearno'		 => $this->session->userdata('sap_post_pay_no'),
										'clearaddby'	 => $this->session->userdata('uid'),
										'clearadddate' => date( 'Y-m-d H:i:s'),
								);	
								
	//$this->fin_model->add_bankbal($bankbal);						
	$this->fin_model->update_cpv($this->uri->segment(4), $this->uri->segment(5), $cpv);			
	$this->acc_model->update_po($this->input->post('txt_po'),$this->input->post('txt_poyear'),$po);		
	$this->session->set_flashdata('message_ok', 'Clearing Created, Clearing number :'.$this->session->userdata('sap_post_pay_no'));
	redirect('accounting/acc_gl');	
	}
			}
		else
		{
			
			$this->postclr_form();
			
		}
	/*}
	else
	{
		$this->session->set_flashdata('message_err', 'CPV No :'.$this->input->post('txt_nocpvform'). 'already in database!');
		redirect('accounting/acc_gl');
	}*/
}

}