<?php 
/*
Fungsi : Controller untuk admin menu
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Admin_menu extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
		$this->fungsi->sess_search_segment();
		
	}
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_menu  = 20;
	var $menu_add_menu = 17;
	
	/* Admin add menu view */
	function admin_add_menu()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_menu);
		
		//Kirim value form yang tidak termasuk dalam validasi
		$data['default']['cb_pmenu'] = $this->input->post('cb_pmenu');
		
		/* Generate combox tree menu */
			$query_menu = $this->admin_model->get_menu();
			$data_menu = $query_menu->result();
			$data['menu']='';
			foreach($data_menu as $row)
			{
			$data['menu'] .= $row->mid==$data['default']['cb_pmenu'] ? '<option value="'.$row->mid.'" selected="selected">': '<option value="'.$row->mid.'">';
			$data['menu'] .= $row->mname.'</option>';
      		$data['menu'] .= $this->fungsi->get_menu($row->mid,1, $data['default']['cb_pmenu']);
			}
			
		$data['menu_path'] = 'ADMIN > MENU > ADD MENU';
		$data['form_action']= site_url('admin/admin_menu/add_menu');
		//$data['link'] = array('link_back' => anchor('admin/admin_menu','Back', array('class' => 'back')));
		$this->load->view('admin/admin_menu_form', $data);
		
	}
	
	public function index()
	{	
		$this->admin_add_menu();
		
	}
	
	/* Add menu */
	function add_menu()
	{
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_menu',
                     'label'   => 'Menu name',
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'txt_murl',
                     'label'   => 'Menu URL',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$menu = array( 		'pid'		=>  $this->input->post('cb_pmenu'),
								'mname'		=> $this->input->post('txt_menu'),
								'murl'		=> $this->input->post('txt_murl'),
								'crby'		=> $this->session->userdata('uid'),
								'crdate' 	=> date( 'Y-m-d'),
								'crtime' 	=> date( 'H:i:s' ),
						);
			$this->admin_model->add_menu($menu);
			
			// Set pesan
			$this->session->set_flashdata('message_ok', 'Data input succesfully');
			redirect('admin/admin_menu');
			
			}
		else
		{	
			$this->admin_add_menu();
		}	
	}
	
	/* Display list menu */
	function admin_list_menu()
	{	
		
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_menu);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } else {
                $data['search']  =  $this->session->userdata('sess_search');
            }
		
		
		$menu = $this->admin_model->get_menu_paging($this->config->item('paging_limit'), $offset,$data['search'])->result();
		$num_rows = $this->admin_model->count_rows_menu( $data['search']);
		$config['base_url'] = site_url('admin/admin_menu/admin_list_menu/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('Menu ID', 'Parent ID', 'Name', 'URL', 'Options');
				
					foreach ($menu  as $menus)
					{	
			
		$this->table->add_row($menus->mid, $menus->pid, $menus->mname, $menus->murl,  anchor('admin/admin_menu/edit_menu/'.$menus->mid,'Edit',array('class' => 'update')).'  '.
												anchor('admin/admin_menu/del_menu/'.$menus->mid,'Delete',array('class'=> 'delete','onclick'=>"return confirm('Delete menu with ID ".$menus->mid." ?')")));	
							
					}
					$data['table'] = $this->table->generate();
					
				}
			else
				{
					$data['message'] = 'No data to display';
				}		
		$data['menu_path'] = 'ADMIN > MENU > LIST MENU';
		//$data['link'] = array('link_back' => anchor('admin/admin_menu','Back', array('class' => 'back')));	
		$data['form_action']= site_url('admin/admin_menu/admin_list_menu/');
		$this->load->view('admin/admin_menu_list', $data);
		
	}
	
/* Delete menu */
function del_menu()
{	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('delete'));
	
	$this->admin_model->del_menu($this->uri->segment(4));
	$this->session->set_flashdata('message_ok', 'Menu succesfully delete');
	redirect('admin/admin_menu/admin_list_menu');
}

/* Edit menu */
function edit_menu()
{
		//Get data menu by menu id
		$query_menu_edit = $this->admin_model->get_menu_mid($this->uri->segment(4));
		foreach ($query_menu_edit->result() as $row_menu)
		{	
		//Kirim value form yang tidak termasuk dalam validasi
		$data['default']['txt_murl'] = $row_menu->murl;
		$data['default']['txt_menu'] = $row_menu->mname;
		
		if($this->input->post('button')=='Submit')
		{
			$data['default']['cb_pmenu'] = $this->input->post('cb_pmenu');
		}
		else
		{
			$data['default']['cb_pmenu'] = $row_menu->pid;
		}
		
		}
		
		/* Generate combox tree menu */
			$query_menu = $this->admin_model->get_menu();
			$data_menu = $query_menu->result();
			$data['menu']='';
			foreach($data_menu as $row)
			{
			$data['menu'] .= $row->mid==$data['default']['cb_pmenu'] ? '<option value="'.$row->mid.'" selected="selected">': '<option value="'.$row->mid.'">';
			$data['menu'] .= $row->mname.'</option>';
      		$data['menu'] .= $this->fungsi->get_menu($row->mid,1, $data['default']['cb_pmenu']);
			}
			
		$data['menu_path'] = 'ADMIN > MENU > LIST MENU > EDIT MENU';
		$data['form_action']= site_url('admin/admin_menu/update_menu/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('admin/admin_menu/admin_list_menu','Back', array('class' => 'back')));
		$this->load->view('admin/admin_menu_form', $data);
}

/* Update menu */
function update_menu()
{	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('edit'));
	
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_menu',
                     'label'   => 'Menu name',
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'txt_murl',
                     'label'   => 'Menu URL',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				$menu = array( 	'mname'		=> $this->input->post('txt_menu'),
								'pid'		=> $this->input->post('cb_pmenu'),
								'murl'		=> $this->input->post('txt_murl'),
								'chby'		=> $this->session->userdata('uid'),
								'chdate' 	=> date( 'Y-m-d'),
								'chtime' 	=> date( 'H:i:s' ),
						);
						
				$this->admin_model->update_menu($this->uri->segment(4), $menu);
				$this->session->set_flashdata('message_ok', 'Data succesfully update');
				redirect('admin/admin_menu/admin_list_menu');
			}
		else
			{
				$this->edit_menu();
				
			}
	
	
}

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */