<?php 
/*
Fungsi : Controller untuk group supplier
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Admin_suppgrp extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_suppgrp  = 53;
	var $menu_add_suppgrp = 52;
	
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/	



/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->admin_add_suppgrp();
		
	}

	/* Admin add group supplier */
	function admin_add_suppgrp()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_suppgrp);
			
		$data['menu_path'] = 'ADMIN > SUPPLIER GROUP > ADD GROUP';
		$data['form_action']= site_url('admin/admin_suppgrp/add_suppgrp_proc');
		$this->load->view('admin/admin_suppgrp_form', $data);
		
	}
	
	
	/* Admin add supp group process */
	function add_suppgrp_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		//Config utk validasi deskripsi group supplier
	$config = array(
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Group Name',
                     'rules'   => 'required'
                  )
				  
            );
	
		//Check validasi form
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$groupsupp = array( 	
								'desc'		=> $this->input->post('txt_desc'),
								'addby'		=> $this->session->userdata('uid'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
						);
			$this->admin_model->add_suppgrp($groupsupp);
			
			/*Set pesan sukses dan kembali ke menu add group supplier*/
			$this->session->set_flashdata('message_ok', 'Data saved');
			redirect('admin/admin_suppgrp');
			}
		else
			{
				$this->admin_add_suppgrp();
			}
	}
	
	/* Display list group supplier */
	function admin_list_suppgrp()
	{	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_suppgrp);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
			
		$suppgrp = $this->admin_model->get_suppgrp_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->admin_model->count_all_suppgrp();
		$config['base_url'] = site_url('admin/admin_cabang/admin_list_suppgrp/');
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('Group ID', 'Name', 'Options');
				
					foreach ($suppgrp  as $suppgrps)
					{	
			
		$this->table->add_row($suppgrps->idgroup, $suppgrps->desc, anchor('admin/admin_suppgrp/edit_suppgrp/'.$suppgrps->idgroup,'Edit',array('class' => 'update')).' '.anchor('admin/admin_suppgrp/del_suppgrp/'.$suppgrps->idgroup,'Delete',array('class'=> 'delete','onclick'=>"return confirm('Delete supplier group with ID ".$suppgrps->idgroup." ?')")));	
							
					}
					$data['table'] = $this->table->generate();
					
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'ADMIN > SUPPLIER GROUP > LIST SUPPLIER GROUP';
		$this->load->view('admin/admin_suppgrp_list', $data);
		
	}
	
	/* Delete group supplier */
	function del_suppgrp()
	{	
		//Check otorisasirp
		$this->fungsi->trans_auth($this->session->userdata('delete'));
		
		$this->admin_model->del_suppgrp($this->uri->segment(4));
		$this->session->set_flashdata('message_ok', 'Supplier group deleted');
		redirect('admin/admin_suppgrp/admin_list_suppgrp');
	}
	
	
	/* Edit group supplier */
	function edit_suppgrp()
	{
		
		//Get data detail supplier group by id supplier group
		$sql_suppgrp_edit = $this->admin_model->get_suppgrp_detail($this->uri->segment(4));
		
		foreach ($sql_suppgrp_edit->result() as $row_suppgrp)
		{	
			$data['default']['txt_desc'] = $row_suppgrp->desc;
		}
		
		$data['menu_path'] = 'ADMIN > LIST SUPPLIER GROUP > EDIT SUPPLIER GROUP';
		$data['form_action']= site_url('admin/admin_suppgrp/edit_suppgrp_proc/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('admin/admin_suppgrp/admin_list_suppgrp','Back', array('class' => 'back')));
		$this->load->view('admin/admin_suppgrp_form', $data);
	}
	
	
	/* Admin edit group supplier process */
	function edit_suppgrp_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
		$config = array(
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Group Name',
                     'rules'   => 'required'
                  )
				  
            );
	
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				
			/* Update data */
			$groupsupp = array( 	
								'desc'		=> $this->input->post('txt_desc'),
								'chby'		=> $this->session->userdata('uid'),
								'chdate' 	=> date( 'Y-m-d H:i:s'),
						);
			$this->admin_model->update_suppgrp($this->uri->segment(4), $groupsupp);
			
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data changed');
			redirect('admin/admin_suppgrp/admin_list_suppgrp');
			}
		else
			{
				$this->edit_cabang();
			}
	}
	
}