<?php 
/*
Fungsi : Controller untuk ongkos angkut cabang
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Branch_oa extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_maintain_deliv_cost  = 165;
	
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	


/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('admin/branch_report_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->branch_maintain_oa();
		
	}

/*====================================REPORT MUTASI STOK======================================*/
function branch_maintain_oa()
{
	//Otorisasi menu
	$this->fungsi->menu_auth($this->menu_maintain_deliv_cost);
	
	$data['menu_path'] = 'ADMINISTRATOR > DELIVERY COST > MAINTAIN DELIVERY COST';
	$data['cab'] =   $this->branch_report_model->get_cabang()->result();
		
	$data['form_action']= site_url('admin/branch_oa/branch_maintain_oa_det');
	$this->load->view('admin/branch_report_form_oa', $data);	
		
}

function branch_maintain_oa_det()
{
	$data['idcab'] = $this->uri->segment(4);
	$cab = $this->branch_report_model->get_cabang_byidcab($this->uri->segment(4))->result();
	foreach ($cab  as $cabs);
	
	$data['menu_path'] = 'ADMINISTRATOR > DELIVERY COST > MAINTAIN DELIVERY COST FOR '.strtoupper($cabs->cabname);
	
	$oa = $this->db->query("select * from t_oa_trf WHERE  idcab ='".$this->uri->segment(4)."' ORDER BY valid DESC");	
	
	$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('Valid', 'Price/Ltr', 'Add By', 'Add Date', 'Ch. By', 'Ch. Date', 'Options');
				
					foreach($oa->result() as $oas)
					{
						if($oas->chdate == '0000-00-00 00:00:00')
						{
							$chdate = '';	
						}
						else
						{
							$chdate = date("d.m.Y H:i:s", strtotime($oas->chdate));	
						}	
					$this->table->add_row(date("d.m.Y", strtotime($oas->valid)), $oas->price, $oas->addby, date("d.m.Y H:i:s", strtotime($oas->adddate)), $oas->chby, $chdate,  anchor('admin/branch_oa/branch_edit_oa/'.$oas->idcab.'/'.$oas->valid,'Edit',array('class' => 'update')));	
					}
					
					$data['table'] = $this->table->generate();
					
	$data['form_action']= site_url('admin/branch_oa/branch_maintain_oa_add/'.$this->uri->segment(4));
	$data['link'] = array('link_back' => anchor('admin/branch_oa','Back', array('class' => 'back')));
	$this->load->view('admin/branch_report_form_oa_det', $data);	
}

function branch_maintain_oa_add()
{
	 $config = array(
                array(
                     'field'   => 'txt_price',
                     'label'   => 'Price',
                     'rules'   => 'required|numeric'
                  )
            );
	
	
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				/* Insert data */
			$price = array( 	
								'idcab'	=> $this->uri->segment(4),
								'price'		=> $this->input->post('txt_price'),
								'valid'	=> date("Y-m-d", strtotime($this->input->post('txt_valid'))),
								'addby'		=> $this->session->userdata('uid'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
								
						);
			$this->db->insert('t_oa_trf',$price);
			$this->session->set_flashdata('message_ok', 'Price Added');
			redirect('admin/branch_oa/branch_maintain_oa_det/'.$this->uri->segment(4));
			 
			}
		else
		{
			$this->branch_maintain_oa_det();
		}
	
}

function branch_edit_oa()
{
	$data['menu_path'] = 'ADMINISTRATOR > DELIVERY COST > MAINTAIN DELIVERY COST > EDIT COST';
	
	$oa = $this->db->query("select * from t_oa_trf WHERE  idcab ='".$this->uri->segment(4)."' AND valid = '".$this->uri->segment(5)."' ORDER BY valid DESC")->result();	
	foreach($oa as $oas);
	$data['txt_valid']=	date("d.m.Y", strtotime($oas->valid));
	$data['txt_price']= $oas->price;			
	$data['form_action']= site_url('admin/branch_oa/branch_maintain_oa_update/'.$this->uri->segment(4).'/'.$this->uri->segment(5));
	$data['link'] = array('link_back' => anchor('admin/branch_oa/branch_maintain_oa_det/'.$this->uri->segment(4),'Back', array('class' => 'back')));
	$this->load->view('admin/branch_report_form_oa_edit', $data);	
	
}


function branch_maintain_oa_update()
{
	$config = array(
                array(
                     'field'   => 'txt_price',
                     'label'   => 'Price',
                     'rules'   => 'required|numeric'
                  )
            );
	
	
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				/* Update data */
			$price = array( 
								'price'		=> $this->input->post('txt_price'),
								'chby'		=> $this->session->userdata('uid'),
								'chdate' 	=> date( 'Y-m-d H:i:s'),
								
						);
			$this->db->where('idcab', $this->uri->segment(4));
			$this->db->where('valid', $this->uri->segment(5));
			$this->db->update('t_oa_trf', $price); 

			$this->session->set_flashdata('message_ok', 'Price Changed');
			redirect('admin/branch_oa/branch_maintain_oa_det/'.$this->uri->segment(4));
			 
			}
		else
		{
			$this->branch_edit_oa();
		}
	
}
	
}