<?php 
/*
Fungsi : Controller untuk branch PR
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Branch_pr extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_add_pr  = 55;
	var $menu_print_pr  = 56;

/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	
//Cek valid amount
public function valid_amount($amount)
{
	
	if( ($this->fungsi->convert_idr_to_num($amount) * $this->fungsi->hapus_koma($this->input->post('txt_liter'))) > $this->fungsi->get_pc_bal($this->session->userdata('idcab')))
	{
		$this->form_validation->set_message('valid_amount', 'Error, your petty cash balances is insufficient');
		return false;
	}
	else
	{
		
		return true;
	}
	
}

/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/branch_model', '', TRUE);
		$this->load->model('finance/fin_model', '', TRUE);
		$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->branch_add_pr();		
	}
	
	function branch_add_pr()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_pr);
	
		$data['prev'] = '';
		
		$data['pcbalance'] = $this->fungsi->get_pc_bal($this->session->userdata('idcab'));
		
		$data['menu_path'] = 'BRANCH > PURCHASE REQUISITION > CREATE PR';
		$data['form_action']= site_url('branch/branch_pr/add_pr_prev');
		$this->load->view('branch/branch_pr_form', $data);
	}
	
function add_pr_prev()
	{
		//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('add'));
	
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_amount',
                     'label'   => 'Amount',
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'txt_liter',
                     'label'   => 'Total Liter',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				$data['prev'] = 1;
				
				
				$data['txt_idtop']= $this->input->post('cb_idtop');
				
				$query_top = $this->db->query("SELECT * FROM m_top
				WHERE idtop = '".$this->input->post('cb_idtop')."'")->result();
				foreach ($query_top  as $row_top);
				 $data['top_desc'] = $row_top->desc;
				 
				 
				$data['pcbalance'] = $this->fungsi->get_pc_bal($this->session->userdata('idcab'));
				$data['txt_amount'] =  $this->fungsi->convert_idr_to_num($this->input->post('txt_amount'));
				$data['txt_liter'] = $this->fungsi->hapus_koma($this->input->post('txt_liter'));
				$data['menu_path'] = 'BRANCH > PURCHASE REQUISITION > PREVIEW PR';
				$data['form_action']= site_url('branch/branch_pr/add_pr_proc');
				$this->load->view('branch/branch_pr_form', $data);
				
			}
			else
			{
				$this->branch_add_pr();
			}
		
		
	}
	
	
function add_pr_proc()
{
	
		
				$this->fungsi_sap->fm_create_pr($this->session->userdata('pic'), $this->input->post('txt_liter'), date('d.m.Y'), $this->input->post('txt_amount'));							
										
				if ($this->session->userdata('sap_pr_num') != '')
				{				
				
					/*Insert data PR*/
					$pr = array( 		'idcab'		 => $this->session->userdata('idcab'),
										'preq_no'	 => $this->session->userdata('sap_pr_num'),
										'c_amt_bapi' => $this->input->post('txt_amount'),
										'idtop' => $this->input->post('txt_idtop'),
										'quantity'	 => $this->input->post('txt_liter'),
										'year'	 	 => date('Y'),
										'closed'	 => 0,
										'addby'		 => $this->session->userdata('uid'),
										'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
								
					/*Insert Saldo Petty cash cabang*/
					/*$pcbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
											'ref'	 	 => $this->session->userdata('sap_pr_num'),
											'amount' 	 => ($this->input->post('txt_amount') * $this->input->post('txt_liter')) * -1,
											'addby'		 => $this->session->userdata('uid'),
											'adddate' 	 => date( 'Y-m-d H:i:s'),
								);*/
	
					
			
					$this->branch_model->add_pr($pr);
					
					/*$this->branch_model->add_pc_branch($pcbal);*/
					$this->session->set_flashdata('message_ok', 'Data saved, PR number :'.$this->session->userdata('sap_pr_num'));
		
					redirect('branch/branch_pr/');	
				}
					
}

function list_pr()
{	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Otorisasi menu
	$this->fungsi->menu_auth($this->menu_print_pr);
	
	/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$pr = $this->branch_model->get_list_pr($this->session->userdata('idcab'),$this->config->item('paging_limit'), $offset, 0)->result();
		$num_rows = $this->branch_model->get_list_pr_count($this->session->userdata('idcab'),0);
		
		$config['base_url'] = site_url('branch/branch_pr/list_pr/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
		{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. PR', 'Branch', 'Price/Liter', 'Total Liter', 'Total', 'Add by','Add date','Options');
					
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
					
					foreach ($pr  as $prs)
					{	
						$this->table->add_row($prs->preq_no, $prs->cabname, $this->fungsi->format_idr($prs->c_amt_bapi), number_format($prs->quantity),$this->fungsi->format_idr($prs->c_amt_bapi*$prs->quantity),$prs->addby, $prs->adddate, anchor_popup('#','Print',array('class' => 'print',$atts),$atts));	
					}
					
					$data['table'] = $this->table->generate();
		}		
		else
		{
			
			$data['message'] = 'No data';
			
		}
		
		$data['menu_path'] = 'BRANCH > PURCHASE REQUISITION > LIST OPEN PR';
		$this->load->view('branch/branch_pr_list', $data);
	
	
}	
	


}