<?php 
/*
Fungsi : Controller untuk display lokasi supplier dengan google map
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Branch_supp_map extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_disp_supp_loc  = 152;

/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	


/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		$this->load->model('accounting/acc_report_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->supp_map();		
	}
	
	function detail_supp_data()
	{
		
		$data['menu_path'] = 'ADMINISTRATOR > REPORT BRANCH > SUPPLIER DETAIL';	
		
		$sup = $this->db->query("SELECT  m_cab.icon,
								  m_supp.suppname,
								  m_supp.addr,
								  m_supp.`long`,
								  m_supp.lat,
								  m_supp.city,
								   m_supp.prov,
								   m_supp.phone,
								    m_supp.fax,
								  m_supp.idsupp FROM m_supp
								 INNER JOIN m_cab ON m_supp.idcab = m_cab.idcab
								 WHERE m_supp.idsupp = '".$this->uri->segment(4)."'")->result();
		foreach ($sup  as $sups);
		
		$data['supp_name'] = $sups->suppname;
		$data['supp_alamat'] = $sups->addr;
		$data['supp_city'] = $sups->city;
		$data['supp_proc'] = $sups->prov;
		$data['supp_phone'] = $sups->phone;
		$data['supp_fax'] = $sups->fax;
		$data['supp_lat'] = $sups->lat;
		$data['supp_long'] = $sups->long;
		$this->load->view('branch/branch_supp_map_detail_form', $data);	
	}
	
	function supp_map()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_disp_supp_loc);
	
		$data['menu_path'] = 'ADMINISTRATOR > REPORT BRANCH > DISPLAY SUPPLIER LOCATION';
		if($this->session->userdata('idcab')==1)
		{
			$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		}
		else
		{
			$data['cab'] =   $this->acc_report_model->get_cabang_byidcab($this->session->userdata('idcab'))->result();
		}
		
		$this->load->view('branch/branch_supp_map_form', $data);	
	}
	
	function fetch_supp_data_detail()
	{
		
	  $data = array();
	  $data2 = array();
	  
	   $sql = $this->db->query("SELECT  m_cab.icon,
  m_supp.suppname,
  m_supp.addr,
  m_supp.`long`,
  m_supp.lat,
  m_supp.idsupp FROM m_supp
 INNER JOIN m_cab ON m_supp.idcab = m_cab.idcab
 WHERE m_supp.idsupp = '".$this->input->post('idsupp')."'")->result();
	
	  foreach($sql as $row)
			{
				
				$row_array["idsupp"] = $row->idsupp;
	  			$row_array["name"] = $row->suppname;
				$row_array["addr"] = $row->addr;
				$row_array["long"] = (float)$row->long;
				$row_array["lat"] = (float)$row->lat;
				$row_array["icon"] = $row->icon;
				
	  			array_push($data2, $row_array);
			}
			
		
		echo json_encode($data2);
	}
	
	function fetch_supp_data()
	{
		
	  $data = array();
	  $data2 = array();
	  if($this->input->post('idcab') == 'all')
	  {
		   $sql = $this->db->query("SELECT  m_cab.icon,
  m_supp.suppname,
  m_supp.addr,
  m_supp.`long`,
  m_supp.lat,
  m_supp.idsupp FROM m_supp
 INNER JOIN m_cab ON m_supp.idcab = m_cab.idcab
 WHERE m_supp.lat <> '' AND m_supp.suppname LIKE '%".$this->input->post('txt_search')."%'")->result();
	  }
	  else
	  {
	   $sql = $this->db->query("SELECT  m_cab.icon,
  m_supp.suppname,
  m_supp.addr,
  m_supp.`long`,
  m_supp.lat,
  m_supp.idsupp FROM m_supp
 INNER JOIN m_cab ON m_supp.idcab = m_cab.idcab
 WHERE m_cab.idcab = '".$this->input->post('idcab')."' AND m_supp.lat <> '' AND m_supp.suppname LIKE '%".$this->input->post('txt_search')."%'")->result();
	  }
	  foreach($sql as $row)
			{
				
				$row_array["idsupp"] = $row->idsupp;
	  			$row_array["name"] = $row->suppname;
				$row_array["addr"] = $row->addr;
				$row_array["long"] = (float)$row->long;
				$row_array["lat"] = (float)$row->lat;
				$row_array["icon"] = $row->icon;
				
	  			array_push($data2, $row_array);
			}
			
		
		echo json_encode($data2);
	}
	
	function search_supp_data()
	{
		
	  $data = array();
	  $data2 = array();
	  $sql = $this->db->query("SELECT * FROM m_supp WHERE idcab = '".$this->input->post('idcab')."' AND lat <> '' AND suppname LIKE '%".$this->input->post('txt_search')."%'")->result();
	  
	  foreach($sql as $row)
			{
				
	  			$row_array["name"] = $row->suppname;
				$row_array["addr"] = $row->addr;
				$row_array["long"] = (float)$row->long;
				$row_array["lat"] = (float)$row->lat;
				
	  			array_push($data2, $row_array);
			}
			
		
		echo json_encode($data2);
	}

}