<?php 
/*
Fungsi : Controller untuk branch waste
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Branch_waste extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_print_po  = 59;

/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	
/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/branch_model', '', TRUE);
		$this->load->model('accounting/acc_report_model', '', TRUE);
		//$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
	}
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $waste_trf_post  = 159;
	
/*-------------Inisialisasi variabel--------------*/ 		
	
	public function index()
	{	
		$this->waste_trf_post();		
	}
	
//Transfer posting stock to quality inspection
function waste_trf_post()
{
	//Otorisasi menu
	$this->fungsi->menu_auth($this->waste_trf_post);
	$data['menu_path'] = 'BRANCH > WASTE > WASTE TRANSFER POSTING';
	if($this->session->userdata('idcab')==1)
		{
			$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		}
		else
		{
			$data['cab'] =   $this->acc_report_model->get_cabang_byidcab($this->session->userdata('idcab'))->result();
		}
	$data['form_action']= site_url('branch/branch_waste/waste_trf_post_proc/');
	$this->load->view('branch/branch_waste_form', $data);
	
}

function waste_trf_post_proc()
{
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_matslip',
                     'label'   => 'Material Slip',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'txt_docheader',
                     'label'   => 'Doc Header Text',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'txt_qty',
                     'label'   => 'Quantity',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
			if ($this->form_validation->run() == TRUE)
			{
				
				
				//Get storage location
				$storloc = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
				foreach ($storloc  as $storlocs);
				
				
				//Insert into SAP
				$this->fungsi_sap->fm_create_tp($this->input->post('txt_docheader'), $this->input->post('txt_matslip'),$this->input->post('cb_mvt'),$storlocs->lgort,$storlocs->lgort,'',$this->fungsi->hapus_koma($this->input->post('txt_qty')), $this->input->post('txt_postdate'));
				
				if( $this->session->userdata('sap_tp_num') != '' )
					{
						
						if($this->input->post('cb_mvt') == '322')
						{
							$qty = $this->fungsi->hapus_koma($this->input->post('txt_qty')) * -1;
						}
						else
						{
							$qty = $this->fungsi->hapus_koma($this->input->post('txt_qty')) ;
						}
						
						//Insert into t_waste
						$waste = array(	
						'matslip' => $this->input->post('txt_matslip'),
						'headertext' => $this->input->post('txt_docheader'),
						'mblnr' => $this->session->userdata('sap_tp_num'),
						'idcab'	=> $this->input->post('cb_idcab'),
						'mvt'	=> $this->input->post('cb_mvt'),
						'qty' => $qty,
						'year' => date("Y", strtotime($this->input->post('txt_postdate'))),
						'addby'	=> $this->session->userdata('uid'),
						'postdate' => date("Y-m-d", strtotime($this->input->post('txt_postdate'))),
						'adddate' => date( 'Y-m-d H:i:s'),
								);
						$this->db->insert('t_waste',$waste); 	
							
						//Insert into stock table
						$stock = array(	
						'ref' => $this->session->userdata('sap_tp_num'),
						'idcab'	=> $this->input->post('cb_idcab'),
						'qty' => $qty,
						'year' => date("Y", strtotime($this->input->post('txt_postdate'))),
						'addby'	=> $this->session->userdata('uid'),
						'postdate'  	=> date("Y-m-d", strtotime($this->input->post('txt_postdate'))),
						'adddate' => date( 'Y-m-d H:i:s'),
								);
						$this->branch_model->add_stock($stock);	
						

					$this->session->set_flashdata('message_ok', 'Success, Transfer Posting Number :'.$this->session->userdata('sap_tp_num'));
					redirect('branch/branch_waste/');	
					}
			}
			else
			{
				$this->waste_trf_post();
				
			}
	
}

}