<?php 
/*
Fungsi : Controller untuk op
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cabang_op extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_op  = 62;
	var $menu_add_op = 61;
	
/*-------------Inisialisasi variabel--------------*/

/*------------Fungsi local------------------------*/
//Cek valid Vol
public function valid_vol($volume)
{
	
	if( ($this->fungsi->hapus_koma($this->input->post('vol'))) > ($this->fungsi->hapus_koma($this->input->post('quantity')) - $this->fungsi->get_vol($this->input->post('prnumb'),date('Y'))))
	{
		$this->form_validation->set_message('valid_vol', 'Error, your Volume balances is bigger then Quantity');
		return false;
	}
	else
	{
		
		return true;
	}
	
}	


		
/*------------Fungsi local------------------------*/
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('finance/fin_model', '', TRUE);
		$this->load->model('branch/cabang_model', '', TRUE);
		$this->load->model('branch/branch_model', '', TRUE);
		$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->cabang_add_op();
		
	}
	
	
	
	function add_po()
	
{
	//Cek Saldo Petty cash dulu jika ada pembualatan
	//pembulatan
		$a = ($this->input->get('totpur') + $this->input->get('totfee')) / $this->input->get('totvol');
		if($a != $this->input->get('average'))
		{
			//Check Petty Cash
				if($this->fungsi->get_pc_bal($this->session->userdata('idcab')) < abs(($a - $this->input->get('average')) * $this->input->get('totvol')))
				{
					$this->session->set_flashdata('message_err', 'Error, Your Petty Cash Balances Is Insufficient!');
					redirect('branch/cabang_op');
					
				}
		}
	//Edit PR
	$this->fungsi_sap->fm_edit_pr($this->input->get('nopr'),$this->input->get('totvol'),$this->input->get('average'),$this->session->userdata('pic'));
	
	//Create PO
	$this->fungsi_sap->fm_create_po($this->session->userdata('lifnr'), $this->session->userdata('lgort'),$this->input->get('average'),$this->input->get('nopr'),$this->session->userdata('pic'));
	
	//Sleep 2 detik
	sleep(2);
	//MIGO
	$this->fungsi_sap->fm_create_migo($this->session->userdata('sap_po_num'),$this->session->userdata('lgort'),$this->session->userdata('lifnr'),$this->session->userdata('cabshorttxt'),'Used Oil',$this->input->get('totvol'),$this->session->userdata('sap_po_num'));
	
	//Update status PR = Close
	$pr = array(        'c_amt_bapi' => $this->input->get('average'),
						'quantity'	 => $this->input->get('totvol'),
						'closed'	 => 1,
						'clby'		 => $this->session->userdata('uid'),
						'cldate' 	 => date( 'Y-m-d H:i:s'),
								);
	//Insert PO Data
	$po = array(		'ebeln' => $this->session->userdata('sap_po_num'),
						'idcab'	=> $this->session->userdata('idcab'),
						'preq_no' => $this->input->get('nopr'),
						'vendor' => $this->session->userdata('lifnr'),
						'mblnr' => $this->session->userdata('sap_migo_num'),
						'year' => date('Y'),
				       	'net_price' => $this->input->get('average'),
						'quantity'	 => $this->input->get('totvol'),
						'addby'		 => $this->session->userdata('uid'),
						'adddate' 	 => date( 'Y-m-d H:i:s'),
						);
	/*Insert Saldo Petty cash cabang*/
		/*$pcbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 	 => $this->session->userdata('sap_po_num'),
								'amount' 	=> ( $row_pr->c_amt_bapi * $row_pr->quantity ) * -1,
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);*/
	if( $this->session->userdata('sap_po_num') != '' )
	{
		$this->branch_model->update_pr($this->input->get('nopr'),$this->input->get('year'),$pr);							
		$this->branch_model->add_po($po);
		
		//pembulatan
		$a = ($this->input->get('totpur') + $this->input->get('totfee')) / $this->input->get('totvol');
		if($a != $this->input->get('average'))
		{
			//echo abs(($a - $this->input->get('average')) * $this->input->get('totvol'));
			/*Get OP counter*/
		$count = array();
		$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'OP');
		$noopform = $count[0];
		$noop = $count[1];

/* Insert data op */
			$op_fee = array( 	'c_amt_bapi'=> $this->fungsi->hapus_koma($this->input->post('c_amt_bapi')),
								'prnumb'	=> $this->input->get('nopr'),
								'opnumb'	=> $noopform,
								'idcab'		=> $this->session->userdata('idcab'),
								'type'	    => $this->input->post('type'),
								'idsupp'	=> $this->input->post('idsupp'),
								'idtrans'	=> $this->input->post('idtrans'),
								'pur'		=> $this->fungsi->hapus_koma($this->input->post('pur')),
								'fee'		=>  abs(($a - $this->input->get('average')) * $this->input->get('totvol')),
								'quantity'	=> $this->fungsi->hapus_koma($this->input->post('quantity')),
								'invoice'	=> $this->input->post('invoice'),
								'vol'		=> $this->input->post('vol'),
								'vnumb'  	=> $this->input->post('vnumb'),
								'total'	    => $this->fungsi->hapus_koma($this->input->post('total')),
								'donumb'	=> $this->input->post('donumb'),
								'year'	    => date('Y'),
								'mnfst'	    => $this->input->post('mnfst'),
								'inf'	    => 'PEMBULATAN',
								'adddate' 	=> date( 'Y-m-d H:i:s'),
								'addby'		=> $this->session->userdata('uid'),
								);
				/*Insert to t_pcbal*/
					$pcbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
											'ref'	 	 => $noopform,
											'amount' 	 => abs(($a - $this->input->get('average')) * $this->input->get('totvol')) * -1,
											'addby'		 => $this->session->userdata('uid'),
											'adddate' 	 => date( 'Y-m-d H:i:s'),
								);

			$this->cabang_model->add_op_fee($op_fee);
			$this->branch_model->add_pc_branch($pcbal);


		}
		//Update petty cash balance
		//$this->branch_model->add_pc_branch($pcbal);
	}
	
	
	if( $this->session->userdata('sap_migo_num') != '' )
	{
		//Insert ke table stock
		//Insert Stock
		$stock = array(	'ref' => $this->session->userdata('sap_migo_num'),
						'idcab'	=> $this->session->userdata('idcab'),
						'qty' => $this->input->get('totvol'),
						'year' => date('Y'),
						'addby'	=> $this->session->userdata('uid'),
						'adddate' => date( 'Y-m-d H:i:s'),
								);
		$this->branch_model->add_stock($stock);	
		
		//Email to accounting
		//send email notification
		$total = $this->input->get('average') * $this->input->get('totvol');
			$var = array($this->session->userdata('sap_migo_num'), $this->session->userdata('uid'),$this->session->userdata('sap_po_num'),number_format($this->input->get('totvol')), $this->fungsi->format_idr($total) );
			$this->fungsi->send_notif(11, $var);
	}
	
	$this->session->set_flashdata('message_ok', 'PO Created, PO number :'.$this->session->userdata('sap_po_num'));
	redirect('branch/branch_po/list_po');	
}


	
	/* Cabang add op dan hitung pembelian oli*/
	function cabang_add_op()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_op);
		$data['menu_path'] = 'BRANCH > OIL PURCHASE > ADD OIL PURCHASE';
		$data['form_action']= site_url('branch/cabang_op/add_op_proc');
		$data['form_action2']= site_url('branch/cabang_op/add_po');
		$this->load->view('branch/cabang_op_form', $data);
		
	}
			
	/* Cabang add op process */
	function add_op_proc()
	{	
			
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		
		/*-----------------------------------------Check Saldo------------------------------------------------*/
		if($this->input->post('type2') == 2)
			{
		//Check Saldo Bank
				if($this->fungsi->get_bank_bal($this->session->userdata('idcab')) < $this->fungsi->hapus_koma($this->input->post('pur')))
				{
					$this->session->set_flashdata('message_err', 'Error, Your Bank Balances Is Insufficient!');
					redirect('branch/cabang_op');
					
				}
			}
		else
			{
		//Check Petty Cash
				if($this->fungsi->get_pc_bal($this->session->userdata('idcab')) < $this->fungsi->hapus_koma($this->input->post('pur')))
				{
					$this->session->set_flashdata('message_err', 'Error, Your Petty Cash Balances Is Insufficient!');
					redirect('branch/cabang_op');
					
				}
			}
		/*-----------------------------------------Check Saldo------------------------------------------------*/
		
		
		$data['prev'] = '';
		
		//Config utk validasi form op
	$op = array(
                  array(
                     'field'   => 'donumb',
                     'label'   => 'DO Number',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'invoice',
                     'label'   => 'Invoice',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'mnfst',
                     'label'   => 'Manifest',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'vnumb',
                     'label'   => 'Vehicle Number',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'vol',
                     'label'   => 'Volume',
                     'rules'   => 'required|callback_valid_vol'
                  ),
				  array(
                     'field'   => 'pur',
                     'label'   => 'Purchase Price ',
                     'rules'   => 'required'
                  )
				  //Not validate form
				  ,array(
                     'field'   => 'idsupp',
                     'label'   => 'ID Supplier',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'idtrans',
                     'label'   => 'ID Transporter',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'adddate',
                     'label'   => 'Add Date',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'chdate',
                     'label'   => 'Change Date',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'chby',
                     'label'   => 'Change By',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'addby',
                     'label'   => 'Add By',
                     'rules'   => ''
                  )
				   //Not validate form
            );
			
		//Data Type form
		$this->load->helper('form'); 
		
		
	
		//Check validasi form
		$this->form_validation->set_rules($op); 
		
		if ($this->form_validation->run() == TRUE)
			{
			
			
			/*Get OP counter*/
			$count = array();
			$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'OP');
			$noopform = $count[0];
			$noop = $count[1];
		
			/* Insert data op */
			$op = array( 		'c_amt_bapi'=> $this->fungsi->hapus_koma($this->input->post('c_amt_bapi')),
								'prnumb'	=> $this->input->post('prnumb'),
								'opnumb'	=> $noopform,
								'idcab'		=> $this->session->userdata('idcab'),
								'type'	    => $this->input->post('type'),
								'idsupp'	=> $this->input->post('idsupp'),
								'idtrans'	=> $this->input->post('idtrans'),
								'idstb'	    => $this->input->post('idstb'),
								'pur'		=> $this->fungsi->hapus_koma($this->input->post('pur')),
								'fee'		=> $this->fungsi->hapus_koma($this->input->post('fee')),
								'quantity'	=> $this->fungsi->hapus_koma($this->input->post('quantity')),
								'invoice'	=> $this->input->post('invoice'),
								'vol'		=> $this->input->post('vol'),
								'vnumb'  	=> $this->input->post('vnumb'),
								'total'	    => $this->fungsi->hapus_koma($this->input->post('total')),
								'donumb'	=> $this->input->post('donumb'),
								'year'	    => date('Y'),
								'mnfst'	    => $this->input->post('mnfst'),
								'inf'	    => $this->input->post('inf'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
								'chdate'	=> $this->input->post('chdate'),
								'chby'		=> $this->input->post('chby'),
								'addby'		=> $this->session->userdata('uid'),
								
						);
		/* Jika pilihan transfer dari Bank */
			if($this->input->post('type2') == 2)
			{
				//Journal SAP
				//Get G/L Account info
					$query_get_cab = $this->admin_model->get_cab_detail($this->session->userdata('idcab'));
					foreach ($query_get_cab->result() as $row_cab);
				
					//Post G/L Account 
					$accountgl[] = array( 'ITEMNO_ACC' => 1,
								'GL_ACCOUNT' => $row_cab->pcglaccuo,
								'PSTNG_DATE' => date('d.m.Y'),
								'FIS_PERIOD' => date('d.m.Y'),
								'ALLOC_NMBR' => $row_cab->cabshorttxt.date('M').'\''.date('y'),
								'ITEM_TEXT'	 => '4905 -'.strtoupper($row_cab->cabshorttxt).'- P.Cash Used Oil '.$nocpvform,
								);
					$accountgl[] = array( 'ITEMNO_ACC' => 2,
								'GL_ACCOUNT' => $row_cab->pcbankglacc,
								'PSTNG_DATE' => date('d.m.Y'),
								'FIS_PERIOD' => date('d.m.Y'),
								'ALLOC_NMBR' => $row_cab->cabshorttxt.date('M').'\''.date('y'),
								'ITEM_TEXT'	 => strtoupper($row_cab->cabshorttxt).'- P.Cash Used Oil '.$nocpvform,
								);
								
					$curramount[] = array( 		'ITEMNO_ACC' => 1,
												'AMT_DOCCUR' =>$this->fungsi->hapus_koma($this->input->post('pur')),
												);
					$curramount[] = array( 		'ITEMNO_ACC' => 2,
												'AMT_DOCCUR' =>$this->fungsi->hapus_koma($this->input->post('pur')) * -1,
												);
					
						/*Get CPV counter*/
						$count = array();
						$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'CPV');
						$nocpvform = $count[0];
						$nocpv = $count[1];
						
						/*Get PC counter*/
						$count1 = array();
						$count1 = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'PC');
						$nopcform = $count1[0];
						$nopc = $count1[1];
									
					$this->fungsi_sap->fm_post_gl_acc($nopcform,date('d.m.Y'),$nocpvform,  $accountgl,$curramount);							
				if ($this->session->userdata('sap_obj_key') != '')
				{				
				
					/*Update Saldo bank*/
					$bankbal = array( 	'idcab'		 => $this->session->userdata('idcab'),
										'sap_ref'	 => $this->session->userdata('sap_obj_key'),
										'rlis_ref'	 => $nocpvform,
										'amount'	 => $this->fungsi->hapus_koma($this->input->post('pur')) * -1,
										'addby'		 => $this->session->userdata('uid'),
										'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
					
		
					/*Insert PC cabang*/
				$cpv = array( 	'idcab'		 => $this->session->userdata('idcab'),
								'nopcform'	 => $nocpvform,
								'nopc'	 	 => $nocpv,
								'year'		 => date('Y'),
								'pctyp'		 => 1,
								'amount' 	 => $this->fungsi->hapus_koma($this->input->post('pur')),
								'desc'		 => $this->input->post('inf'),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								'accglno' 	 => $this->session->userdata('sap_obj_key'),
								);
			
					$this->fin_model->add_bankbal($bankbal);
					$this->branch_model->add_cpv($cpv);	
				}
					
				
			}
		
		else
		{				
					/*Insert to t_pcbal*/
		$pcbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 => $noopform,
								'amount' 	 => $this->fungsi->hapus_koma($this->input->post('pur')) * -1,
								
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
			/*Insert to t_stockbal*/
		/*$salbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 => $noopform,
								'qty'		 => $this->input->post('vol'),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);*/
			$this->branch_model->add_pc_branch($pcbal);
		}	
			$this->cabang_model->add_op($op);
			//$this->cabang_model->add_saldo_branch($salbal);
			/*Set pesan sukses dan kembali ke menu add op*/
			
			$this->session->set_flashdata('prnumb', $this->input->post('prnumb'));
			$this->session->set_flashdata('message_ok', 'Data saved, Purchase number :'.$noopform);
			redirect('branch/cabang_op');
			}
		else
			{
				$this->cabang_add_op();
			}
	}
	

/*Print OP*/
function print_op_popup()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Get data for print
	$query_op = $this->cabang_model->get_list_op_print_paging($this->uri->segment(4));
	foreach ($query_op->result() as $row_op)
		{
			$data['prnumb'] = $row_op->prnumb;
			$data['opnumb'] = $row_op->opnumb;
			$data['adddate'] = date("d.m.Y",   strtotime($row_op->adddate));	
			$data['pur'] = $row_op->pur;
			$data['inf'] = $row_op->inf;
			$data['vol'] = $row_op->vol;
			$data['suppname'] = $row_op->suppname;
			$data['idtrans'] = $row_op->idtrans;
			$data['addby'] = $row_op->addby;
			$data['idcab'] = $row_op->idcab;
			$data['type'] = $row_op->type;
			$data['txt_terbilang'] = $this->fungsi->terbilang($row_op->pur).' RUPIAH';
			}
//Get data detail cabang by id cabang
				$sql_cab_detail = $this->admin_model->get_cab_detail($row_op->idcab);
				foreach ($sql_cab_detail->result() as $row_cab)
				{	
					$data['cabname'] = $row_cab->cabname;
				}
$this->load->view('popup/popup_bpkk', $data);
	
}

	
	
	/* Display list op */
	function cabang_list_op()
	{	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_op);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
			
		$op = $this->cabang_model->get_op_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->cabang_model->count_all_op();
		$config['base_url'] = site_url('branch/cabang_op/cabang_list_op/');
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No.','ID OP', 'PR Number', 'Purchase', 'Fee', 'Vol', 'Info', 'Options');
				    
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
				
					foreach ($op  as $ops)
					{	
			
		$this->table->add_row($ops->idop, $ops->opnumb, $ops->prnumb,$ops->pur, $ops->fee,$ops->vol, $ops->inf, anchor('branch/cabang_op/edit_op/'.$ops->idop.'/'.$ops->year,'Cancel',array('class' => 'update')).' '.anchor_popup('branch/cabang_op/print_op_popup/'.$ops->idop,'Print',array('class'=> 'print',$atts),$atts));
		
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'BRANCH > OP > OP LIST';
		$this->load->view('branch/cabang_op_list', $data);
		
	}
	

	
	
	/* Edit op */
	function edit_op()
	{
		
		//Get data detail op by id cabang
		$sql_op_edit = $this->cabang_model->get_op_detail($this->uri->segment(4));
		
		foreach ($sql_op_edit->result() as $row_op)
		{	
			$data['default']['idcab']   = $row_op->idcab;
			$data['default']['vol']     = $row_op->vol;
			$data['default']['type']    = $row_op->type;
			$data['default']['idsupp']  = $row_op->idsupp;
			$data['default']['idtrans'] = $row_op->idtrans;
			$data['default']['vnumb']   = $row_op->vnumb;
			$data['default']['prnumb']  =  $row_op->prnumb;
			$data['default']['donumb']  =  	$row_op->donumb;
			$data['default']['mnfst']   =  $row_op->mnfst;
			$data['default']['inf']     = $row_op->inf;
			$data['default']['invoice']     = $row_op->invoice;
			$data['default']['adddate'] =  $row_op->adddate;
			$data['default']['chdate']  =  $row_op->chdate;
			$data['default']['chby']    =  $row_op->chby;
			$data['default']['addby']   =  $row_op->addby;
		}
		$data['default']['readonly'] =  'readonly="readonly"';
		
		$data['menu_path'] = 'BRANCH > OIL PURCHASE > LIST OIL PURCHASE';
		$data['form_action']= site_url('branch/cabang_op/edit_op_proc/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('branch/cabang_op/cabang_list_op','Back', array('class' => 'back')));
		$this->load->view('branch/cabang_op_cancel', $data);
	}
	
	
	/* Cabang edit op process */
	function edit_op_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
		//Config utk validasi form op
 $config = array(
 					array(
                     'field'   => 'idtrans',
                     'label'   => 'ID Transporter',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'adddate',
                     'label'   => 'Add Date',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'chdate',
                     'label'   => 'Change Date',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'chby',
                     'label'   => 'Change By',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'addby',
                     'label'   => 'Add By',
                     'rules'   => ''
                  )
				   //Not validate form
            );
	
	
		$this->form_validation->set_rules($config); 
		
		/*Get OP Cancel Counter*/
		$count = array();
		$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'OPC');
		$noopcform = $count[0];
		$noopc = $count[1];
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$op_cancel = array( 		/*'c_amt_bapi'=> $this->input->post('c_amt_bapi'),
								'prnumb'	=> $this->input->post('prnumb'),
								'opnumb'	=> $this->input->post('opnumb'),
								'idcab'		=> $this->input->post('idcab'),
								'type'	    => $this->input->post('type'),
								'idsupp'	=> $this->input->post('idsupp'),
								'idtrans'	=> $this->input->post('idtrans'),
								'pur'		=> $this->input->post('pur'),
								'fee'		=> $this->input->post('fee'),
								'freight'	=> $this->input->post('freight'),
								'other'		=> $this->input->post('other'),
								'quantity'	=> $this->input->post('quantity'),
								'invoice'	=> $this->input->post('invoice'),
								'vol'		=> $this->input->post('vol'),
								'vnumb'  	=> $this->input->post('vnumb'),
								'total'	    => $this->input->post('total'),
								'donumb'	=> $this->input->post('donumb'),
								'year'	    => $this->input->post('year'),
								'mnfst'	    => $this->input->post('mnfst'),
								'invoice'   => $this->input->post('invoice'),
								'inf'	    => $this->input->post('inf'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),*/
								'chdate'	=> date( 'Y-m-d H:i:s'),
								'chby'		=> $this->session->userdata('uid'),
								'cancel'		=> 1,
								
						);
						
					/*Insert to t_pcbal*/
					$pcbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
											'ref'	 	 => $noopcform,
											'amount' 	 => $this->fungsi->hapus_koma($this->input->post('fee')),
											'addby'		 => $this->session->userdata('uid'),
											'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
								
			/*Insert to t_stockbal*/
		$salbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 => $noopcform,
								'qty'		 => $this->input->post('vol'),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
								
			$this->cabang_model->update_op($this->input->post('idop'), $op_cancel);
			$this->branch_model->add_pc_branch($pcbal);
			$this->cabang_model->add_saldo_branch($salbal);
			
			/*Set pesan sukses dan kembali ke menu add op*/
			$this->session->set_flashdata('message_ok', 'Data CANCELED');
			redirect('branch/cabang_op/cabang_list_op');
			}
		else
			{
				$this->edit_op();
			}
	}
	
}