<?php 
/*
Fungsi : Controller untuk supllier
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cabang_supp extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_supp  = 48;
	var $menu_add_supp = 47;
	
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/	
/* Fungsi untuk convert status supp */
 	function convert_status_supp($status)
	{
		
		switch ($status)
		{
			case 1:
			  $status = '<font color="#00CC00"><b>Active</b></font>';
			  break;
			case 0:
			  $status = '<font color="#FF0000"><b>Not active</b></font>';
			  break;
		}
	
	return $status;
		
	}
	
	/* Fungsi untuk convert status ppn */
 	function convert_ppn($ppn)
	{
		
		switch ($ppn)
		{
			case 1:
			  $ppn = '<b>Ya</b>';
			  break;
			case 0:
			  $ppn = '<b>Tidak</b>';
			  break;
		}
	
	return $ppn;
		
	}
	/* Fungsi untuk convert status Jenis pembayaran */
 	function convert_idtop($idtop)
	{
		
		switch ($idtop)
		{
			case 1:
			  $idtop = '<b>Credit</b>';
			  break;
			case 0:
			  $idtop = '<b>Cash</b>';
			  break;
		}
	
	return $idtop;
		
	}
	
	
/* Check ID supplier exist */
	public function idsupp_check($idsupp)
	{	
		$sql_idsupp_check = $this->cabang_model->search_idsupp($idsupp)->result();
		
		if ($this->fungsi->is_array_empty($sql_idsupp_check)==FALSE) 
		{
			$this->form_validation->set_message('idsupp_check', '%s '.$idsupp.' already exist, please choose another ID');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}

/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/cabang_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->cabang_add_supp();
		
	}

	/* Cabang add supplier */
	function cabang_add_supp()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_supp);
			
		$data['menu_path'] = 'BRANCH > SUPPLIER > ADD SUPPLIER';
		$data['form_action']= site_url('branch/cabang_supp/add_supp_proc');
		$this->load->view('branch/cabang_supplier_form', $data);
		
	}
	
	
	/* Admin add supp process */
	function add_supp_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		//Config utk validasi form supp
	$config = array(
                  array(
                     'field'   => 'suppname',
                     'label'   => 'Name',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'pic',
                     'label'   => 'PIC Supp',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'noijin',
                     'label'   => 'No Ijin',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'long',
                     'label'   => 'Longitude',
                     'rules'   => ''
                  ),
				  array(
                     'field'   => 'lat',
                     'label'   => 'Latitude',
                     'rules'   => ''
                  ),
				  array(
                     'field'   => 'codevendor',
                     'label'   => 'Code Vendor SAP',
                     'rules'   => ''
                  )
				  
				  //Not validate form
				  
				  ,array(
                     'field'   => 'idcab',
                     'label'   => 'ID Cabang',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'status',
                     'label'   => 'Status Supp',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'addr',
                     'label'   => 'Addres Supp',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'city',
                     'label'   => 'City',
                     'rules'   => ''
                  ) 
				   ,array(
                     'field'   => 'prov',
                     'label'   => 'Province',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'fax',
                     'label'   => 'Fax',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'phone',
                     'label'   => 'Telephone',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'idtop',
                     'label'   => 'TOP',
                     'rules'   => ''
                  ) 
				  ,array(
                     'field'   => 'ppn',
                     'label'   => 'ppn',
                     'rules'   => ''
                  )
				 
				   //Not validate form
            );
	
	
		//Check validasi form
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data supplier */
			$supp = array( 	    'suppname'  => $this->input->post('suppname'),
								'idcab'	    => $this->session->userdata('idcab'),
								'addr'		=> $this->input->post('addr'),
								'city'	    => $this->input->post('city'),
								'prov'		=> $this->input->post('prov'),
								'pic'		=> $this->input->post('pic'),
								'phone'		=> $this->input->post('phone'),
								'mobile'	=> $this->input->post('mobile'),
								'fax'		=> $this->input->post('fax'),
								'noijin'	=> $this->input->post('noijin'),
								'status'	=> $this->input->post('status'),
								'long'	=> $this->input->post('long'),
								'lat'	=> $this->input->post('lat'),
								'idtop'	=> $this->input->post('idtop'),
								'ppn'	=> $this->input->post('ppn'),
								'kelompok'	=> $this->input->post('kelompok'),
								'pass'	=> $this->input->post('pass'),
								'codevendor'	=> $this->input->post('codevendor'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
								'addby'		=> $this->session->userdata('uid'),
								
						);
			$this->cabang_model->add_supp($supp);
			
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data saved');
			redirect('branch/cabang_supp');
			}
		else
			{
				$this->cabang_add_supp();
			}
	}
	
	/* Display list supp */
	function cabang_list_supp()
	{	
	
	
	    //Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_supp);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } 
			else 
			{
                $data['search']  =  $this->session->userdata('sess_search');
            }
				
		$supp = $this->cabang_model->get_supp_paging($this->config->item('paging_limit'), $offset,$data['search'])->result();
		
		$num_rows = $this->cabang_model->count_all_supp( $data['search']);
		$config['base_url'] = site_url('branch/cabang_supp/cabang_list_supp/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('Supp ID / User', 'Name', 'PIC', 'Status', 'TOP','Ppn','Pass' ,'Options');
				
					foreach ($supp as $supps)
					{	
			
		$this->table->add_row($supps->idsupp, $supps->suppname, $supps->pic, $this->convert_status_supp($supps->status), $this->convert_idtop($supps->idtop), $this->convert_ppn($supps->ppn), $supps->pass, anchor('branch/cabang_supp/edit_supp/'.$supps->idsupp,'Edit',array('class' => 'update')).'  '.anchor('branch/cabang_supp/del_supp/'.$supps->idsupp,'Delete',array('class'=> 'delete','onclick'=>"return confirm('Delete supp with ID ".$supps->idsupp." ?')")));		
							
					}
					$data['table'] = $this->table->generate();
					
				}
			else
				{
					$data['message'] = 'No data To Display';
				}		
		$data['menu_path'] = 'BRANCH > SUPPLIER > SUPPLIER LIST';
		$data['form_action']= site_url('branch/cabang_supp/cabang_list_supp/');
		$this->load->view('branch/cabang_supp_list', $data);
		
	}
	
	function del_supp()
{	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('delete'));
	
	$this->cabang_model->del_supp($this->uri->segment(4));
	$this->session->set_flashdata('message_ok', 'Supplier succesfully delete');
	redirect('branch/cabang_supp/cabang_list_supp');
}
	
	/* Edit Supp */
	function edit_supp()
	{
		
		//Get data detail cabang by id supp
		$sql_supp_edit = $this->cabang_model->get_supp_detail($this->uri->segment(4));
		
		foreach ($sql_supp_edit->result() as $row_supp)
		{	
			$data['default']['idsupp'] = $row_supp->idsupp;
			$data['default']['suppname'] = $row_supp->suppname;
			$data['default']['status'] = $row_supp->status;
			$data['default']['pic'] = $row_supp->pic;
			$data['default']['addr'] = $row_supp->addr;
			$data['default']['noijin'] = $row_supp->noijin;
			$data['default']['prov'] = $row_supp->prov;
			$data['default']['city'] =  $row_supp->city;
			$data['default']['fax'] =  	$row_supp->fax;
			$data['default']['phone'] =  $row_supp->phone;
			$data['default']['idtop'] =  $row_supp->idtop;
			$data['default']['ppn'] =  $row_supp->ppn;
			$data['default']['kelompok'] =  $row_supp->kelompok;
			$data['default']['mobile'] = $row_supp->mobile;
			$data['default']['pass'] =  $row_supp->pass;
			$data['default']['long'] =  $row_supp->long;
			$data['default']['lat'] =  $row_supp->lat;
			$data['default']['codevendor'] =  $row_supp->codevendor;
		}
		$data['default']['readonly'] =  'readonly="readonly"';
		
		$data['menu_path'] = 'BRANCH > SUPPLIER > EDIT SUPPLIER';
		$data['form_action']= site_url('branch/cabang_supp/edit_supp_proc/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('branch/cabang_supp/cabang_list_supp','Back', array('class' => 'back')));
		$this->load->view('branch/cabang_supplier_form', $data);
	}
	
	
	/* Cabang edit supplier process */
	function edit_supp_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
		//Config utk validasi form supplier
 $config = array(
                  array(
                     'field'   => 'suppname',
                     'label'   => 'Name',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'pic',
                     'label'   => 'PIC Supp',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'noijin',
                     'label'   => 'No Ijin',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'codevendor',
                     'label'   => 'Code Vendor SAP',
                     'rules'   => ''
                  )
				  
				  //Not validate form
				  
				  ,array(
                     'field'   => 'idcab',
                     'label'   => 'ID Cabang',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'status',
                     'label'   => 'Status Supp',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'addr',
                     'label'   => 'Addres Supp',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'city',
                     'label'   => 'City',
                     'rules'   => ''
                  ) 
				   ,array(
                     'field'   => 'prov',
                     'label'   => 'Province',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'fax',
                     'label'   => 'Fax',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'phone',
                     'label'   => 'Telephone',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'idtop',
                     'label'   => 'TOP',
                     'rules'   => ''
                  ) ,array(
                     'field'   => 'ppn',
                     'label'   => 'ppn',
                     'rules'   => ''
                  )
				   //,array(
//                     'field'   => 'adddate',
//                     'label'   => 'Add Date',
//                     'rules'   => ''
//                  )
//				    ,array(
//                     'field'   => 'chdate',
//                     'label'   => 'Change Date',
//                     'rules'   => ''
//                  )
//				    ,array(
//                     'field'   => 'chby',
//                     'label'   => 'Change By',
//                     'rules'   => ''
//                  )
//				    ,array(
//                     'field'   => 'addby',
//                     'label'   => 'Add By',
//                     'rules'   => ''
//                  )
				   //Not validate form
            );
	
	
		$this->form_validation->set_rules($config); 
		{
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$supp = array( 	
								'suppname'	=> $this->input->post('suppname'),
								'idcab'		=> $this->session->userdata('idcab'),
								'addr'		=> $this->input->post('addr'),
								'city'	    => $this->input->post('city'),
								'prov'		=> $this->input->post('prov'),
								'pic'		=> $this->input->post('pic'),
								'phone'		=> $this->input->post('phone'),
								'kelompok'	=> $this->input->post('kelompok'),
								'idgroup'	=> $this->input->post('idgroup'),
								'mobile'	=> $this->input->post('mobile'),
								'fax'		=> $this->input->post('fax'),
								'noijin'	=> $this->input->post('noijin'),
								'status'	=> $this->input->post('status'),
								'long'   	=> $this->input->post('long'),
								'lat'	    => $this->input->post('lat'),
								'idtop'	=> $this->input->post('idtop'),
								'ppn'	=> $this->input->post('ppn'),
								'kelompok'	=> $this->input->post('kelompok'),
								'pass'  	=> $this->input->post('pass'),
								'codevendor'	=> $this->input->post('codevendor'),
								'chdate'	=> date( 'Y-m-d H:i:s'),
								'chby'		=> $this->session->userdata('uid'),
								
						);
			$this->cabang_model->update_supp($this->uri->segment(4), $supp);
			
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data changed');
			redirect('branch/cabang_supp/cabang_list_supp');
			}
		else
			{
				$this->edit_supp();
			}
		}
	}	
}