<?php 
/*
Fungsi : Controller untuk qa
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manager_qa extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_qa  = 97;
	var $menu_add_qa = 61;
	
/*-------------Inisialisasi variabel--------------*/ 

/*------------Fungsi local------------------------*/
	
/*------------Fungsi local------------------------*/
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/cabang_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->manager_add_qa();
		
	}
	
	
	function manager_add_qa()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_qa);
		$data['menu_path'] = 'BRANCH > QUALITY > QUALITY CONTROL';
		$data['form_action']= site_url('branch/manager_qa/manager_add_qa_proc');
		
		$this->load->view('branch/manager_qa_form', $data);
		
	}
			
	/* manager add qa process */
	function manager_add_qa_proc()
	{	
			
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		$data['prev'] = '';
		
		
		/*Get BA counter*/
		$count = array();
		$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'BA');
		$nobaform = $count[0];
		$noba = $count[1];
		
		//Config utk validasi form qa
	$config = array(
                  array(
                     'field'   => 'qctbk',
                     'label'   => 'Chemical',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'qcair',
                     'label'   => 'Water Content',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'qcbakar',
                     'label'   => 'Fuel',
                     'rules'   => 'required'
                  )
				  //Not validate form
				    ,array(
                     'field'   => 'qcresidu',
                     'label'   => 'Residu',
                     'rules'   => 'required'
                  )
				    ,array(
                     'field'   => 'qct',
                     'label'   => 'Temperature',
                     'rules'   => 'required'
                  )
				    ,array(
                     'field'   => 'adj',
                     'label'   => 'Volume Adjustment',
                     'rules'   => 'required'
                  )
				    ,array(
                     'field'   => 'addby',
                     'label'   => 'Add By',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'adddate',
                     'label'   => 'Add Date',
                     'rules'   => ''
                  )
				   //Not validate form
            );
			
		//Data Type form
		$this->load->helper('form'); 
		
		
	
		//Check validasi form
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data qa */
			$ba = array( 		'idba'	=> $nobaform,
								'idcab'		=> $this->session->userdata('idcab'),
								'qct'	    => $this->input->post('qct'),
								'qcair'		=> $this->input->post('qcair'),
								'qctbk'		=> $this->input->post('qctbk'),
								'qcbakar'	=> $this->input->post('qcbakar'),	
								'qcresidu'	=> $this->input->post('qcresidu'),
								'vol'		=> $this->fungsi->hapus_koma($this->input->post('vol')),
								'adj'  		=> $this->fungsi->hapus_koma($this->input->post('adj')),
								'scrap'	    => $this->fungsi->hapus_koma($this->input->post('scrap')),
								'year'	    => date('Y'),
								'inf'	    => $this->input->post('inf'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
								'addby'		=> $this->session->userdata('uid'),
								
						);
						
					/*Insert to t_pcbal*/
		//$pcbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
//								'ref'	 => $noopform,
//								'amount' 	 => $this->fungsi->hapus_koma($this->input->post('pur')) * -1,
//								
//								'addby'		 => $this->session->userdata('uid'),
//								'adddate' 	 => date( 'Y-m-d H:i:s'),
//								);
			/*Insert to t_stockbal*/
		/*$salbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 => $noopform,
								'qty'		 => $this->input->post('vol'),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);*/
				
			$this->cabang_model->manager_add_qa($ba);
			//$this->branch_model->add_pc_branch($pcbal);
			//$this->cabang_model->add_saldo_branch($salbal);
			/*Set pesan sukses dan kembali ke menu add qa*/
			
			$this->session->set_flashdata('idba', $this->input->post('idba'));
			$this->session->set_flashdata('message_ok', 'Data saved, BA Number :'.$nobaform);
			redirect('branch/manager_qa');
			}
		else
			{
				$this->manager_add_qa();
			}
	}
	
/*Print qa*/
function manager_print_qa_popup()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Get data for print
	$query_ba = $this->cabang_model->get_list_manager_qa_print_paging($this->uri->segment(4),$this->uri->segment(5));
	foreach ($query_ba->result() as $row_ba)
		{
			$data['idba'] = $row_qa->idba;
			$data['qcresidu'] = $row_qa->qcresidu;
			$data['adddate'] = date("d.m.Y",   strtotime($row_qa->adddate));	
			$data['qcair'] = $row_qa->qcair;
			$data['qctbk'] = $row_qa->qctbk;
			$data['inf'] = $row_qa->inf;
			$data['vol'] = $row_qa->vol;
			$data['scrap'] = $row_qa->scrap;
			$data['adj'] = $row_qa->adj;
			$data['qct'] = $row_qa->qct;
			$data['qcbakar'] = $row_qa->qcbakar;
			$data['addby'] = $row_qa->addby;
			$data['idcab'] = $row_qa->idcab;
			}
//Get data detail cabang by id cabang
				$sql_cab_detail = $this->admin_model->get_cab_detail($row_qa->idcab);
				foreach ($sql_cab_detail->result() as $row_cab)
				{	
					$data['cabname'] = $row_cab->cabname;
				}
$this->load->view('popup/popup_ba', $data);
	
}

	
	
	/* Display list qa */
	function manager_list_qa()
	{	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_qa);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
			
		$qa = $this->cabang_model->get_manager_qa_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->cabang_model->count_all_manager_qa();
		$config['base_url'] = site_url('branch/manager_qa/manager_list_qa/');
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID BA', 'Vol', 'Vol Scrap', 'Adjustment', 'Options');
				    
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
				
					foreach ($qa  as $qas)
					{	
			
		$this->table->add_row($qas->idba, $qas->vol, $qas->scrap, $qas->adj,  anchor('branch/manager_qa/manager_edit_qa/','Approve',array('class' => 'update')).' '.anchor_popup('branch/manager_qa/manager_print_qa_popup/'.$qas->idba,'Print',array('class'=> 'print',$atts),$atts));
		
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'BRANCH MANAGER > ADJUSTMENT > LIST ADJUSTMENT';
		$this->load->view('branch/manager_qa_list', $data);
		
	}
	/* Display list qa */
	function manager_list_qa()
	{	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_qa);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
			
		$qa = $this->cabang_model->get_manager_qa_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->cabang_model->count_all_manager_qa();
		$config['base_url'] = site_url('branch/manager_qa/manager_list_qa/');
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID BA', 'Vol', 'Vol Scrap', 'Adjustment', 'Options');
				    
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
				
					foreach ($qa  as $qas)
					{	
			
		$this->table->add_row($qas->idba, $qas->vol, $qas->scrap, $qas->adj,  anchor('branch/manager_qa/manager_edit_qa/','Approve',array('class' => 'update')).' '.anchor_popup('branch/manager_qa/manager_print_qa_popup/'.$qas->idba,'Print',array('class'=> 'print',$atts),$atts));
		
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'BRANCH MANAGER > ADJUSTMENT STOK > PRINT BA';
		$this->load->view('branch/manager_ba_list', $data);
		
	}

	
	
	/* Edit qa */
	function manager_edit_qa()
	{
		
		//Get data detail qa
		$sql_manager_qa_edit = $this->cabang_model->get_manager_qa_detail($this->uri->segment(4));
		
		foreach ($sql_manager_qa_edit->result() as $row_ba)
		{	
			$data['default']['idba']   = $row_ba->idba;
			$data['default']['idqa']   = $row_ba->idqa;
			$data['default']['vol']     = $row_ba->vol;
			$data['default']['adj']    = $row_ba->adj;
			$data['default']['scrap']  = $row_ba->scrap;
			$data['default']['qcair'] = $row_ba->qcair;
			$data['default']['qcbakar']   = $row_ba->qcbakar;
			$data['default']['qcresidu']  =  $row_ba->qcresidu;
			$data['default']['qct']  =  	$row_ba->qct;
			$data['default']['qctbk']   =  $row_ba->qctbk;
			$data['default']['inf']     = $row_ba->inf;
			$data['default']['year']     = $row_ba->year;
			
			$data['default']['adddate'] =  $row_ba->adddate;
			
			$data['default']['addby']   =  $row_ba->addby;
		}
		$data['default']['readonly'] =  'readonly="readonly"';
		
		$data['menu_path'] = 'BRANCH MANAGER > ADJUSTMENT > LIST ADJUSTMENT STOK';
		$data['form_action']= site_url('branch/manager_qa/edit_qa_proc/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('branch/manager_qa/manager_list_qa','Back', array('class' => 'back')));
		$this->load->view('branch/manager_qa_form', $data);
	}
	
	
	/* manager edit qa process */
	function edit_qa_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
				
		
			/* Insert data */
			$ba = array( 
								'appmngr1date'	=> date( 'Y-m-d H:i:s'),
								'appby'		=> $this->session->userdata('uid'),
								'appmngr1'	=> 1,
								
						);
						
											
			/*Insert to t_stockbal*/
		$salbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 =>$this->input->post('idba'),
								'qty'		 => $this->input->post('adj')* -1,
								'year' => $this->input->post('year'),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
								
			$this->cabang_model->update_qa($this->input->post('idqa'),$this->input->post('year'), $ba);		
			//$this->branch_model->add_pc_branch($pcbal);
			$this->cabang_model->add_saldo_branch($salbal);
			
			/*Set pesan sukses dan kembali ke menu add qa*/
			$this->session->set_flashdata('message_ok', 'STOK ADJUSMENT');
			redirect('branch/manager_qa/manager_list_qa');
			
		
	}
	
}