<?php 
/*
Fungsi : Controller untuk finance CPV
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Fin_cpv extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_trf_cpv_dir  = 68;
	var $menu_list_cpv  = 70;
	var $menu_list_cpv_app  = 72;
	var $menu_list_cpv_print  = 73;
	var $menu_create_from_miro  = 69;
	var $menu_create_from_rmb  = 109;
	
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	
/* Cek validitas nilai maksimal yang ditransfer */
	
	public function max_pc_trans()
	{	
		$idpctyp = $this->input->post('cb_pctyp');
   		$amount = $this->fungsi->convert_idr_to_num($this->input->post('txt_amount_trf'));
		
		//Get petty cash type desc
		$sql_get_idpctypdesc = $this->fin_model->get_pc_typ_byidpctyp($idpctyp)->result();
		foreach($sql_get_idpctypdesc as $row_idpctyp);
		
		$sql_max_pc_trans_check = $this->fin_model->get_pc_typ_byidpctyp($idpctyp)->result();
		foreach($sql_max_pc_trans_check as $row_max);
		if ($amount > $row_max->max_trans_amt) 
		{
			$this->form_validation->set_message('max_pc_trans', '%s Maximum for '.$row_idpctyp->desc. ' type is '.$this->fungsi->format_idr($row_max->max_trans_amt).' IDR.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}

/* Fungsi utk link edit/approve CPV */
function get_form_edit_cpv($idpctrans)
	{
		
		switch ($idpctrans)
		{
			case 1:
			  $link = 'finance/fin_cpv/edit_cpv/';
			  break;
			case 2:
			  $link = 'finance/fin_cpv/edit_cpv/';
			  break;
			case 3:
			  $link = 'finance/fin_cpv/edit_cpv/';
			  break;
			 default:
		}
	
	return $link;
		
	}	
/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('finance/fin_model', '', TRUE);
		$this->load->model('accounting/acc_model', '', TRUE);
		$this->load->model('admin/admin_model', '', TRUE);
		$this->load->model('branch/branch_model', '', TRUE);
		$this->load->model('branch/cabang_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->fin_trf_cpv_dir();
		
	}

/*Create from rembuirsement*/
function create_fr_rmb()
{
	//Otorisasi menu
	$this->fungsi->menu_auth($this->menu_create_from_rmb);
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$rmb = $this->fin_model->get_pending_rmb(50, $offset)->result();
		$num_rows = $this->fin_model->get_pending_rmb_count();
		
		$config['base_url'] = site_url('finance/fin_cpv/create_fr_rmb/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. RMB','Branch', 'Total', 'Add by','Add date','Options');
					
					foreach ($rmb  as $rmbs)
					{	
						$this->table->add_row($rmbs->normbform, $rmbs->cabname, $this->fungsi->format_idr($rmbs->total), $rmbs->addby, $rmbs->adddate, anchor('finance/fin_cpv/fin_cpv_rmb_form/'.$rmbs->idcab.'/'.$rmbs->normb.'/'.$rmbs->year,'Create',array('class' => 'update')));	
					}
					
					$data['table'] = $this->table->generate();
				}
				
				else
				{
					$data['message'] = 'No data';
				}
					
		$data['menu_path'] = 'FINANCE > CREATE CPV FROM REMBUIRSEMENT';
		$this->load->view('finance/fin_rmb_list', $data);
	
}
//Rmb detail
function fin_cpv_rmb_form()
{
	
	$query_rmb_detail = $this->fin_model->get_rmb_header_detail($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
	foreach ($query_rmb_detail->result() as $row_rmb)
		{
			$data['cabname'] = $row_rmb->cabname;
			$data['normbform'] = $row_rmb->normbform;
			$data['normb'] = $row_rmb->normb;
			$data['idcab'] = $row_rmb->idcab;
			$data['addby'] = $row_rmb->addby;
			$data['adddate'] = $row_rmb->adddate;
			$data['total'] = $row_rmb->total;
		}
	
	//Get BPKK Header
	$query_bpkk_header = $this->fin_model->get_detail_bpkk_header($row_rmb->idcab,$row_rmb->normb, $row_rmb->year);
	$data['tables'] = '';
	$totalbpkk = 0;
	$bg=0;
	foreach ($query_bpkk_header->result() as $row_bpkk_header)
		{	
		$totalbpkk = $row_bpkk_header->total + $totalbpkk;
			if($bg==0)
					{
					$data['tables'].="<tr style=background-color:#;>";
					$bg++;
					}
					else
					{
					$data['tables'].="<tr style=background-color:#eeeeee;>";
					$bg--;
					}
					$data['tables'] .= '
										  <td align="center">'.$row_bpkk_header->nobpkkform.'<input type="hidden" name="item[]" id="item[]"  value="'.$row_bpkk_header->idcab.'|'.$row_bpkk_header->nobpkk.'|'.$row_bpkk_header->year.'"/></td>
										  <td align="right">'.$this->fungsi->format_idr($row_bpkk_header->total).'</td>
										  <td align="center">'.anchor_popup('branch/branch_bpkk/print_bpkk_popup/'.$row_bpkk_header->idcab.'/'.$row_bpkk_header->nobpkk.'/'.$row_bpkk_header->year,'Preview',array('class' => 'print')).'</td>
										</tr>';
		}
	$data['totalbpkk'] = $totalbpkk;
	//$data['prev'] = '';
	$data['menu_path'] = 'FINANCE > CREATE CPV FROM REMBUIRSEMENT > '.$row_rmb->normbform;
	$data['form_action']= site_url('finance/fin_cpv/fin_cpv_rmb_proc/'.$this->uri->segment(4).'/'.$this->uri->segment(5).'/'.$this->uri->segment(6));
	$data['link'] = array('link_back' => anchor('finance/fin_cpv/create_fr_rmb','Back', array('class' => 'back')));
	$this->load->view('finance/fin_cpv_rmb_form', $data);
	
}

function fin_cpv_rmb_proc()
{
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Description',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{	
				//Check otorisasi transaksi
	//$this->fungsi->trans_auth($this->session->userdata('add'));
	
	/*Get CPV counter*/
		$count = array();
		$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'CPV');
		$nocpvform = $count[0];
		$nocpv = $count[1];
	/* Insert data */
			$cpv = array( 		'idcab'		 => $this->input->post('txt_idcab'),
								'nocpvform'	 => $nocpvform,
								'nocpv'	 	 => $nocpv,
								'year'		 => date('Y'),
								'amount_trf' => $this->input->post('txt_total'),
								'desc'		 => $this->input->post('txt_desc'),
								'status'	 => 0, //Pending
								'pctyp'	 	 => 2,
								'pctrans'	 => 3,
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
	/*Update data rembuirsement header*/
					$rmb = array( 		
										'nocpvform'	 => $nocpvform,
										'status'	 => 2,
								);
			//send email notification
			
			//Get nama cabang
			$sql_cab_detail = $this->admin_model->get_cab_detail($this->input->post('txt_idcab'));
			foreach ($sql_cab_detail->result() as $row_cab);
				
			$var = array($nocpvform, $this->session->userdata('uid'),$row_cab->cabname,$this->fungsi->format_idr($this->input->post('txt_total')),$this->input->post('txt_desc'));
			$this->fungsi->send_notif(7, $var);
								
			$this->fin_model->add_cpv($cpv);
			$this->branch_model->update_rmbheader($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6),$rmb);		
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data saved, CPV number :'.$nocpvform);
			redirect('finance/fin_cpv/create_fr_rmb');
			
			}
		else
			{
				
				$this->fin_cpv_rmb_form();
				
			}
	
}


/*Print CPV*/
function print_cpv_popup()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Get data CPV by no cpv & year
	$query_cpv_edit = $this->fin_model->get_cpv_bynoyear($this->uri->segment(4),$this->uri->segment(5));
	foreach ($query_cpv_edit->result() as $row_cpv)
		{
			$data['txt_nocpvform'] = $row_cpv->nocpvform;
			$data['txt_nocpdu'] = $row_cpv->nocpdu;
			//if($row_cpv->pctrans == 1)
			//{
			$data['txt_accglno'] = $row_cpv->accglno;
			//}
			//Jika tipe = trans from miro maka tampilkan no. miro
			if($row_cpv->pctrans == 2)
			{
				$query_po = $this->branch_model->get_po_bycpv($row_cpv->nocpvform);
				foreach ($query_po->result() as $row_po)
				$data['txt_mirono'] = $row_po->miro;
			}
			$data['txt_adddate'] = date("d.m.Y",   strtotime($row_cpv->adddate));	
			$data['txt_nocpv'] = $row_cpv->nocpv;
			$data['txt_addby'] = $row_cpv->addby;
			$data['txt_idcab'] = $row_cpv->idcab;
			$data['cb_pctyp'] = $row_cpv->pctyp;
			$data['txt_amount_trf'] =  $this->fungsi->format_idr($row_cpv->amount_trf);
			$data['txt_desc'] = $row_cpv->desc;
			$data['txt_terbilang'] = $this->fungsi->terbilang($row_cpv->amount_trf).' RUPIAH';
		}
//Get data detail cabang by id cabang
				$sql_cab_detail = $this->admin_model->get_cab_detail($row_cpv->idcab);
				foreach ($sql_cab_detail->result() as $row_cab)
				{	
					$data['txt_cabname'] = $row_cab->cabname;
				}
$this->load->view('popup/popup_cpv', $data);
	
}

/* Transfer CPV from MIRO */
function create_fr_miro()
{
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//print_r($this->fin_model->get_list_cpv_pend_paging($this->config->item('paging_limit'), $offset)->result());
		 
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_from_miro);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$po = $this->acc_model->get_list_po_cpv(100, $offset)->result();
		$num_rows = $this->acc_model->get_list_po_count_cpv();
		
		$config['base_url'] = site_url('finance/fin_cpv/create_fr_miro/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = 100;
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. PO', 'Pay Type', 'Vendor','Vendor Name', 'Branch', 'Price/Liter', 'Total Liter', 'R. Disc', 'Total Before PPN', 'PPN', 'Total After PPN','Options');
					
					foreach ($po  as $pos)
					{	
						$this->table->add_row($pos->ebeln, $pos->desc, $pos->vendor, $pos->vendor_name, $pos->cabname, $this->fungsi->format_idr($pos->net_price), number_format($pos->quantity),$this->fungsi->format_idr($pos->disc), $this->fungsi->format_idr(($pos->net_price*$pos->quantity) - $pos->disc), $this->fungsi->format_idr($pos->tax), $this->fungsi->format_idr((($pos->net_price*$pos->quantity) - $pos->disc) + $pos->tax) ,anchor('finance/fin_cpv/fin_cpv_miro_form/'.$pos->ebeln.'/'.$pos->year,'Create',array('class' => 'update')));	
					}
					
					$data['table'] = $this->table->generate();
				}
				
				else
				{
					$data['message'] = 'No data';
				}
					
		$data['menu_path'] = 'FINANCE > CREATE CPV FROM MIRO';
		$this->load->view('finance/fin_miro_list', $data);
		
}

function fin_cpv_miro_form()
{
	
	//Check PO Document already MIRO or not
	
	if($this->fungsi_sap->fm_check_po_miro($this->uri->segment(4)) == '')
	{
		echo 'Purchase order no : '.$this->uri->segment(4).' is not have invoice receipt (MIRO)!';
		
		echo '<br>';
		echo '<br>';
		echo '<a href="javascript: history.go(-1)">Go Back</a>';
	}
	else
	{
	
	$query_po_detail = $this->acc_model->get_po_detail($this->uri->segment(4),$this->uri->segment(5));
	foreach ($query_po_detail->result() as $row_po)
		{
			$data['cabname'] = $row_po->cabname;
			$data['idcab'] = $row_po->idcab;
			$data['miro'] = $row_po->miro;
			$data['miraddby'] = $row_po->miraddby;
			$data['miradddate'] = $row_po->miradddate;
			$data['quantity'] = $row_po->quantity;
			$data['net_price'] = $row_po->net_price;
			
			//check if PO credit
			$query_po = $this->db->query("SELECT
			 m_op.fee
			FROM
			  t_po
			  INNER JOIN m_op ON m_op.prnumb = t_po.preq_no
			WHERE
			 t_po.ebeln = '".$this->uri->segment(4)."'
			 AND
			  t_po.idtop = 1
			   AND
			  m_op.pur = 0 AND
			  t_po.nocpvform = ''
			AND m_op.cancel = 0")->result();
			foreach ($query_po  as $query_pos);
			
			if($query_pos->fee > 0 )
			{
				$data['total'] = $query_pos->fee;
			}
			else
			{
				$data['total'] = (($row_po->net_price * $row_po->quantity) - $row_po->disc) +  $row_po->tax;
			}
			$data['vendor'] = $row_po->vendor;
		}
	//$data['prev'] = '';
	$data['menu_path'] = 'FINANCE > CREATE CPV FROM MIRO > '.$row_po->miro;
	$data['form_action']= site_url('finance/fin_cpv/fin_cpv_miro_proc'.'/'.$this->uri->segment(4).'/'.$this->uri->segment(5));
	$data['link'] = array('link_back' => anchor('finance/fin_cpv/create_fr_miro','Back', array('class' => 'back')));
	$this->load->view('finance/fin_cpv_miro_form', $data);
	
	}
	
}

function fin_cpv_miro_proc()
{
	
	
	
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Description',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{	
				//Check otorisasi transaksi
	//$this->fungsi->trans_auth($this->session->userdata('add'));
	
	/*Get CPV counter*/
		$count = array();
		$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'CPV');
		$nocpvform = $count[0];
		$nocpv = $count[1];
	/* Insert data */
			$cpv = array( 		'idcab'		 => $this->input->post('txt_idcab'),
								'nocpvform'	 => $nocpvform,
								'nocpv'	 	 => $nocpv,
								'year'		 => date('Y'),
								'amount_trf' => $this->input->post('txt_total'),
								'desc'		 => $this->input->post('txt_desc'),
								'status'	 => 0, //Pending
								'pctyp'	 	 => 1,
								'pctrans'	 => 2, //Direct transfer
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
	/*Update data PO*/
					$po = array( 		
										'nocpvform'	 => $nocpvform,
										'cpvaddby'	 => $this->session->userdata('uid'),
										'cpvadddate' => date( 'Y-m-d H:i:s'),
								);
	
			//send email notification
			
			//Get nama cabang
			$sql_cab_detail = $this->admin_model->get_cab_detail($this->input->post('txt_idcab'));
			foreach ($sql_cab_detail->result() as $row_cab);
				
			$var = array($nocpvform, $this->session->userdata('uid'),$row_cab->cabname,$this->fungsi->format_idr($this->input->post('txt_total')),$this->input->post('txt_desc'));
			$this->fungsi->send_notif(7, $var);
								
			$this->fin_model->add_cpv($cpv);
			$this->acc_model->update_po($this->uri->segment(4),$this->uri->segment(5),$po);		
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data saved, CPV number :'.$nocpvform);
			redirect('finance/fin_cpv/create_fr_miro');
			
			}
		else
			{
				
				$this->fin_cpv_miro_form();
				
			}
	
	
	
	
	
	
}

	/* Transfer CPV direct */
	function fin_trf_cpv_dir()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_trf_cpv_dir);
		
		
		
		$data['prev'] = '';
		
		//Get list cabang
		$data['default']['cb_idcab'] = $this->input->post('cb_idcab');
		/*Generate combo box cabang*/
			$query_cab = $this->admin_model->get_cabang_list();
			$data_cab = $query_cab->result();
			$data['cab']='';
			foreach($data_cab as $row_cab)
			{
			$data['cab'] .= $row_cab->idcab==$data['default']['cb_idcab'] ? '<option value="'.$row_cab->idcab.'" selected="selected">': '<option value="'.$row_cab->idcab.'">';
			$data['cab'] .= $row_cab->idcab.' - '.$row_cab->cabname.'</option>';
			}	
			
			/*Generate combo box petty cash type*/
			$data['default']['cb_pctyp'] = $this->input->post('cb_pctyp');
			$query_pc_typ = $this->fin_model->get_pc_typ_list();
			$data_pc_typ = $query_pc_typ->result();
			$data['pc_typ']='';
			foreach($data_pc_typ as $row_pc_typ)
			{
			$data['pc_typ'] .= $row_pc_typ->idpctyp==$data['default']['cb_pctyp'] ? '<option value="'.$row_pc_typ->idpctyp.'" selected="selected">': '<option value="'.$row_pc_typ->idpctyp.'">';
			$data['pc_typ'] .= $row_pc_typ->desc.'</option>';
			}	
			
		$data['menu_path'] = 'FINANCE > CPV > DIRECT TRANSFER';
		$data['form_action']= site_url('finance/fin_cpv/add_cpv_dir_prev');
		$this->load->view('finance/fin_cpv_form', $data);
		
	}

/* Add Preview CPV direct transfer */
function add_cpv_dir_prev()
{
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('add'));
	
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_amount_trf',
                     'label'   => 'Amount transfer',
                     'rules'   => 'required|callback_max_pc_trans'
                  ),
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Description',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{	
				
				//Get data detail cabang by id cabang
				$sql_cab_edit = $this->admin_model->get_cab_detail($this->input->post('cb_idcab'));
				
				foreach ($sql_cab_edit->result() as $row_cab)
				{	
					$data['txt_cabname'] = $row_cab->cabname;
				}
				
				//Get data detail petty cash type
				$sql_pc_typ = $this->fin_model->get_pc_typ_byidpctyp($this->input->post('cb_pctyp'));
				
				foreach ($sql_pc_typ ->result() as $row_pc_typ)
				{	
					$data['cb_pctyp_desc'] = $row_pc_typ->desc;
				}
				
				$data['cb_idcab'] = $this->input->post('cb_idcab');
				$data['cb_pctyp'] = $this->input->post('cb_pctyp');
				$data['txt_amount_trf'] = $this->fungsi->convert_idr_to_num($this->input->post('txt_amount_trf'));
				$data['txt_desc'] = $this->input->post('txt_desc');
				
				$data['prev'] =1;
				$data['menu_path'] = 'FINANCE > CPV > DIRECT TRANSFER > PREVIEW';
				$data['form_action']= site_url('finance/fin_cpv/add_cpv_dir_proc');
				$this->load->view('finance/fin_cpv_form', $data);
			}
			
		else
			{
			$this->fin_trf_cpv_dir();
			}
}

/* Add CPV direct transfer */
function add_cpv_dir_proc()
{
	//Check otorisasi transaksi
	//$this->fungsi->trans_auth($this->session->userdata('add'));
	
	/*Get CPV counter*/
		$count = array();
		$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'CPV');
		$nocpvform = $count[0];
		$nocpv = $count[1];
	/* Insert data */
			$cpv = array( 		'idcab'		 => $this->input->post('txt_idcab'),
								'nocpvform'	 => $nocpvform,
								'nocpv'	 	 => $nocpv,
								'year'		 => date('Y'),
								'amount_trf' => $this->input->post('txt_amount_trf'),
								'desc'		 => $this->input->post('txt_desc'),
								'status'	 => 0, //Pending
								'pctyp'	 	 => 0, //Petty cash
								'pctrans'	 => 1, //Direct transfer
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
								
			$this->fin_model->add_cpv($cpv);
			
		
			//send email notification
			
			//Get nama cabang
			$sql_cab_detail = $this->admin_model->get_cab_detail($this->input->post('txt_idcab'));
			foreach ($sql_cab_detail->result() as $row_cab);
				
			$var = array($nocpvform, $this->session->userdata('uid'),$row_cab->cabname,$this->fungsi->format_idr($this->input->post('txt_amount_trf')),$this->input->post('txt_desc'));
			$this->fungsi->send_notif(7, $var);
		
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data saved, CPV number :'.$nocpvform);
			redirect('finance/fin_cpv');
		
}

	/* CPV List */
	function list_cpv()
	{	

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//print_r($this->fin_model->get_list_cpv_pend_paging($this->config->item('paging_limit'), $offset)->result());
		 
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_cpv);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$cpv = $this->fin_model->get_list_cpv_pend_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->fin_model->get_list_cpv_count();
		
		$config['base_url'] = site_url('finance/fin_cpv/list_cpv/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. CPV', 'Branch', 'Amount transfer', 'Desc', 'Petty cash typ', 'Trans typ', 'Status', 'Create by','Create date','Options');
					
					foreach ($cpv  as $cpvs)
					{	
						$this->table->add_row($cpvs->nocpvform, $cpvs->cabname, $this->fungsi->format_idr($cpvs->amount_trf), $cpvs->desc, $cpvs->desc2, $cpvs->desc3, $this->fungsi->convert_status_cpv($cpvs->status), $cpvs->addby, $cpvs->adddate, anchor($this->get_form_edit_cpv($cpvs->pctrans).$cpvs->nocpv.'/'.$cpvs->year,'Edit',array('class' => 'update')));	
					}
					
					$data['table'] = $this->table->generate();
				}
				
				else
				{
					$data['message'] = 'No data';
				}
					
		$data['menu_path'] = 'FINANCE > CPV > CPV PENDING LIST';
		$this->load->view('finance/fin_cpv_list', $data);
	}
	
	
	/* Edit CPV */
	function edit_cpv()
	{
				
		//Get data CPV by no cpv & year
		$query_cpv_edit = $this->fin_model->get_cpv_bynoyear($this->uri->segment(4),$this->uri->segment(5));
		foreach ($query_cpv_edit->result() as $row_cpv)
		{
			$data['default']['txt_nocpvform'] = $row_cpv->nocpvform;
			$data['default']['txt_nocpv'] = $row_cpv->nocpv;
			$data['default']['cb_idcab'] = $row_cpv->idcab;
			$data['default']['cb_pctyp'] = $row_cpv->pctyp;
			$data['default']['txt_amount_trf'] =  $this->fungsi->format_idr($row_cpv->amount_trf);
			$data['default']['txt_desc'] = $row_cpv->desc;
			$data['default']['txt_year'] = $row_cpv->year;
		}
		
		$data['cb_idcab'] = $this->input->post('cb_idcab');
		$data['cb_pctyp'] = $this->input->post('cb_pctyp');
			//Combo box ID cab
			$query_cab = $this->admin_model->get_cabang_list();
			$data_cab = $query_cab->result();
			$data['cab']='';
			foreach($data_cab as $row_cab)
			{
			$data['cab'] .= $row_cab->idcab==$data['default']['cb_idcab'] ? '<option value="'.$row_cab->idcab.'" selected="selected">': '<option value="'.$row_cab->idcab.'">';
			$data['cab'] .= $row_cab->idcab.' - '.$row_cab->cabname.'</option>';
			}	
			
			/*Generate combo box petty cash type*/
			//$data['default']['cb_pctyp'] = $this->input->post('cb_pctyp');
			$query_pc_typ = $this->fin_model->get_pc_typ_list();
			$data_pc_typ = $query_pc_typ->result();
			$data['pc_typ']='';
			foreach($data_pc_typ as $row_pc_typ)
			{
			$data['pc_typ'] .= $row_pc_typ->idpctyp==$data['default']['cb_pctyp'] ? '<option value="'.$row_pc_typ->idpctyp.'" selected="selected">': '<option value="'.$row_pc_typ->idpctyp.'">';
			$data['pc_typ'] .= $row_pc_typ->desc.'</option>';
			}
			
		$data['menu_path'] = 'FINANCE > CPV > EDIT CPV > '.$row_cpv->nocpvform;
		$data['form_action']= site_url('finance/fin_cpv/update_cpv_dir_prev/'.$row_cpv->nocpv.'/'.$row_cpv->year);
		$data['link'] = array('link_back' => anchor('finance/fin_cpv/list_cpv','Back', array('class' => 'back')));
		$this->load->view('finance/fin_cpv_form_edit', $data);
		
	}

/* Edit CPDU */
	function edit_cpdu()
	{
		
				
		//Get data CPV by no cpv & year
		$query_cpv_edit = $this->fin_model->get_cpv_bynoyear($this->uri->segment(4),$this->uri->segment(5));
		foreach ($query_cpv_edit->result() as $row_cpv)
		{
			$data['default']['txt_nocpvform'] = $row_cpv->nocpvform;
			$data['default']['txt_nocpv'] = $row_cpv->nocpv;
			$data['default']['txt_bankrefno'] = $row_cpv->bankrefno;
			$data['default']['cb_idcab'] = $row_cpv->idcab;
			$data['default']['cb_pctyp'] = $row_cpv->pctyp;
			$data['default']['txt_amount_trf'] =  $this->fungsi->format_idr($row_cpv->amount_trf);
			$data['default']['txt_desc'] = $row_cpv->desc;
			$data['default']['txt_year'] = $row_cpv->year;
			$data['default']['txt_cpdu'] = $row_cpv->nocpdu;
		}
		
		$data['cb_idcab'] = $this->input->post('cb_idcab');
		$data['cb_pctyp'] = $this->input->post('cb_pctyp');
			//Combo box ID cab
			$query_cab = $this->admin_model->get_cabang_list();
			$data_cab = $query_cab->result();
			$data['cab']='';
			foreach($data_cab as $row_cab)
			{
			$data['cab'] .= $row_cab->idcab==$data['default']['cb_idcab'] ? '<option value="'.$row_cab->idcab.'" selected="selected">': '<option value="'.$row_cab->idcab.'">';
			$data['cab'] .= $row_cab->idcab.' - '.$row_cab->cabname.'</option>';
			}	
			
			/*Generate combo box petty cash type*/
			//$data['default']['cb_pctyp'] = $this->input->post('cb_pctyp');
			$query_pc_typ = $this->fin_model->get_pc_typ_list();
			$data_pc_typ = $query_pc_typ->result();
			$data['pc_typ']='';
			foreach($data_pc_typ as $row_pc_typ)
			{
			$data['pc_typ'] .= $row_pc_typ->idpctyp==$data['default']['cb_pctyp'] ? '<option value="'.$row_pc_typ->idpctyp.'" selected="selected">': '<option value="'.$row_pc_typ->idpctyp.'">';
			$data['pc_typ'] .= $row_pc_typ->desc.'</option>';
			}
			
		$data['menu_path'] = 'FINANCE > CPV > EDIT CPV > '.$row_cpv->nocpvform;
		$data['form_action']= site_url('finance/fin_cpv/update_cpdu/'.$row_cpv->nocpv.'/'.$row_cpv->year);
		$data['link'] = array('link_back' => anchor('finance/fin_cpv/print_cpv','Back', array('class' => 'back')));
		$this->load->view('finance/fin_cpdu_form', $data);
		
	}
	
/* Update CPDU */
function update_cpdu()
{
	//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_cpdu',
                     'label'   => 'CPDU',
                     'rules'   => ''
                  ),
				   array(
                     'field'   => 'txt_bankrefno',
                     'label'   => 'Bank Reference Number',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'txt_desc',
                     'label'   => 'Description',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{	
			
						/* Update data */
						$cpdu = array( 		
								'nocpdu' => $this->input->post('txt_cpdu'),
								'bankrefno' => $this->input->post('txt_bankrefno'),
								'desc' => $this->input->post('txt_desc'),
								'chby'		 => $this->session->userdata('uid'),
								'chdate' 	 => date( 'Y-m-d H:i:s'),
								);
								
			$this->fin_model->update_cpv($this->uri->segment(4),$this->uri->segment(5),$cpdu);
			
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data changed');
			redirect('finance/fin_cpv/print_cpv');
			
			}
		else
			{
				$this->edit_cpdu();
				
			}
	
}


	
/* Update Preview CPV direct transfer */
function update_cpv_dir_prev()
{
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('edit'));
	
	/* Set validasi */
		$config = array(
               /*array(
                     'field'   => 'txt_amount_trf',
                     'label'   => 'Amount transfer',
                     'rules'   => 'required|callback_max_pc_trans'
                  ),*/
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Description',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{	
				
				//Get data detail cabang by id cabang
				$sql_cab_edit = $this->admin_model->get_cab_detail($this->input->post('cb_idcab'));
				
				foreach ($sql_cab_edit->result() as $row_cab)
				{	
					$data['txt_cabname'] = $row_cab->cabname;
				}
				
				//Get data detail petty cash type
				$sql_pc_typ = $this->fin_model->get_pc_typ_byidpctyp($this->input->post('cb_pctyp'));
				
				foreach ($sql_pc_typ ->result() as $row_pc_typ)
				{	
					$data['cb_pctyp_desc'] = $row_pc_typ->desc;
				}
				
				$data['txt_nocpv'] = $this->input->post('txt_nocpv');
				$data['txt_year'] = $this->input->post('txt_year');
				$data['cb_idcab'] = $this->input->post('cb_idcab');
				$data['cb_pctyp'] = $this->input->post('cb_pctyp');
				$data['txt_amount_trf'] = $this->fungsi->convert_idr_to_num($this->input->post('txt_amount_trf'));
				$data['txt_desc'] = $this->input->post('txt_desc');
				
				$data['prev'] =1;
				$data['menu_path'] = 'FINANCE > CPV > EDIT CPV PREVIEW > '.$this->input->post('txt_nocpvform');
				$data['form_action']= site_url('finance/fin_cpv/update_cpv_dir_proc');
				$this->load->view('finance/fin_cpv_form_edit', $data);
			}
			
		else
			{
				$this->edit_cpv();
			}
}

function update_cpv_dir_proc()
{
	
		/* Update data */
			$cpv = array( 		
								/*'amount_trf' => $this->input->post('txt_amount_trf'),
								'idcab' => $this->input->post('txt_idcab'),*/
								'desc'		 => $this->input->post('txt_desc'),
								/*'pctyp'	 	 => $this->input->post('cb_pctyp'),*/
								'chby'		 => $this->session->userdata('uid'),
								'chdate' 	 => date( 'Y-m-d H:i:s'),
								);
								
			$this->fin_model->update_cpv($this->input->post('txt_nocpv'),$this->input->post('txt_year'),$cpv);
			
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data changed');
			redirect('finance/fin_cpv/list_cpv');
	
}


/* CPV List approve/cancel */
	function list_cpv_app()
	{	

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//print_r($this->fin_model->get_list_cpv_pend_paging($this->config->item('paging_limit'), $offset)->result());
		 
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_cpv_app);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$cpv = $this->fin_model->get_list_cpv_pend_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->fin_model->get_list_cpv_count();
		
		$config['base_url'] = site_url('finance/fin_cpv/list_cpv/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. CPV', 'Branch', 'Amount transfer', 'Desc', 'Petty cash typ', 'Trans typ', 'Status', 'Create by','Create date','Options');
					
					foreach ($cpv  as $cpvs)
					{	
						$this->table->add_row($cpvs->nocpvform, $cpvs->cabname, $this->fungsi->format_idr($cpvs->amount_trf), $cpvs->desc, $cpvs->desc2, $cpvs->desc3, $this->fungsi->convert_status_cpv($cpvs->status), $cpvs->addby, $cpvs->adddate, anchor('finance/fin_cpv/app_cpv/'.$cpvs->nocpv.'/'.$cpvs->year,'Process',array('class' => 'update')));	
					}
					
					$data['table'] = $this->table->generate();
				}
				
				else
				{
					$data['message'] = 'No data';
				}
					
		$data['menu_path'] = 'FINANCE > CPV > CPV WAIT FOR APPROVAL';
		$this->load->view('finance/fin_cpv_list', $data);
	}
	
/*Approve/cancel CPV*/
function app_cpv()
{
	//Get data CPV by no cpv & year
		$query_cpv_edit = $this->fin_model->get_detail_cpv_bynoyear($this->uri->segment(4),$this->uri->segment(5));
		foreach ($query_cpv_edit->result() as $row_cpv)
		{
			$data['nocpvform'] = $row_cpv->nocpvform;
			$data['nocpv'] = $row_cpv->nocpv;
			//$data['idcab'] = $row_cpv->idcab;
			$data['pctyp'] = $row_cpv->pctyp;
			$data['amount_trf'] =  $this->fungsi->format_idr($row_cpv->amount_trf);
			$data['amount_req'] =  $this->fungsi->format_idr($row_cpv->amount_req);
			$data['desc'] = $row_cpv->desc;
			$data['year'] = $row_cpv->year;
			$data['pctyp'] = $row_cpv->pctyp;
			$data['pctrans'] = $row_cpv->pctrans;
			$data['addby'] = $row_cpv->addby;
			$data['adddate'] = $row_cpv->adddate;
			$data['chby'] = $row_cpv->chby;
			$data['chdate'] = $row_cpv->chdate;
			$data['desc2'] = $row_cpv->desc2;
			$data['desc3'] = $row_cpv->desc3;
			$data['cabname'] = $row_cpv->cabname;
		}
		
		$data['prev'] =0;
		$data['menu_path'] = 'FINANCE > CPV > APPROVAL CPV > '.$row_cpv->nocpvform;
		$data['form_action']= site_url('finance/fin_cpv/app_cpv_prev'.'/'.$this->uri->segment(4).'/'.$this->uri->segment(5));
		$data['link'] = array('link_back' => anchor('finance/fin_cpv/list_cpv_app','Back', array('class' => 'back')));
		$this->load->view('finance/fin_cpv_app_form', $data);
	
}

/*Approval CPV preview*/
function app_cpv_prev()
{	
	if($this->input->post('rg_app') == 1)
	{
		//Check otorisasi approve
		$this->fungsi->trans_auth($this->session->userdata('app'));
	}
	else
	{
		//Check otorisasi cancel
		$this->fungsi->trans_auth($this->session->userdata('cancel'));
		
	}
	
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'rg_app',
                     'label'   => 'Approval Status',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{	
	
	//Get data CPV by no cpv & year
		$query_cpv_edit = $this->fin_model->get_detail_cpv_bynoyear($this->uri->segment(4),$this->uri->segment(5));
		foreach ($query_cpv_edit->result() as $row_cpv)
		{
			$data['nocpvform'] = $row_cpv->nocpvform;
			$data['nocpv'] = $row_cpv->nocpv;
			$data['idcab'] = $row_cpv->idcab;
			$data['pctyp'] = $row_cpv->pctyp;
			$data['amount_trf'] =  $this->fungsi->format_idr($row_cpv->amount_trf);
			$data['amount_trf2'] =  $row_cpv->amount_trf;
			$data['amount_req'] =  $this->fungsi->format_idr($row_cpv->amount_req);
			$data['desc'] = $row_cpv->desc;
			$data['year'] = $row_cpv->year;
			$data['pctrans'] = $row_cpv->pctrans;
			$data['addby'] = $row_cpv->addby;
			$data['adddate'] = $row_cpv->adddate;
			$data['chby'] = $row_cpv->chby;
			$data['chdate'] = $row_cpv->chdate;
			$data['desc2'] = $row_cpv->desc2;
			$data['desc3'] = $row_cpv->desc3;
			$data['cabname'] = $row_cpv->cabname;
		}
		
		$data['prev'] =1;
		$data['rg_app'] =$this->input->post('rg_app');
		$data['menu_path'] = 'FINANCE > CPV > APPROVAL CPV PREVIEW > '.$row_cpv->nocpvform;
		$data['form_action']= site_url('finance/fin_cpv/app_cpv_proc'.'/'.$this->uri->segment(4).'/'.$this->uri->segment(5));
		//$data['link'] = array('link_back' => anchor('finance/fin_cpv/list_cpv_app','Back', array('class' => 'back')));
		$this->load->view('finance/fin_cpv_app_form', $data);
			}
		else
		{
			$this->app_cpv();
		}
	
}

/*Approve cpv process*/
function app_cpv_proc()
{
	if($this->input->post('txt_app') == 1)
	{
		$cpv = array( 		
								'appby' => $this->session->userdata('uid'),
								'appdate' => date( 'Y-m-d H:i:s'),
								'status' => 1,
		
						);
		
		//send email notification
			
			//Get nama cabang
			$sql_cab_detail = $this->admin_model->get_cab_detail($this->input->post('txt_idcab'));
			foreach ($sql_cab_detail->result() as $row_cab);
			
			/*------------------Insert data ke SPPV------------------------*/
		
		//Insert CPV Header
		
			/* Insert data */
			$cpvheader = array( 	
							'tipe_pembayaran'	=> 1,
							'tanpa_po'			=> 0,
							'no_sap'			=> 0,
							'supplier'			=> $row_cab->cabname,
							'total'				=> $this->input->post('txt_amount_trf2'),
							'tanggal_top'		=> date('Y-m-d'),
							'tanggal_bayar'		=> date('Y-m-d'),
							'mata_uang'			=> 'IDR',
							'status_cpv'		=> 1,
							'approve_by'		=> $this->session->userdata('uid'),
							'tanggal_approve'	=> date( 'Y-m-d H:i:s'),
							'jenis_pembayaran'	=> 'Internet Banking',
							'cpv_dibuat_oleh'	=> 'novika',
							'tgl_buat_cpv'		=> date('Y-m-d'),
							'waktu_buat_cpv'	=> date('H:i:s'),	
							'oth_ref'			=> $this->input->post('txt_nocpvform'),
						);
						
			$this->fin_model->insert_cpv_header_sppv($cpvheader);
		
			//Get CPV Last Num
			$query_cpv_last = $this->fin_model->get_last_num_cpv_header_sppv();
			$data_cpv_last = $query_cpv_last->result();
			foreach($data_cpv_last as $row_cpv_last);
			
			/* Insert data */
			$cpvdetail = array( 	
							'cpv_no_cpv'	=> $row_cpv_last->no_cpv,
							'uraian'			=> $this->input->post('txt_desc'),
							'jumlah'			=> $this->input->post('txt_amount_trf2'),
						);
						
		$this->fin_model->insert_cpv_detail_sppv($cpvdetail);
		
		/*------------------Insert data ke SPPV------------------------*/	
			
			$var = array($this->input->post('txt_nocpvform'), $this->session->userdata('uid'),$row_cab->cabname,$this->input->post('txt_amount_trf'),$this->input->post('txt_desc'));
			$this->fungsi->send_notif(8, $var);
		$this->session->set_flashdata('message_ok', 'Data '.$this->input->post('txt_nocpvform').' approved');
	}
	else
	{		
		//Jika tipe transaksi = 2 maka, hapus no. cpv pada PO
		if($this->input->post('txt_pctrans') == 2)
		{
			//Get PO Data
			$query_po_detail = $this->branch_model->get_po_bycpv($this->input->post('txt_nocpvform'));
			foreach ($query_po_detail->result() as $row_po);
			
			//Update table PO
				$po = array('nocpvform' => '',
							'cpvaddby'	=> '',
							'cpvadddate' => '',
							);
				$this->branch_model->update_po($row_po->ebeln, $row_po->year,$po);
			
		}
		//Jika tipe transaksi = 3 maka, update status pada RMB header
		else if($this->input->post('txt_pctrans') == 3)
		{
			//Get RMB Header
			$query_rmb_detail = $this->fin_model->get_rmb_header_bynocpv($this->input->post('txt_nocpvform'));
			foreach ($query_rmb_detail->result() as $row_rmb);
			
			//Update table RMB Header
				$rmb = array( 		
										'nocpvform'	 => '',
										'status'	 => 0,
								);
			$this->branch_model->update_rmbheader($row_rmb->idcab,$row_rmb->normb,$row_rmb->year,$rmb);	
			
		}
			$cpv = array( 		
								'canby' => $this->session->userdata('uid'),
								'descan' => $this->input->post('txt_descan'),
								'candate' => date( 'Y-m-d H:i:s'),
								'status' => 2,
								);
			//send email notification
			
			//Get nama cabang
			$sql_cab_detail = $this->admin_model->get_cab_detail($this->input->post('txt_idcab'));
			foreach ($sql_cab_detail->result() as $row_cab);
				
			$var = array($this->input->post('txt_nocpvform'), $this->session->userdata('uid'),$row_cab->cabname,$this->input->post('txt_amount_trf'),$this->input->post('txt_desc'),$this->input->post('txt_descan'));
			$this->fungsi->send_notif(9, $var);
		$this->session->set_flashdata('message_ok', 'Data '.$this->input->post('txt_nocpvform').' cancelled');
	}
	
$this->fin_model->update_cpv($this->uri->segment(4),$this->uri->segment(5),$cpv);
redirect('finance/fin_cpv/list_cpv_app');


}

function print_cpv()
{
	//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//print_r($this->fin_model->get_list_cpv_pend_paging($this->config->item('paging_limit'), $offset)->result());
		 
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_cpv_print);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$cpv = $this->fin_model->get_list_cpv_print_paging(50, $offset)->result();
		$num_rows = $this->fin_model->get_list_cpv_print_count();
		
		$config['base_url'] = site_url('finance/fin_cpv/print_cpv/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = 50;
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. CPV', 'No. CPDU', 'Branch', 'Amount transfer', 'Desc', 'Petty cash typ', 'Trans typ','Acc. Journal', 'Status', 'Appv by','Appv date','Options');
					
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
					
					foreach ($cpv  as $cpvs)
					{	
					
						//Check journal posting
						if($this->fungsi_sap->fm_check_gl_post($cpvs->pcbankglacc,$cpvs->nocpdu) == 'X')
						{
							$status_jurnal = '<font color="#00CC00"><b>OK</b></font>';
						}
						else
						{
							$status_jurnal = '<font color="#FF0000"><b>NOT OK</b></font>';
						}
						
						$this->table->add_row($cpvs->nocpvform, $cpvs->nocpdu, $cpvs->cabname, $this->fungsi->format_idr($cpvs->amount_trf), $cpvs->desc, $cpvs->desc2, $cpvs->desc3, $status_jurnal,$this->fungsi->convert_status_cpv($cpvs->status), $cpvs->appby, $cpvs->appdate, anchor_popup('finance/fin_cpv/print_cpv_popup/'.$cpvs->nocpv.'/'.$cpvs->year,'Print',array('class' => 'print',$atts),$atts).' '.anchor('finance/fin_cpv/edit_cpdu/'.$cpvs->nocpv.'/'.$cpvs->year,'Edit',array('class' => 'update')));	
					}
					
					$data['table'] = $this->table->generate();
				}
				
				else
				{
					$data['message'] = 'No data';
				}
					
		$data['menu_path'] = 'FINANCE > CPV > CPV PRINT LIST';
		$this->load->view('finance/fin_cpv_list', $data);
	
}

}