<?php 
/*
Fungsi : Controller untuk finance CPV
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Finance_pusat extends CI_Controller {

	function kelola_virtual_account()
	{
		if(isset($_POST['submit']))
	    {
	        $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
	    } else 
	    {
	        $data['search']  =  $this->session->userdata('sess_search');
	    }
			
		/* Setting Parameter Untuk Paging */
		$offset = $this->uri->segment(4);
		$virtual_account = $this->fin_model->viewListVirtualAccount($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->fin_model->countListVirtualAccount($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('finance/finance_pusat/kelola_virtual_account');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Penghasil', 'Virtual Account', 'Nama Account', 'Options');
				
			foreach($virtual_account as $row)
			{
					$this->table->add_row($row->suppname, $row->norek, $row->nama ,anchor('finance/finance_pusat/doDeleteVASupplier/'.$row->idvasupp, 'Delete', array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		

		$data['menu_path'] = 'FINANCE > KELOLA VIRTUAL ACCOUNT';
		$data['form_action']= site_url('finance/finance_pusat/kelola_virtual_account');
		$data['penghasil'] = $this->db->query('SELECT * FROM `m_supp` WHERE tipe = "10" AND idsupp NOT IN (SELECT idsupp FROM va_supplier)')->result();
		$data['rekening'] = $this->db->get_where('rekening_va', array('approval' => '1'))->result();
		$this->load->view('finance/kelola_virtual_account', $data);
	}

	function doAddVASupplier()
	{
		$data = array('idsupp' => $this->input->post('supplier'),
					'idva' => $this->input->post('rekening')
				);
		$this->db->insert('va_supplier', $data);
		$this->session->set_flashdata('message_ok', 'Data saved');
		redirect(base_url('finance/finance_pusat/kelola_virtual_account'));
	}

	function doDeleteVASupplier($id)
	{
		$this->db->delete('va_supplier', array('idvasupp' => $id));
		$this->session->set_flashdata('message_ok', 'Data deleted');
		redirect(base_url('finance/finance_pusat/kelola_virtual_account'));
	}

	function kelola_master_va()
	{
		if(isset($_POST['submit']))
	    {
	        $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
	    } else 
	    {
	        $data['search']  =  $this->session->userdata('sess_search');
	    }
			
		/* Setting Parameter Untuk Paging */
		$offset = $this->uri->segment(4);
		$virtual_account = $this->fin_model->viewListMasterVA($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->fin_model->countListMasterVA($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('finance/finance_pusat/kelola_master_va');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Virtual Account', 'Nama Account', 'Options');
				
			foreach($virtual_account as $row)
			{
					$this->table->add_row($row->norek, $row->nama, anchor('finance/finance_pusat/doDeleteMasterVA/'.$row->id, 'Delete', array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		

		$data['menu_path'] = 'FINANCE > KELOLA MASTER VA';
		$data['form_action']= site_url('finance/finance_pusat/kelola_master_va');
		$this->load->view('finance/kelola_master_va', $data);
	}

	function doAddMasterVA()
	{
		$data = array('norek' => $this->input->post('nomor'),
					'nama' => $this->input->post('nama'),
					'addby' => $this->session->userdata('uid'),
					'adddate' => date('Y-m-d H:i:s'),
					'approval' => '0',
				);
		$this->db->insert('rekening_va', $data);
		$this->session->set_flashdata('message_ok', 'Data telah disimpan, menunggu untuk diapprove');
		redirect(base_url('finance/finance_pusat/kelola_master_va'));
	}

	function doDeleteMasterVA($id)
	{
		$this->db->delete('rekening_va', array('id' => $id));
		$this->session->set_flashdata('message_ok', 'Data deleted');
		redirect(base_url('finance/finance_pusat/kelola_master_va'));
	}

	function cekApproval()
	{
		$data['master_va'] = $this->db->get_where('rekening_va', array('approval' => '0'));
		$this->load->view('finance/cek_approval', $data);
	}
}