<?php 
/*
Fungsi : Controller untuk frame left
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Frame_left extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	 
	 function __construct()
	{
		parent::__construct();
		$this->load->model('user/user_model', '', TRUE);
		$this->load->model('admin/admin_model', '', TRUE);
	}
	
	public function index()
	{	
		$this->display_menu();
	}
	
	/* Display menu */
	function display_menu()
	{
		$data_menu1 = array();
		$data_menu2 = array();
		
		if($this->session->userdata('rolename') == 'ADMIN')
		{
			$query_menu = $this->admin_model->get_menu_all()->result();	
		}
		else
		{
			$query_menu = $this->user_model->get_user_menu($this->session->userdata('roleid'))->result();	
		}
		
		foreach($query_menu as $row): 
					$data_menu1[$row->pid][] = $row;
					$data_menu2[] = $row->murl;
		endforeach; 
				
		$data['menu'] =  '<ul id="browser" class="filetree">'; 
		$data['menu'] .= '<li class="closed"><span class="delete"><a href="'.$this->config->item('base_url').'/user/user_login/logout" target="_parent" onclick="return confirm(\'Logout from system ?\')">LOGOUT</a></span></li>';
		$data['menu'] .=   $this->fungsi->menu_widget($data_menu1,0); 
		
		$this->load->view('frame/frame_left', $data);
		
	}
	
	/* Display blank frame */
	function frame_blank()
	{
		
		$this->load->view('frame/frame_blank');
		
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */