<?php 
/*
Fungsi : Controller untuk Notifikasi
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notifikasi extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->model('legal/notifikasi_model', '', TRUE);
		$this->load->model('legal/perijinan_model', '', TRUE);
		$this->fungsi->check_login();
		$this->fungsi->sess_search_segment();
	}
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_reminder  = 44;
	var $next_list_perijinan  = 13;
	var $last_list_perijinan = 14;
	var $menu_add_perijinan = 11;
	
	public function index()
	{	
		$this->notifikasi();
	}
	
	function notifikasi()
	{
		
	/* Notif Reminder */
		$remainder =  $this->perijinan_model->count_reminder();
		$expired = $this->perijinan_model->count_expired();
		//$expired = 1;
		if ($remainder != 0)
		{
			$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
			
			$data['notif_remind'] = anchor_popup('legal/notifikasi/list_notifremind',$remainder,array('class' => 'print',$atts),		
			$atts);		
		}
		else
		{
		$data['notif_remind'] = 0;	
		}
		
		/* Notif Expired */
		if ($expired != 0)
		{
			$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
			
			$data['notif_expired'] = anchor_popup('legal/notifikasi/list_notifexpired/',$expired,array('class' => 'print',$atts),	
			$atts);	
		}
		else
		{
		$data['notif_expired'] = 0;	
		}
		$this->load->view('frame/frame_body', $data);
	}
	
	function list_notifremind()
	{
		//Otorisasi ttk
		//$this->fungsi->menu_auth($this->menu_list_reminder);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } else {
                $data['search']  =  $this->session->userdata('sess_search');
            }
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		$list_perijinan = $this->notifikasi_model->get_paging_reminder($this->config->item('paging_limit'), $offset, $data['search	
		'])->result();
		$num_rows = $this->notifikasi_model->count_rows_reminder($data['search']);
		$config['base_url'] = site_url('legal/perijinan/list_perijinan/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID', 'Jenis Perijinan', 'Group Dept', 'Nama Perijinan', 'Lokasi Perijinan', 'Detail 					Perijinan', 'Supporting Dokumen', 'Information Detail', 'Tanggal Reminder 1', 'Tanggal Reminder 2', 'Tanggal 	
					Reminder 3', 'Tanggal Expired');
				
					foreach ($list_perijinan as $row)
					{	
		$this->table->add_row($row->reminder_id, $row->ket, $row->cabname, $row->reminder_name, $row->lokasi, $row->reminder_desc, 		$row->dok, $row->ket,  $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date))), $this->fungsi->
		falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date2))), $this->fungsi->falidasi_tanggal(date	
		("d-m-Y", strtotime($row->reminder_date3))), $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->exp_date))));
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data to display';
				}		
		$data['menu_path'] = 'NOTIFIKASI DATA PERIJINAN REMINDER';
		//$data['link'] = array('link_back' => anchor('admin/admin_menu','Back', array('class' => 'back')));	
		$data['form_action']= site_url('legal/perijinan/list_perijinan');
		$this->load->view('legal/notifikasi_list', $data);
	}
	
	function list_notifexpired()
	{
		//Otorisasi ttk
		//$this->fungsi->menu_auth($this->menu_list_reminder);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } else {
                $data['search']  =  $this->session->userdata('sess_search');
            }
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		$list_perijinan = $this->notifikasi_model->get_paging_expired($this->config->item('paging_limit'), $offset, $data['search'	
		])->result();
		$num_rows = $this->notifikasi_model->count_rows_expired($data['search']);
		$config['base_url'] = site_url('legal/perijinan/list_perijinan/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID', 'Jenis Perijinan', 'Group Dept', 'Nama Perijinan', 'Lokasi Perijinan', 'Detail 					Perijinan', 'Supporting Dokumen', 'Information Detail', 'Tanggal Reminder 1', 'Tanggal Reminder 2', 'Tanggal 		
					Reminder 3', 'Tanggal Expired');
				
					foreach ($list_perijinan as $row)
					{	
		$this->table->add_row($row->reminder_id, $row->ket, $row->cabname, $row->reminder_name, $row->lokasi, $row->reminder_desc, 		$row->dok, $row->ket, $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date))), $this->fungsi->
		falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date2))), $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime(
		$row->reminder_date3))), $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->exp_date))));
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data to display';
				}		
		$data['menu_path'] = 'NOTIFIKASI DATA PERIJINAN EXPIRED';
		//$data['link'] = array('link_back' => anchor('admin/admin_menu','Back', array('class' => 'back')));	
		$data['form_action']= site_url('legal/perijinan/list_perijinan');
		$this->load->view('legal/notifikasi_list', $data);
	}
	
}