<?php 
/*
Fungsi : Controller untuk Perijinan
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Perijinan extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->model('legal/perijinan_model', '', TRUE);
		$this->fungsi->check_login();
		$this->fungsi->sess_search_segment();
	}
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_perijinan  = 47;
	var $next_list_perijinan  = 48;
	var $last_list_perijinan = 49;
	var $menu_add_perijinan = 46;
	
	public function index()
	{	
		$this->add_perijinan();
	}
	
	function add_perijinan()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_perijinan);
	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		/* Generate combo box */
			$data['default']['cb_perijinan'] = $this->input->post('cb_perijinan');
			
			$query_perijinan = $this->perijinan_model->get_group();
			$data_perijinan = $query_perijinan->result();
			$data['perijinan']='';
			foreach($data_perijinan as $row)
			{
			$data['perijinan'] .= $row->id==$data['default']['cb_perijinan'] ? '<option value="'.$row->id.'" selected="selected">'	
			: 
			'<option value="'.$row->id.'">';
			$data['perijinan'] .= $row->id. ' - ' . $row->ket_group. '</option>';	
			}
				
		/* Cek Role */
		$role = $this->session->userdata('roleid');
		if ($role == 11 or $role == 13)
		{
			/* Generate combo box */
			$data['default']['cb_group'] = $this->input->post('cb_group');
			
			$query_group = $this->perijinan_model->get_grouping();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
			{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';	
			}	
		}
			else
		{
			/* Generate combo box */
			$data['default']['cb_group'] = $this->input->post('cb_group');
			
			$query_group = $this->perijinan_model->get_groupby_user();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
			{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';
			}
		}
		//Get last id
		$query_id =  $this->fungsi->get_last_id('reminder_events')->result();	

		foreach($query_id as $row);
		$last_id = $row->Auto_increment;
		
		$data['default']['txt_id'] = $last_id;
		
		$data['menu_path'] = 'PERIJINAN LEGALITAS > FORM PERIJINAN > ADD PERIJINAN';
		$data['form_action']= site_url('legal/perijinan/proc_add_perijinan');
		
		$this->load->view('legal/perijinan_form', $data);
	}
	
	/* Add Data Perijinan */
	function proc_add_perijinan()
	{	
	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		$config = array(
                array(
						 'field'   => 'txt_nama',
						 'label'   => 'Nama Perijinan',
						 'rules'   => 'required'
					  ),
			    array(
						 'field'   => 'txt_tglremind',
						 'label'   => 'Tanggal Reminder',
						 'rules'   => 'required'
				  	),
				 array(
						 'field'   => 'txt_tglexpired',
						 'label'   => 'Tanggal Kadaluarsa',
						 'rules'   => 'required'
				  	),
					
            );
			
		$this->form_validation->set_rules($config); 
		if ($this->form_validation->run() == TRUE)
			{
				
				/* Insert data */
				$perijinan = array( 'id'				=> $this->input->post('cb_perijinan'),
									'roleid'			=> $this->session->userdata('roleid'),
									'idcab'				=> $this->input->post('cb_group'),
									'reminder_name'		=> $this->input->post('txt_nama'),	
									'reminder_desc'		=> $this->input->post('txt_detail'),
									'ket'				=> $this->input->post('txt_information'),
									'lokasi'			=> $this->input->post('txt_lokasi'),
									'dok'				=> $this->input->post('txt_suporting'),
									'lokdoc'				=> $this->input->post('txt_doc'),
									'reminder_date'		=> date("Y-m-d", strtotime($this->input->post('txt_tglremind'))),
									'reminder_date2'	=> date("Y-m-d", strtotime($this->input->post('txt_tglremind2'))),
									'reminder_date3'	=> date("Y-m-d", strtotime($this->input->post('txt_tglremind3'))),
									'exp_date'			=> date("Y-m-d", strtotime($this->input->post('txt_tglexpired'))),
									'adddate'			=> date('Y-m-d'),
									'addby'				=> $this->session->userdata('uid'),
									
							);
				$this->perijinan_model->add_reminder($perijinan);
				$this->session->set_flashdata('message_ok', 'Data input succesfully');			
				redirect('legal/perijinan/add_perijinan');
			}
		else
			{
				$this->add_perijinan();
			}
	}
	
	
	function list_perijinan()
	{
		//Otorisasi Menu
		$this->fungsi->menu_auth($this->menu_list_perijinan);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		/* Generate combo box */
			$data['default']['cb_perijinan'] = $this->input->post('cb_perijinan');
			
			$query_perijinan = $this->perijinan_model->get_group();
			$data_perijinan = $query_perijinan->result();
			$data['perijinan']='';
			foreach($data_perijinan as $row)
			{
			$data['perijinan'] .= $row->id==$data['default']['cb_perijinan'] ? '<option value="'.$row->id.'" selected="selected">': 
			'<option value="'.$row->id.'">';
			$data['perijinan'] .= $row->id. ' - ' . $row->ket_group. '</option>';	
			}
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } else {
                $data['search']  =  $this->session->userdata('sess_search');
            }
		
		/* Cek Role */
		$role = $this->session->userdata('roleid');
		if ($role == 11 or $role == 13)
		{
			/* Generate combo box */
			$data['default']['cb_group'] = $this->input->post('cb_group');
			
			$query_group = $this->perijinan_model->get_grouping();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
			{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';	
			}	
			
			/* Setting Parameter Untuk Paging */
			$uri_segment = 4;
			$offset =    $this->uri->segment($uri_segment);
			$list_perijinan = $this->perijinan_model->get_paging_perijinan_admin($this->config->item('paging_limit'), $offset, 
			$data['search'])->result();
			$num_rows = $this->perijinan_model->count_rows_perijinan_admin($data['search']);
		}
		else
		{
			/* Generate combo box */
			$data['default']['cb_group'] = $this->input->post('cb_group');
			
			$query_group = $this->perijinan_model->get_groupby_user();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
			{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';
			}
			
			/* Setting Parameter Untuk Paging */
			$uri_segment = 4;
			$offset =    $this->uri->segment($uri_segment);
			$list_perijinan = $this->perijinan_model->get_paging_perijinan_user($this->config->item('paging_limit'), $offset, 
			$data['search'])->result();
			$num_rows = $this->perijinan_model->count_rows_perijinan_user($data['search']);
		}
		
		$config['base_url'] = site_url('legal/perijinan/list_perijinan/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID', 'Jenis Perijinan', 'Group Dept', 'Nama Perijinan', 'Lokasi Perijinan', 'Detail 					Perijinan', 'Supporting Dokumen', 'Information Detail', 'Tanggal Reminder 1', 'Tanggal Reminder 2', 'Tanggal 	
					Reminder 3', 'Tanggal Expired', 'Options');
				
					foreach ($list_perijinan as $row)
					{	
		$this->table->add_row($row->reminder_id, $row->ket_group, $row->cabname, $row->reminder_name, $row->lokasi, $row->	
		reminder_desc, $row->dok, $row->ket,  $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date))), 	
		$this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date2))), $this->fungsi->falidasi_tanggal(date(	
		"d-m-Y", strtotime($row->reminder_date3))), $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime( $row->exp_date))),
		anchor('legal/perijinan/edit_perijinan/'.$row->reminder_id,'Edit',array('class' => 'update')).'  '.
		anchor('legal/perijinan/dokumen/'.$row->reminder_id,'Dokumen',array('class' => 'update')).'  '.
		anchor('legal/perijinan/delete_perijinan/'.$row->reminder_id,'Hapus',array('class'=> 'delete','onclick'=>"return confirm('Anda Yakin Akan Menghapus Data Dengan ID ".$row->reminder_id." ?')"))).'</td></tr>';
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data to display';
				}		
		$data['menu_path'] = 'PERIJINAN LEGALITAS > LIST PERIJINAN';
		//$data['link'] = array('link_back' => anchor('admin/admin_menu','Back', array('class' => 'back')));	
		$data['form_action']= site_url('legal/perijinan/list_perijinan');
		
		// 0 = list perijinan, 1 = list perijinan akan datang, 2 = list perijinan expired 
		$data['form_action2']= site_url('legal/perijinan/list_group_by/0');
		$this->load->view('legal/perijinan_list', $data);
		
	}
	
	
	function list_group_by()
	{
		
		/* Generate combo box */
			$data['default']['cb_perijinan'] = $this->input->post('cb_perijinan');
			
			$query_perijinan = $this->perijinan_model->get_group();
			$data_perijinan = $query_perijinan->result();
			$data['perijinan']='';
			foreach($data_perijinan as $row)
			{
			$data['perijinan'] .= $row->id==$data['default']['cb_perijinan'] ? '<option value="'.$row->id.'" selected="selected">'
			: 
			'<option value="'.$row->id.'">';
			$data['perijinan'] .= $row->id. ' - ' . $row->ket_group. '</option>';	
			}
			
	
		// Menampilkan List Berdasarkan Group Berdasarkan
		$uri_seg = $this->uri->segment(4);
		if($uri_seg == 0)
		{	
			/* Cek Role */
			$role = $this->session->userdata('roleid');
			if ($role == 11 or $role == 13)
			{
				$group = $this->input->post('cb_group');
				$jenis = $this->input->post('cb_perijinan');
				
				/* Generate combo box */
				$data['default']['cb_group'] = $this->input->post('cb_group');
			
				$query_group = $this->perijinan_model->get_grouping();
				$data_group = $query_group->result();
				$data['group']='';
				foreach($data_group as $row)
				{
				$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
				selected="selected">': 
				'<option value="'.$row->idcab.'">';
				$data['group'] .= $row->cabname. '</option>';	
				}	
			
				$uri_segment = 5;
				$offset =    $this->uri->segment($uri_segment);
				/* Setting Parameter Untuk Paging */
				$list_perijinan = $this->perijinan_model->get_list_paging_perijinan_groupby_admin($this->config->item(
				'paging_limit'), $offset, $group, $jenis)->result();
				$num_rows = $this->perijinan_model->count_rows_list_perijinan_groupby_admin($group, $jenis);
				$data['menu_path'] = 'PERIJINAN > MASTER DATA PERIJINAN > LIST DATA PERIJINAN';
			}
			else
			{	
				$group = $this->input->post('cb_group');
				$jenis = $this->input->post('cb_perijinan');
				
				/* Generate combo box */
				$data['default']['cb_group'] = $this->input->post('cb_group');
			
				$query_group = $this->perijinan_model->get_groupby_user();
				$data_group = $query_group->result();
				$data['group']='';
				foreach($data_group as $row)
				{
				$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
				selected="selected">': 
				'<option value="'.$row->idcab.'">';
				$data['group'] .= $row->cabname. '</option>';
				}
				
				$uri_segment = 5;
				$offset =    $this->uri->segment($uri_segment);
				/* Setting Parameter Untuk Paging */
				$list_perijinan = $this->perijinan_model->get_list_paging_perijinan_groupby_user($this->config->item('paging_limit
				'), $offset, $group, $jenis)->result();
				$num_rows = $this->perijinan_model->count_rows_list_perijinan_groupby_user($group, $jenis);
				
				$data['menu_path'] = 'PERIJINAN > MASTER DATA PERIJINAN > LIST DATA PERIJINAN';
			}
			
		}
		else if($uri_seg == 1)
		{
			/* Cek Role */
			$role = $this->session->userdata('roleid');
			if ($role == 11 or $role == 13)
			{
				$group = $this->input->post('cb_group');
				$jenis = $this->input->post('cb_perijinan');
				/* Generate combo box */
				$data['default']['cb_group'] = $this->input->post('cb_group');
			
				$query_group = $this->perijinan_model->get_grouping();
				$data_group = $query_group->result();
				$data['group']='';
				foreach($data_group as $row)
				{
				$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
				selected="selected">': 
				'<option value="'.$row->idcab.'">';
				$data['group'] .= $row->cabname. '</option>';	
				}	
				
				$uri_segment = 5;
				$offset =    $this->uri->segment($uri_segment);
				/* Setting Parameter Untuk Paging */
				$list_perijinan = $this->perijinan_model->get_next_paging_perijinan_groupby_admin($this->config->item(
				'paging_limit'), $offset, $group, $jenis)->result();
				$num_rows = $this->perijinan_model->count_rows_next_perijinan_groupby_admin($group, $jenis);
				$data['menu_path'] = 'PERIJINAN > MASTER DATA PERIJINAN > LIST DATA PERIJINAN AKAN DATANG';
			}
			else
			{
				
				$group = $this->input->post('cb_group');
				$jenis = $this->input->post('cb_perijinan');
				/* Generate combo box */
				$data['default']['cb_group'] = $this->input->post('cb_group');
			
				$query_group = $this->perijinan_model->get_groupby_user();
				$data_group = $query_group->result();
				$data['group']='';
				foreach($data_group as $row)
				{
				$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
				selected="selected">': 
				'<option value="'.$row->idcab.'">';
				$data['group'] .= $row->cabname. '</option>';
				}
				
				/* Setting Parameter Untuk Paging */
				$uri_segment = 5;
				$offset =    $this->uri->segment($uri_segment);
				$list_perijinan = $this->perijinan_model->get_next_paging_perijinan_groupby_user($this->config->item('paging_limit
				'), $offset, $group, $jenis)->result();
				$num_rows = $this->perijinan_model->count_rows_next_perijinan_groupby_user($group, $jenis);
				
				$data['menu_path'] = 'PERIJINAN > MASTER DATA PERIJINAN > LIST DATA PERIJINAN AKAN DATANG';
			}
			
		}
		else
		{
			/* Cek Role */
			$role = $this->session->userdata('roleid');
			if ($role == 11 or $role == 13)
			{
				$group = $this->input->post('cb_group');
				$jenis = $this->input->post('cb_perijinan');
				
				/* Generate combo box */
				$data['default']['cb_group'] = $this->input->post('cb_group');
			
				$query_group = $this->perijinan_model->get_grouping();
				$data_group = $query_group->result();
				$data['group']='';
				foreach($data_group as $row)
				{
				$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
				selected="selected">': 
				'<option value="'.$row->idcab.'">';
				$data['group'] .= $row->cabname. '</option>';	
				}	
				
				/* Setting Parameter Untuk Paging */
				$uri_segment = 5;
				$offset =    $this->uri->segment($uri_segment);
				$list_perijinan = $this->perijinan_model->get_last_paging_perijinan_groupby_admin($this->config->item(
				'paging_limit'), $offset, $group, $jenis)->result();
				$num_rows = $this->perijinan_model->count_rows_last_perijinan_groupby_admin($group, $jenis);
				
				$data['menu_path'] = 'PERIJINAN > MASTER DATA PERIJINAN > LIST DATA PERIJINAN EXPIRED';
			}
			else
			{
				$group = $this->input->post('cb_group');
				$jenis = $this->input->post('cb_perijinan');
				
				$data['default']['cb_group'] = $this->input->post('cb_group');
			
				$query_group = $this->perijinan_model->get_groupby_user();
				$data_group = $query_group->result();
				$data['group']='';
				foreach($data_group as $row)
				{
				$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
				selected="selected">': 
				'<option value="'.$row->idcab.'">';
				$data['group'] .= $row->cabname. '</option>';
				}
				
				/* Setting Parameter Untuk Paging */
				$uri_segment = 5;
				$offset =    $this->uri->segment($uri_segment);
				$list_perijinan = $this->perijinan_model->get_last_paging_perijinan_groupby_user($this->config->item('paging_limit
				'), $offset, $group, $jenis)->result();
				$num_rows = $this->perijinan_model->count_rows_last_perijinan_groupby_user($group, $jenis);
				
				$data['menu_path'] = 'PERIJINAN > MASTER DATA PERIJINAN > LIST DATA PERIJINAN EXPIRED';
			}
		}
		
		$config['base_url'] = site_url('legal/perijinan/list_group_by/');
		$data['total'] = $num_rows;
		//print_r($num_rows);
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID', 'Jenis Perijinan', 'Group Dept', 'Nama Perijinan', 'Lokasi Perijinan', 'Detail 					Perijinan'
					, 'Supporting Dokumen', 'Information Detail', 'Tanggal Reminder 1', 'Tanggal Reminder 2', 'Tanggal 	
					Reminder 3', 'Tanggal Expired', 'Options');
				
					foreach ($list_perijinan as $row)
					{	
		$this->table->add_row($row->reminder_id, $row->ket_group, $row->cabname, $row->reminder_name, $row->lokasi, $row->	
		reminder_desc, $row->dok, $row->ket, $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date))), $this
		->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date2))), $this->fungsi->falidasi_tanggal(date("d-m-Y", 
		strtotime($row->reminder_date3))), $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime( $row->exp_date))),
		anchor('legal/perijinan/edit_perijinan/'.$row->reminder_id,'Edit',array('class' => 'update')).'  '.
		anchor('legal/perijinan/delete_perijinan/'.$row->reminder_id,'Hapus',array('class'=> 'delete','onclick'=>"return confirm('Anda Yakin Akan Menghapus Data Dengan ID ".$row->reminder_id." ?')"))).'</td></tr>';
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data to display';
				}		
		
		$data['link'] = array('link_back' => anchor('legal/perijinan/list_perijinan','Back', array('class' => 'back')));	
		$data['form_action']= site_url('legal/perijinan/list_perijinan');
		$yeah = 36;
		// 0 = list perijinan, 1 = list perijinan akan datang, 2 = list perijinan expired 
		$data['form_action2']= site_url('legal/perijinan/list_group_by/'.$uri_seg);
		//$data['form_action2']= site_url('legal/perijinan/list_group_by/'.$yeah);
		$this->load->view('legal/perijinan_list_group', $data);
	}
	
	function next_perijinan()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->next_list_perijinan);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		/* Generate combo box */
			$data['default']['cb_perijinan'] = $this->input->post('cb_perijinan');
			
			$query_perijinan = $this->perijinan_model->get_group();
			$data_perijinan = $query_perijinan->result();
			$data['perijinan']='';
			foreach($data_perijinan as $row)
			{
			$data['perijinan'] .= $row->id==$data['default']['cb_perijinan'] ? '<option value="'.$row->id.'" selected="selected">'
			: 
			'<option value="'.$row->id.'">';
			$data['perijinan'] .= $row->id. ' - ' . $row->ket_group. '</option>';	
			}
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } else {
                $data['search']  =  $this->session->userdata('sess_search');
            }
			
		/* Cek Role */
		$role = $this->session->userdata('roleid');
		if ($role == 11 or $role == 13)
		{
			
		/* Generate combo box */
			$data['default']['cb_group'] = $this->input->post('cb_group');
			
			$query_group = $this->perijinan_model->get_grouping();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
			{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';	
			}	
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		$next_perijinan = $this->perijinan_model->get_paging_next_perijinan_admin($this->config->item('paging_limit'), $offset, 
		$data['search'], date('Y-m-d'))->result();
		$num_rows = $this->perijinan_model->count_rows_next_perijinan_admin( $data['search']);
		}
		else
		{
			
		/* Generate combo box */
			$data['default']['cb_group'] = $this->input->post('cb_group');
			
			$query_group = $this->perijinan_model->get_groupby_user();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
			{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';
			}
				
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		$next_perijinan = $this->perijinan_model->get_paging_next_perijinan_user($this->config->item('paging_limit'), $offset, 
		$data['search'], date('Y-m-d'))->result();
		$num_rows = $this->perijinan_model->count_rows_next_perijinan_user( $data['search']);
		}
		
		$config['base_url'] = site_url('legal/perijinan/next_perijinan/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID', 'Jenis Perijinan', 'Group Dept', 'Nama Perijinan', 'Lokasi Perijinan', 'Detail 					Perijinan', 'Supporting Dokumen', 'Information Detail', 'Tanggal Reminder 1', 'Tanggal Reminder 2', 'Tanggal 	
					Reminder 3', 'Tanggal Expired', 'Options');
				
					foreach ($next_perijinan as $row)
					{	
		$this->table->add_row($row->reminder_id, $row->ket_group,  $row->cabname, $row->reminder_name, $row->lokasi, $row->	
		reminder_desc, $row->dok, $row->ket,  $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date))), 
		$this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date2))), $this->fungsi->falidasi_tanggal(date(
		"d-m-Y", strtotime($row->reminder_date3))), $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime( $row->exp_date))),
		anchor('legal/perijinan/edit_perijinan/'.$row->reminder_id,'Edit',array('class' => 'update')).'  '.
		anchor('legal/perijinan/dokumen/'.$row->reminder_id,'Dokumen',array('class' => 'update')).'  '.
		anchor('legal/perijinan/delete_perijinan/'.$row->reminder_id,'Hapus',array('class'=> 'delete','onclick'=>"return confirm('Anda Yakin Akan Menghapus Data Dengan ID ".$row->reminder_id." ?')"))).'</td></tr>';
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data to display';
				}		
		$data['menu_path'] = 'PERIJINAN LEGALITAS > LEGALITAS AKAN DATANG';
		//$data['link'] = array('link_back' => anchor('admin/admin_menu','Back', array('class' => 'back')));	
		$data['form_action']= site_url('legal/perijinan/next_perijinan');
		
		// 0 = list perijinan, 1 = list perijinan akan datang, 2 = list perijinan expired 
		$data['form_action2']= site_url('legal/perijinan/list_group_by/1');
		$this->load->view('legal/perijinan_list', $data);
		
	}
	
	
	function last_perijinan()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->next_list_perijinan);
		
		/* Generate combo box */
			$data['default']['cb_perijinan'] = $this->input->post('cb_perijinan');
			
			$query_perijinan = $this->perijinan_model->get_group();
			$data_perijinan = $query_perijinan->result();
			$data['perijinan']='';
			foreach($data_perijinan as $row)
			{
			$data['perijinan'] .= $row->id==$data['default']['cb_perijinan'] ? '<option value="'.$row->id.'" selected="selected">': 
			'<option value="'.$row->id.'">';
			$data['perijinan'] .= $row->id. ' - ' . $row->ket_group. '</option>';	
			}
			
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } else {
                $data['search']  =  $this->session->userdata('sess_search');
            }
			
		/* Cek Role */
		$role = $this->session->userdata('roleid');
		if ($role == 11 or $role == 13)
		{
			/* Generate combo box */
			$data['default']['cb_group'] = $this->input->post('cb_group');
			
			$query_group = $this->perijinan_model->get_grouping();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
			{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';	
			}	
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		$last_perijinan = $this->perijinan_model->get_paging_last_perijinan_admin($this->config->item('paging_limit'), $offset, 
		$data['search'], date('Y-m-d'))->result();
		$num_rows = $this->perijinan_model->count_rows_last_perijinan_admin( $data['search']);
		}
		else
		{
			/* Generate combo box */
			$data['default']['cb_group'] = $this->input->post('cb_group');
			
			$query_group = $this->perijinan_model->get_groupby_user();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
			{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';
			}
			
		/* Setting Parameter Untuk Paging */
			$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		$last_perijinan = $this->perijinan_model->get_paging_last_perijinan_user($this->config->item('paging_limit'), $offset, 
		$data['search'], date('Y-m-d'))->result();
		$num_rows = $this->perijinan_model->count_rows_last_perijinan_user($data['search']);
		
		}
		
		$config['base_url'] = site_url('legal/perijinan/last_perijinan/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID', 'Jenis Perijinan', 'Group Dept', 'Nama Perijinan', 'Lokasi Perijinan', 'Detail			
					 Perijinan', 'Supporting Dokumen', 'Information Detail', 'Tanggal Reminder 1', 'Tanggal Reminder 2', 'Tanggal 	
					Reminder 3', 'Tanggal Kadaluarsa', 'Options');
				
					foreach ($last_perijinan as $row)
					{	
					$this->table->add_row($row->reminder_id, $row->ket_group, $row->cabname, $row->reminder_name, $row->lokasi, 	
					$row->reminder_desc, $row->dok, $row->ket,  $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->
					reminder_date))), $this->fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date2))), $this->
					fungsi->falidasi_tanggal(date("d-m-Y", strtotime($row->reminder_date3))), $this->fungsi->falidasi_tanggal(date
					("d-m-Y", strtotime($row->exp_date))),
					anchor('legal/perijinan/edit_perijinan/'.$row->reminder_id,'Edit',array('class' => 'update')).'  '.
					anchor('legal/perijinan/dokumen/'.$row->reminder_id,'Dokumen',array('class' => 'update')).'  '.
					anchor('legal/perijinan/delete_perijinan/'.$row->reminder_id,'Hapus',array('class'=> 'delete','onclick'=>"return confirm('Anda Yakin Akan Menghapus Data Dengan ID ".$row->reminder_id." ?')"))).'</td></tr>';
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data to display';
				}		
		$data['menu_path'] = 'PERIJINAN LEGALITAS > LEGALITAS EXPIRED';
		//$data['link'] = array('link_back' => anchor('admin/admin_menu','Back', array('class' => 'back')));	
		$data['form_action']= site_url('legal/perijinan/last_perijinan');
		
		// 0 = list perijinan, 1 = list perijinan akan datang, 2 = list perijinan expired 
		$data['form_action2']= site_url('legal/perijinan/list_group_by/2');
		$this->load->view('legal/perijinan_list', $data);		
	}
	
	
	/* Edit Perijinan */
	function edit_perijinan()
	{
				
		//Check otorisasi
			$this->fungsi->trans_auth($this->session->userdata('edit'));
			$query_edit = $this->perijinan_model->get_data($this->uri->segment(4))->row();	
			
			$data['default']['txt_id'] 				= $query_edit ->reminder_id;
			$data['default']['txt_nama'] 			= $query_edit ->reminder_name;
			$data['default']['txt_detail'] 			= $query_edit ->reminder_desc;
			$data['default']['txt_information'] 	= $query_edit ->ket;
			$data['default']['txt_lokasi'] 			= $query_edit ->lokasi;
			$data['default']['txt_suporting'] 		= $query_edit ->dok;
			$data['default']['txt_doc']      		= $query_edit ->lokdoc;
			$data['default']['txt_tglremind'] 		= date("d-m-Y", strtotime($query_edit ->reminder_date));
			$data['default']['txt_tglremind2'] 		= date("d-m-Y", strtotime($query_edit ->reminder_date2));
			$data['default']['txt_tglremind3'] 		= date("d-m-Y", strtotime($query_edit ->reminder_date3));
			$data['default']['txt_tglexpired'] 		= date("d-m-Y", strtotime($query_edit ->exp_date));
			$data['default']['cb_group']	 		= $query_edit ->idcab;
			$data['default']['cb_perijinan']	 	= $query_edit ->id;
			
			/* Generate combo box */
			
			$query_perijinan = $this->perijinan_model->get_group();
			$data_perijinan = $query_perijinan->result();
			$data['perijinan']='';
			foreach($data_perijinan as $row)
			{
			$data['perijinan'] .= $row->id==$data['default']['cb_perijinan'] ? '<option value="'.$row->id.'" selected="selected">': 
			'<option value="'.$row->id.'">';
			$data['perijinan'] .= $row->id. ' - ' .  $row->ket_group. '</option>';	
			}
			
			/* Cek Role */
		$role = $this->session->userdata('roleid');
		if ($role == 11 or $role == 13)
			{
			/* Generate combo box */
			
			$query_group = $this->perijinan_model->get_grouping();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
				{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';	
				}	
			}
			else
			{
			/* Generate combo box */
			
			$query_group = $this->perijinan_model->get_groupby_user();
			$data_group = $query_group->result();
			$data['group']='';
			foreach($data_group as $row)
			{
			$data['group'] .= $row->idcab==$data['default']['cb_group'] ? '<option value="'.$row->idcab.'" 			 \
			selected="selected">': 
			'<option value="'.$row->idcab.'">';
			$data['group'] .= $row->cabname. '</option>';
			}
		}
					
		$data['menu_path'] = 'PERIJINAN > DATA PERIJINAN > EDIT DATA PERIJINAN';
		$data['form_action']= site_url('legal/perijinan/update_perijinan/'.$this->uri->segment(4));
		//$data['link'] = array('link_back' => anchor('at/atm_reason/atm_add_reason','Back', array('class' => 'back')));
		$data['add_disabled']='';
		$this->load->view('legal/perijinan_form', $data);
	}
	
	/* Update perijinan */
	function update_perijinan()
	{	
		
	$config = array(
                array(
						 'field'   => 'txt_nama',
						 'label'   => 'Nama Perijinan',
						 'rules'   => 'required'
					  ),
			    array(
						 'field'   => 'txt_tglremind',
						 'label'   => 'Tanggal Reminder',
						 'rules'   => 'required'
				  	),
				 array(
						 'field'   => 'txt_tglexpired',
						 'label'   => 'Tanggal Kadaluarsa',
						 'rules'   => 'required'
				  	),
					
            );
			
		$this->form_validation->set_rules($config); 
		if ($this->form_validation->run() == TRUE)
			{
				
				/* Insert data */
				$perijinan = array( 
									'idcab'				=> $this->input->post('cb_group'),
									'id'				=> $this->input->post('cb_perijinan'),
									'roleid'			=> $this->session->userdata('roleid'),
									'reminder_name'		=> $this->input->post('txt_nama'),	
									'reminder_desc'		=> $this->input->post('txt_detail'),
									'ket'				=> $this->input->post('txt_information'),
									'lokasi'			=> $this->input->post('txt_lokasi'),
									'dok'				=> $this->input->post('txt_suporting'),
									'lokdoc'			=> $this->input->post('txt_doc'),
									'reminder_date'		=> date("Y-m-d", strtotime($this->input->post('txt_tglremind'))), 
									'reminder_date2'	=> date("Y-m-d", strtotime($this->input->post('txt_tglremind2'))), 
									'reminder_date3'	=> date("Y-m-d", strtotime($this->input->post('txt_tglremind3'))), 
									'exp_date'			=> date("Y-m-d", strtotime($this->input->post('txt_tglexpired'))), 
									'chdate'			=> date('Y-m-d'),
									'chby'				=> $this->session->userdata('uid'),
									
							);
						
				$this->perijinan_model->update_perijinan($this->uri->segment(4), $perijinan);
				$this->session->set_flashdata('message_ok', 'Data Update Succesfully');
				redirect('legal/perijinan/list_perijinan');
			}
		else
			{
				$this->list_perijinan();
			}
	}
	
	function delete_perijinan()
	{
		
				/* Insert data */
				$perijinan = array( 
						'stat_delete'				=> 1,
						'deleteby'					=> $this->session->userdata('uid'),
						'deletedate'				=> date('Y-m-d H:i:s'),
									
							);
				$this->perijinan_model->update_perijinan($this->uri->segment(4), $perijinan);
				$this->session->set_flashdata('message_ok', 'Data Update Succesfully');
				redirect('legal/perijinan/list_perijinan');
	}
	
	function dokumen()
	{	
		//Check otorisasi
			$this->fungsi->trans_auth($this->session->userdata('edit'));
			$rows = $this->perijinan_model->get_data($this->uri->segment(4))->row();	
			
			$data['default']['txt_id']	 		= $rows->reminder_id;
			$data['default']['txt_nama'] 		= $rows->reminder_name;
			$data['default']['txt_lokasi'] 		= $rows->lokasi;
			$data['default']['txt_doc']	 		= $rows->doc;
			$data['txt_file']	 				= $rows->file;
			$data['default']['txt_detail'] 		= $rows->reminder_desc;
			$data['download']					= anchor('legal/perijinan/download/'.$rows->file,'Download');
			$data['delete']						= anchor('legal/perijinan/delete_file/'.$rows->reminder_id.'/'.$rows->file,'Delete',array('onclick'=>"return confirm('Anda Yakin Akan Menghapus Data Dengan ID ".$rows->reminder_id." ?')"));
			
		$data['menu_path'] = 'PERIJINAN > DATA PERIJINAN > DOKUMEN PERIJINAN';
		if($rows->file == NULL){
		$this->load->view('legal/detail_dokumen', $data);
		}else{
		$this->load->view('legal/download_dokumen', $data);
		$data['form_action']= site_url('legal/perijinan/download/'.$rows->file);
		}
	}
	
	
	function do_add_dokumen()
	{
	$this->load->library('form_validation');
	$name = $_FILES['userfile']['name'];
	$nama_asli = trim($name);
	
	// Konfigurasi Upload Gambar
	
	$path = './uploads/';
    chmod($path,0777);
	$config['file_name'] = $_FILES['userfile']['name'];
	$config['upload_path'] = $path;
	$config['allowed_types'] = 'jpg|png|pdf|doc';
	$config['max_size']	= '5120';
	$config['max_width']  = '1600';
	$config['max_height']  = '1200';
	$this->load->library('upload', $config);
	
	if ( ! $this->upload->do_upload())
	{	
	$data =  array('error' => $this->upload->display_errors('<span class="error">','</span>'));	
	$this->session->set_flashdata('message_err', 'Upload Data Unsuccessfully');
	redirect('legal/perijinan/dokumen/'.$this->input->post('txt_id'));
	}
	else
	{
	$data = array('upload_data' => $this->upload->data());
	$get_name = $this->upload->data();
	$perijinan = array('file'		=> $get_name['file_name']);
						
	$this->perijinan_model->update_perijinan($this->input->post('txt_id'), $perijinan);
	$this->session->set_flashdata('message_ok', 'Upload Data Succesfully');
	redirect('legal/perijinan/dokumen/'.$this->input->post('txt_id'));
	}
			
}

	function download()
	{

      	$this->load->helper('download');
		$name = $this->uri->segment(4);
		$data = file_get_contents('uploads/'.$name);
		force_download($name, $data);
    }
	
	function delete_file()
	{
	$file_photo = $this->uri->segment(5);	
	$path_file = './uploads';
	unlink($path_file.$file_photo);
	$perijinan = array('file'		=> '');
						
	$this->perijinan_model->update_perijinan($this->uri->segment(4), $perijinan);
	redirect('legal/perijinan/dokumen/'.$this->uri->segment(4));
	}
}