<?php 
/*
Fungsi : Controller untuk frame body
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class listBA extends CI_Controller {

	//Menu ID utk keperluan otorisasi
	var $ba_ok = 177;
	var $ba_tolak = 178;

	public function baOk()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		//Otorisasi menu
		$this->fungsi->menu_auth($this->ba_ok);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$nomor_sample = $this->list_ba_model->viewBAok($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->list_ba_model->countBAok($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('list_ba/listBA/baOk');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Tanggal', 'Nomor Sample', 'Pengirim', 'Manifest', 'Surat Jalan', 'PPIC', 'LAB', 'Analis', 'Air', 'Bahan Bakar', 'Residu', 'Sedimen', 'Viscositas', 'Berat Jenis', 'kg/I', 'Volume Kirim', 'Volume Masuk', 'Options');
				
			foreach($nomor_sample as $row)
			{	
				$rowCIS = $this->db2->get_where('berita_acara', array('id_ba' => $row->idba))->row();
				$rowRLIS = $this->db->get_where('berita_acara', array('id_ba' => $row->idba))->row();
				$this->table->add_row($row->idba, $this->fungsi->formatTanggal($row->adddate), $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $rowRLIS->no_sj, $row->id_sample_ppic, $row->id_sample_lab, $row->checkby, $row->qcair, $row->qcbakar, $row->qcresidu, $row->qcresidub, $row->qcvisco, $row->qckg, $row->qckg2, $rowCIS->vol_coll, $rowCIS->vol_ppic, anchor('list_ba/listBA/detailView/'.$row->idqa,'Detail',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > LIST BA > BA OK';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('list_ba/listBA/baOk');
		$this->load->view('list_ba/tampil_berita_acara_ok', $data);
	}

	public function baTolak()
	{
		$this->db2 = $this->load->database('default2', TRUE);
		//Otorisasi menu
		$this->fungsi->menu_auth($this->ba_tolak);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$nomor_sample = $this->list_ba_model->viewBAtolak($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->list_ba_model->countBAtolak($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('list_ba/listBA/baTolak');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Tanggal', 'Nomor Sample', 'Pengirim', 'Manifest', 'Surat Jalan', 'PPIC', 'LAB', 'Analis', 'Air', 'Bahan Bakar', 'Residu', 'Sedimen', 'Viscositas', 'Berat Jenis', 'kg/I', 'Volume Kirim', 'Options', ' ');
				
			foreach($nomor_sample as $row)
			{
				$rowCIS = $this->db2->get_where('berita_acara', array('id_ba' => $row->idba))->row();
				$rowRLIS = $this->db->get_where('berita_acara', array('id_ba' => $row->idba))->row();
				$tanggalBA = date('Y-m-d', strtotime('+3 days', strtotime($row->waktu_approve_qa)));

				if($rowRLIS->resample == 0 && $tanggalBA >= date('Y-m-d'))
				{
					$this->table->add_row($row->idba, $this->fungsi->formatTanggal($row->adddate), $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $rowRLIS->no_sj, $row->id_sample_ppic, $row->id_sample_lab, $row->checkby, $row->qcair, $row->qcbakar, $row->qcresidu, $row->qcresidub, $row->qcvisco, $row->qckg, $row->qckg2, $rowCIS->vol_coll, anchor('list_ba/listBA/detailView/'.$row->idqa,'Detail',array('class' => 'update')), anchor('list_ba/listBA/doResample/'.$row->idqa,'Resample',array('class' => 'update')));
				} elseif($rowRLIS->resample == 1 && $tanggalBA >= date('Y-m-d'))
				{
					$this->table->add_row($row->idba, $this->fungsi->formatTanggal($row->adddate), $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $rowRLIS->no_sj, $row->id_sample_ppic, $row->id_sample_lab, $row->checkby, $row->qcair, $row->qcbakar, $row->qcresidu, $row->qcresidub, $row->qcvisco, $row->qckg, $row->qckg2, $rowCIS->vol_coll, anchor('list_ba/listBA/detailView/'.$row->idqa,'Detail',array('class' => 'update')), anchor('list_ba/listBA/doResample2/'.$row->idqa,'Resample Ke-2',array('class' => 'update')));
				} elseif($rowRLIS->resample > 1)
				{
					$this->table->add_row($row->idba, $this->fungsi->formatTanggal($row->adddate), $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $rowRLIS->no_sj, $row->id_sample_ppic, $row->id_sample_lab, $row->checkby, $row->qcair, $row->qcbakar, $row->qcresidu, $row->qcresidub, $row->qcvisco, $row->qckg, $row->qckg2, $rowCIS->vol_coll, anchor('list_ba/listBA/detailView/'.$row->idqa,'Detail',array('class' => 'update')), '<p><b>Sudah Resample</b></p>');
				} else
				{
					$this->table->add_row($row->idba, $this->fungsi->formatTanggal($row->adddate), $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $rowRLIS->no_sj, $row->id_sample_ppic, $row->id_sample_lab, $row->checkby, $row->qcair, $row->qcbakar, $row->qcresidu, $row->qcresidub, $row->qcvisco, $row->qckg, $row->qckg2, $rowCIS->vol_coll, anchor('list_ba/listBA/detailView/'.$row->idqa,'Detail',array('class' => 'update')), '<p style="color:red;"><b>DITOLAK</b></p>');
				}
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > LIST BA > BA TOLAK';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('list_ba/listBA/baTolak');
		$this->load->view('list_ba/tampil_berita_acara_tolak', $data);
	}

	public function detailView($idqa)
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$id_sample = $this->db->get_where('t_qa', array('idqa' => $idqa))->row('id_sample');

		$data['data_analisis'] = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row();

		$idba = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row('idba');
		$data['keterangan'] = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row();
		$data['security'] = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row();

		$this->load->view('list_ba/tampil_sertifikat', $data);
	}

	public function doResample($idqa)
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$get = $this->db->get_where('t_qa', array('idqa' => $idqa))->row();
		$idba = $get->idba;
		$ba = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row();
		$id_sample = $get->id_sample.'R';
		$id_sample_ppic = $this->tsfs->entsfs($id_sample);
		$id_sample_lab = $this->tsfs->entsfs($id_sample_ppic);

		$where = array('id_sample' => $id_sample);
		$cek = $this->db->get_where('t_qa', $where)->num_rows();
		if($cek == 0)
		{
			$dataAddToQA = array('id_sample' => $id_sample,
								 'idba' => $idba,
								 'id_sample_ppic' => $id_sample_ppic, 
								 'id_sample_lab' => $id_sample_lab,
								 'addby' => $this->session->userdata('uid'),
								 'adddate' => date('Y-m-d H:i:s'),
								 'year' => date('Y')
						   );
			$this->ppic_sample_model->createDataToQA('t_qa', $dataAddToQA);

			$dataRLIS = array('resample' => '1',
							  'resample_date' => date('Y-m-d H:i:s')
						);
			$this->db->where('id_ba', $idba);
			$this->db->update('berita_acara', $dataRLIS);

			$dataCIS = array('status_approval_qc' => '0',
							 'status_approval_ppic' => '0'
					   );
			$this->db2->where('id_ba', $idba);
			$this->db2->update('berita_acara', $dataCIS);
			
			$this->session->set_flashdata('message_ok', 'Data Resample Telah disimpan dengan nomor sample '.$id_sample);
			redirect('list_ba/listBA/baTolak');
		} else
		{
			$this->session->set_flashdata('message_ok', 'Data sudah diresample dengan nomor sample '.$id_sample);
			redirect('list_ba/listBA/baTolak');
		}
	}

	public function doResample2($idqa)
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$get = $this->db->get_where('t_qa', array('idqa' => $idqa))->row();
		$idba = $get->idba;
		$ba = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row();
		$id_sample = $get->id_sample.'RR';
		$id_sample_ppic = $this->tsfs->entsfs($id_sample);
		$id_sample_lab = $this->tsfs->entsfs($id_sample_ppic);

		$where = array('id_sample' => $id_sample);
		$cek = $this->db->get_where('t_qa', $where)->num_rows();
		if($cek == 0)
		{
			$dataAddToQA = array('id_sample' => $id_sample,
								 'idba' => $idba,
								 'id_sample_ppic' => $id_sample_ppic, 
								 'id_sample_lab' => $id_sample_lab,
								 'addby' => $this->session->userdata('uid'),
								 'adddate' => date('Y-m-d H:i:s'),
								 'year' => date('Y')
						   );
			$this->ppic_sample_model->createDataToQA('t_qa', $dataAddToQA);

			$dataRLIS = array('resample' => '2',
							  'resample_date' => date('Y-m-d H:i:s')
						);
			$this->db->where('id_ba', $idba);
			$this->db->update('berita_acara', $dataRLIS);

			$dataCIS = array('status_approval_qc' => '0',
							 'status_approval_ppic' => '0'
					   );
			$this->db2->where('id_ba', $idba);
			$this->db2->update('berita_acara', $dataCIS);
			
			$this->session->set_flashdata('message_ok', 'Data Resample Telah disimpan dengan nomor sample '.$id_sample);
			redirect('list_ba/listBA/baTolak');
		} else
		{
			$this->session->set_flashdata('message_ok', 'Data sudah diresample dengan nomor sample '.$id_sample);
			redirect('list_ba/listBA/baTolak');
		}
	}

	function ba_tolak_export_excel()
	{
		$awal = $this->input->post('awal').' 00:00:00';
		$akhir = $this->input->post('akhir').' 23:59:59';
		$awaln = $this->input->post('awal');
		$akhirn = $this->input->post('akhir');
		$data['all_data'] = $this->list_ba_model->viewBATolakWithRange($awal, $akhir)->result();
		$data['namafile'] = 'ba_tolak_'.$awaln.'_'.$akhirn;
		$this->load->view('list_ba/ba_tolak_excel', $data);
	}

	function ba_ok_export_excel()
	{
		$awal = $this->input->post('awal').' 00:00:00';
		$akhir = $this->input->post('akhir').' 23:59:59';
		$awaln = $this->input->post('awal');
		$akhirn = $this->input->post('akhir');
		$data['all_data'] = $this->list_ba_model->viewBAOkWithRange($awal, $akhir)->result();
		$data['namafile'] = 'ba_ok_'.$awaln.'_'.$akhirn;
		$this->load->view('list_ba/ba_ok_excel', $data);
	}

	function list_disposisi()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		//Otorisasi menu
		$this->fungsi->menu_auth($this->ba_ok);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$nomor_sample = $this->list_ba_model->viewBA($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->list_ba_model->countBA($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('list_ba/listBA/list_disposisi');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Tanggal', 'Nomor Sample', 'Pengirim', 'Manifest', 'Surat Jalan', 'PPIC', 'LAB', 'Analis', 'Air', 'Bahan Bakar', 'Residu', 'Sedimen', 'Viscositas', 'Berat Jenis', 'kg/I', 'Volume Kirim', 'Volume Masuk', 'Status', 'Options');
			foreach($nomor_sample as $row)
			{	
				$rowCIS = $this->db2->get_where('berita_acara', array('id_ba' => $row->idba))->row();
				$rowRLIS = $this->db->get_where('berita_acara', array('id_ba' => $row->idba))->row();
				$status = ($row->status == 'DITERIMA' ? '<b style="color:green">'.$row->status.'</b>' : '<b style="color:red">'.$row->status.'</b>');
				$this->table->add_row($row->idba, $this->fungsi->formatTanggal($row->adddate), $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $rowRLIS->no_sj, $row->id_sample_ppic, $row->id_sample_lab, $row->checkby, $row->qcair, $row->qcbakar, $row->qcresidu, $row->qcresidub, $row->qcvisco, $row->qckg, $row->qckg2, $rowCIS->vol_coll, $rowCIS->vol_ppic, $status, anchor('list_ba/listBA/doDisposisi/'.$row->idqa,'Disposisi',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > LIST BA > DISPOSISI';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('list_ba/listBA/list_disposisi');
		$this->load->view('list_ba/tampil_berita_acara_disposisi', $data);
	}

	function doDisposisi($idqa)
	{
		$row = $this->db->get_where('t_qa', array('idqa' => $idqa))->row();
		$status = ($row->status == 'DITERIMA' ? 'DITOLAK' : 'DITERIMA');
		$update = array('status' => $status);
		$this->db->where('idqa', $idqa);
		$this->db->update('t_qa', $update);
		$this->session->set_flashdata('message_ok', 'Berhasil disposisi dengan nomor BA: '.$row->idba);
		redirect(base_url('list_ba/listBA/list_disposisi'));
	}
}