<?php
/*
Fungsi : Controller untuk frame body
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class qaSample extends CI_Controller {

	//Menu ID utk keperluan otorisasi
	var $menu_create_ba_analisis = 174;
	var $menu_approve_qa = 206;

	public function index()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }

		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->qa_sample_model->viewNomorAnalisa($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->qa_sample_model->countNomorAnalisa($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('qa_sample/qaSample/index');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;

			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);

			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Sample', 'Options');

			foreach($berita_acara as $row)
			{
				$this->table->add_row($row->id_sample_lab, anchor('qa_sample/qaSample/createForm/'.$row->idqa,'Entry Data',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}
		$data['menu_path'] = 'CIBITUNG > QA LAB > CREATE BA FOR ANALISIS';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));
		$data['form_action']= site_url('qa_sample/qaSample/index');
		$this->load->view('qa_sample/tampil_nomor_analisis', $data);
	}

	public function viewListBARetesting()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }

		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->qa_sample_model->viewBARetesting($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->qa_sample_model->countBARetesting($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('qa_sample/qaSample/viewListBARetesting');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;

			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);

			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Sample', 'Options');

			foreach($berita_acara as $row)
			{
				$this->table->add_row($row->retesting_lab, anchor('qa_sample/qaSample/retestingForm/'.$row->retesting_id, 'Entry Data', array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}
		$data['menu_path'] = 'CIBITUNG > QA LAB > CREATE BA FOR RETESTING';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));
		$data['form_action']= site_url('qa_sample/qaSample/viewListBARetesting');
		$this->load->view('qa_sample/tampil_nomor_analisis', $data);
	}

	public function createForm()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > QA LAB > CREATE BA FOR ANALISIS';
		$this->load->view('qa_sample/formulir_analisis', $data);
	}

	public function retestingForm()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > QA LAB > CREATE BA FOR RETESTING';
		$this->load->view('qa_sample/formulir_retesting', $data);
	}

	public function doInsertDataAnalisis()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$idqa = $this->input->post('idqa');
		$test_bahan_kimia = $this->input->post('txt_tbk');
		$kadar_air = $this->input->post('txt_air');
		$kadar_bahan_bakar = $this->input->post('txt_bbakar');
		$kadar_residu = $this->input->post('txt_residu');
		$sedimen = $this->input->post('txt_residub');
		$berat_jenis_satu = $this->input->post('txt_kg');
		$temperatur = $this->input->post('txt_t');
		$berat_jenis_dua = $this->input->post('qc_kg2');
		$temperatur_lapangan = $this->input->post('qc_t2');
		$chlorine = $this->input->post('txt_cl');
		$viscositas = $this->input->post('txt_visco');

		$idba = $this->db->get_where('t_qa', array('idqa' => $idqa))->row('idba');
		$pengirim = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row('pengirim');
		$nama_pengirim = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row('nama_sup');

		if($pengirim == 'CABANG')
		{
			if($kadar_air <= 8.0)
			{
				$status_kadar_air = 'DITERIMA';
			} else
			{
				$status_kadar_air = 'DITOLAK';
			}
		} else
		{
			if($kadar_air <= 5.0)
			{
				$status_kadar_air = 'DITERIMA';
			} elseif($kadar_air > 5.0 && $kadar_air <= 8.0)
			{
				$kadar_air_potong = $kadar_air - 5.0;
				$status_kadar_air = 'KADAR AIR DIPOTONG '.$kadar_air_potong.'%';
			} else
			{
				$status_kadar_air = 'DITOLAK';
			}
		}

		if($chlorine == 'NEGATIF')
		{
			$status_chlorine = 'DITERIMA';
		} else
		{
			$status_chlorine = 'DITOLAK';
		}

		if($nama_pengirim == 'COLL BANJARMASIN' || $nama_pengirim == 'COLL SAMARINDA' || $nama_pengirim == 'PT. Nazar' || $nama_pengirim == 'PT. MAJU Kalimantan')
		{
			if($berat_jenis_satu <= 0.900)
			{
				$status_berat_jenis = 'DITERIMA';
			} else
			{
				$status_berat_jenis = 'DITOLAK';
			}
		} else
		{
			if($berat_jenis_satu <= 0.885)
			{
				$status_berat_jenis = 'DITERIMA';
			} else
			{
				$status_berat_jenis = 'DITOLAK';
			}
		}

		if($test_bahan_kimia == 'NEGATIF')
		{
			$status_test_bahan_kimia = 'DITERIMA';
		} else
		{
			$status_test_bahan_kimia = 'DITOLAK';
		}

		// if($kadar_bahan_bakar <= 5)
		// {
		// 	$status_kadar_bahan_bakar = 'DITERIMA';
		// } else
		// {
		// 	$status_kadar_bahan_bakar = 'DITOLAK';
		// }

		if($kadar_bahan_bakar == '<5')
		{
			$status_kadar_bahan_bakar = 'DITERIMA';
		} else
		{
			$status_kadar_bahan_bakar = 'DITOLAK';
		}

		if($kadar_residu <= 7)
		{
			$status_kadar_residu = 'DITERIMA';
		} else
		{
			$status_kadar_residu = 'DITOLAK';
		}

		if($sedimen <= 0.8)
		{
			$status_sedimen = 'DITERIMA';
		} else
		{
			$status_sedimen = 'DITOLAK';
		}

		if($status_kadar_air == 'DITOLAK' || $status_chlorine == 'DITOLAK' || $status_berat_jenis == 'DITOLAK' || $status_test_bahan_kimia == 'DITOLAK' || $status_kadar_bahan_bakar == 'DITOLAK' || $status_kadar_residu == 'DITOLAK' || $status_sedimen == 'DITOLAK')
		{
			$status_utama = 'DITOLAK';
		} else
		{
			$status_utama = 'DITERIMA';
		}

		$informasi = '&emsp;&emsp;STATUS : '.$status_utama.'<br>'.'&emsp;&emsp;KADAR AIR : '.$status_kadar_air.'<br>'.'&emsp;&emsp;CHLORINE/PCB : '.$status_chlorine.'<br>'.'&emsp;&emsp;BERAT JENIS : '.$status_berat_jenis.'<br>'.'&emsp;&emsp;FATTY ACID : '.$status_test_bahan_kimia.'<br>'.'&emsp;&emsp;KADAR BAHAN BAKAR : '.$status_kadar_bahan_bakar.'<br>'.'&emsp;&emsp;KADAR RESIDU : '.$status_kadar_residu.'<br>'.'&emsp;&emsp;SEDIMEN : '.$status_sedimen;

		if($status_utama == 'DITERIMA')
		{
			$status_qc = '1';
			$status_approval_qc = '1';
		} else
		{
			$status_qc = '2';
			$status_approval_qc = '0';
		}

		$updateDataRLIS = array('qctbk' => $test_bahan_kimia,
							'qcair' => $kadar_air,
							'qccl' => $chlorine,
							'qcvisco' => $viscositas,
							'qcbakar' => $kadar_bahan_bakar,
							'qcresidu' => $kadar_residu,
							'qcresidub' => $sedimen,
							'qckg' => $berat_jenis_satu,
							'qct' => $temperatur,
							'inf' => $informasi,
							'qckg2' => $berat_jenis_dua,
							'qct2' => $temperatur_lapangan,
							'status' => $status_utama,
							'status_qc' => $status_qc,
							'waktu_periksa_qa' => date('Y-m-d H:i:s'),
							'checkby' => $this->session->userdata('uid')
					  	);
		$this->qa_sample_model->uData('t_qa', $updateDataRLIS, $idqa);


		$updateDataCIS = array('qc_tbk' => $test_bahan_kimia,
							   'qc_air' => $kadar_air,
							   'qc_cl' => $chlorine,
							   'qc_bakar' => $kadar_bahan_bakar,
							   'qc_residu' => $kadar_residu,
							   'status_qc' => $status_qc,
							   'status_approval_qc' => $status_approval_qc
					 	 );
		//$this->qa_sample_model->uDataToCIS('berita_acara', $updateDataCIS, $id_ba);

		$this->session->set_flashdata('message_ok', 'Data input succesfully');
		redirect('qa_sample/qaSample');
	}

	public function doEditDataAnalisis()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$idqa = $this->input->post('idqa');
		$test_bahan_kimia = $this->input->post('txt_tbk');
		$kadar_air = $this->input->post('txt_air');
		$kadar_bahan_bakar = $this->input->post('txt_bbakar');
		$kadar_residu = $this->input->post('txt_residu');
		$sedimen = $this->input->post('txt_residub');
		$berat_jenis_satu = $this->input->post('txt_kg');
		$temperatur = $this->input->post('txt_t');
		$berat_jenis_dua = $this->input->post('qc_kg2');
		$temperatur_lapangan = $this->input->post('qc_t2');
		$chlorine = $this->input->post('txt_cl');
		$viscositas = $this->input->post('txt_visco');

		$idba = $this->db->get_where('t_qa', array('idqa' => $idqa))->row('idba');
		$pengirim = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row('pengirim');

		if($pengirim == 'CABANG')
		{
			if($kadar_air <= 8.0)
			{
				$status_kadar_air = 'DITERIMA';
			} else
			{
				$status_kadar_air = 'DITOLAK';
			}
		} else
		{
			if($kadar_air <= 5.0)
			{
				$status_kadar_air = 'DITERIMA';
			} elseif($kadar_air > 5.0 && $kadar_air <= 8.0)
			{
				$kadar_air_potong = $kadar_air - 5.0;
				$status_kadar_air = 'KADAR AIR DIPOTONG '.$kadar_air_potong.'%';
			} else
			{
				$status_kadar_air = 'DITOLAK';
			}
		}

		if($chlorine == 'NEGATIF')
		{
			$status_chlorine = 'DITERIMA';
		} else
		{
			$status_chlorine = 'DITOLAK';
		}

		if($nama_pengirim == 'COLL BANJARMASIN' || $nama_pengirim == 'COLL SAMARINDA' || $nama_pengirim == 'PT. Nazar' || $nama_pengirim == 'PT. MAJU Kalimantan')
		{
			if($berat_jenis_satu <= 0.900)
			{
				$status_berat_jenis = 'DITERIMA';
			} else
			{
				$status_berat_jenis = 'DITOLAK';
			}
		} else
		{
			if($berat_jenis_satu <= 0.885)
			{
				$status_berat_jenis = 'DITERIMA';
			} else
			{
				$status_berat_jenis = 'DITOLAK';
			}
		}

		if($test_bahan_kimia == 'NEGATIF')
		{
			$status_test_bahan_kimia = 'DITERIMA';
		} else
		{
			$status_test_bahan_kimia = 'DITOLAK';
		}

		if($kadar_bahan_bakar <= 5)
		{
			$status_kadar_bahan_bakar = 'DITERIMA';
		} else
		{
			$status_kadar_bahan_bakar = 'DITOLAK';
		}

		if($kadar_residu <= 7)
		{
			$status_kadar_residu = 'DITERIMA';
		} else
		{
			$status_kadar_residu = 'DITOLAK';
		}

		if($sedimen <= 0.8)
		{
			$status_sedimen = 'DITERIMA';
		} else
		{
			$status_sedimen = 'DITOLAK';
		}

		if($status_kadar_air == 'DITOLAK' || $status_chlorine == 'DITOLAK' || $status_berat_jenis == 'DITOLAK' || $status_test_bahan_kimia == 'DITOLAK' || $status_kadar_bahan_bakar == 'DITOLAK' || $status_kadar_residu == 'DITOLAK' || $status_sedimen == 'DITOLAK')
		{
			$status_utama = 'DITOLAK';
		} else
		{
			$status_utama = 'DITERIMA';
		}

		$informasi = '&emsp;&emsp;STATUS : '.$status_utama.'<br>'.'&emsp;&emsp;KADAR AIR : '.$status_kadar_air.'<br>'.'&emsp;&emsp;CHLORINE/PCB : '.$status_chlorine.'<br>'.'&emsp;&emsp;BERAT JENIS : '.$status_berat_jenis.'<br>'.'&emsp;&emsp;FATTY ACID : '.$status_test_bahan_kimia.'<br>'.'&emsp;&emsp;KADAR BAHAN BAKAR : '.$status_kadar_bahan_bakar.'<br>'.'&emsp;&emsp;KADAR RESIDU : '.$status_kadar_residu.'<br>'.'&emsp;&emsp;SEDIMEN : '.$status_sedimen;

		if($status_utama == 'DITERIMA')
		{
			$status_qc = '1';
			$status_approval_qc = '1';
		} else
		{
			$status_qc = '2';
			$status_approval_qc = '0';
		}

		$updateDataRLIS = array('qctbk' => $test_bahan_kimia,
							'qcair' => $kadar_air,
							'qccl' => $chlorine,
							'qcvisco' => $viscositas,
							'qcbakar' => $kadar_bahan_bakar,
							'qcresidu' => $kadar_residu,
							'qcresidub' => $sedimen,
							'qckg' => $berat_jenis_satu,
							'qct' => $temperatur,
							'inf' => $informasi,
							'qckg2' => $berat_jenis_dua,
							'qct2' => $temperatur_lapangan,
							'status' => $status_utama,
							'status_qc' => $status_qc,
							'waktu_periksa_qa' => date('Y-m-d H:i:s'),
							'checkby' => $this->session->userdata('uid')
					  	);
		$this->qa_sample_model->uData('t_qa', $updateDataRLIS, $idqa);

		$kode_label_lab = $this->qa_sample_model->getKodeLabelLab($idqa);
		$nomor_sample = $this->tsfs->detsfs($this->tsfs->detsfs($kode_label_lab));
		$id_ba = 'BA/'.$nomor_sample;
		$id_ba = substr_replace($id_ba, '/', 7, 0);
		$id_ba = substr_replace($id_ba, '/', 9, 0);
		$updateDataCIS = array('status_qc' => $status_qc,
							   'status_approval_qc' => $status_approval_qc
						);
		$this->qa_sample_model->uDataToCIS('berita_acara', $updateDataCIS, $id_ba);

		$this->session->set_flashdata('message_ok', 'Data input succesfully');
		redirect('qa_sample/qaSample/viewListSampleQA');
	}

	public function doInsertDataRetesting()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$idqa = $this->input->post('idqa');
		$test_bahan_kimia = $this->input->post('txt_tbk');
		$kadar_air = $this->input->post('txt_air');
		$kadar_bahan_bakar = $this->input->post('txt_bbakar');
		$kadar_residu = $this->input->post('txt_residu');
		$sedimen = $this->input->post('txt_residub');
		$berat_jenis_satu = $this->input->post('txt_kg');
		$temperatur = $this->input->post('txt_t');
		$berat_jenis_dua = $this->input->post('qc_kg2');
		$temperatur_lapangan = $this->input->post('qc_t2');
		$chlorine = $this->input->post('txt_cl');

		$idba = $this->db->get_where('retesting', array('retesting_id' => $idqa))->row('retesting_ba');
		$pengirim = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row('pengirim');

		if($kadar_air <= 7.0)
		{
			$status_kadar_air = 'DITERIMA';
		} elseif($kadar_air > 5.0 && $kadar_air <= 7.0)
		{
			$kadar_air_potong = $kadar_air - 5.0;
			$status_kadar_air = 'KADAR AIR DIPOTONG '.$kadar_air_potong.'%';
		} else
		{
			$status_kadar_air = 'DITOLAK';
		}

		if($chlorine == 'NEGATIF')
		{
			$status_chlorine = 'DITERIMA';
		} else
		{
			$status_chlorine = 'DITOLAK';
		}

		if($nama_pengirim == 'COLL BANJARMASIN' || $nama_pengirim == 'COLL SAMARINDA' || $nama_pengirim == 'PT. Nazar' || $nama_pengirim == 'PT. MAJU Kalimantan')
		{
			if($berat_jenis_satu <= 0.900)
			{
				$status_berat_jenis = 'DITERIMA';
			} else
			{
				$status_berat_jenis = 'DITOLAK';
			}
		} else
		{
			if($berat_jenis_satu <= 0.885)
			{
				$status_berat_jenis = 'DITERIMA';
			} elseif($berat_jenis_satu > 0.885 && $berat_jenis_satu <= 0.890 && $viscositas > 10)
			{
				$status_berat_jenis = 'DITERIMA';
			} else
			{
				$status_berat_jenis = 'DITOLAK';
			}
		}

		if($test_bahan_kimia == 'NEGATIF')
		{
			$status_test_bahan_kimia = 'DITERIMA';
		} else
		{
			$status_test_bahan_kimia = 'DITERIMA';
		}

		if($kadar_bahan_bakar <= 5)
		{
			$status_kadar_bahan_bakar = 'DITERIMA';
		} else
		{
			$status_kadar_bahan_bakar = 'DITOLAK';
		}

		if($kadar_residu <= 7)
		{
			$status_kadar_residu = 'DITERIMA';
		} else
		{
			$status_kadar_residu = 'DITOLAK';
		}

		if($sedimen <= 0.8)
		{
			$status_sedimen = 'DITERIMA';
		} else
		{
			$status_sedimen = 'DITOLAK';
		}

		if($status_kadar_air == 'DITOLAK' || $status_chlorine == 'DITOLAK' || $status_berat_jenis == 'DITOLAK' || $status_test_bahan_kimia == 'DITOLAK' || $status_kadar_bahan_bakar == 'DITOLAK' || $status_kadar_residu == 'DITOLAK' || $status_sedimen == 'DITOLAK')
		{
			$status_utama = 'DITOLAK';
		} else
		{
			$status_utama = 'DITERIMA';
		}

		$informasi = '&emsp;&emsp;STATUS : '.$status_utama.'<br>'.'&emsp;&emsp;KADAR AIR : '.$status_kadar_air.'<br>'.'&emsp;&emsp;CHLORINE/PCB : '.$status_chlorine.'<br>'.'&emsp;&emsp;BERAT JENIS : '.$status_berat_jenis.'<br>'.'&emsp;&emsp;FATTY ACID : '.$status_test_bahan_kimia.'<br>'.'&emsp;&emsp;KADAR BAHAN BAKAR : '.$status_kadar_bahan_bakar.'<br>'.'&emsp;&emsp;KADAR RESIDU : '.$status_kadar_residu.'<br>'.'&emsp;&emsp;SEDIMEN : '.$status_sedimen;

		if($status_utama == 'DITERIMA')
		{
			$status_qc = '1';
			$status_approval_qc = '1';
		} else
		{
			$status_qc = '2';
			$status_approval_qc = '0';
		}

		$data = array('tbk' => $test_bahan_kimia,
					'air' => $kadar_air,
					'cl' => $chlorine,
					'bakar' => $kadar_bahan_bakar,
					'residu' => $kadar_residu,
					'residu_b' => $sedimen,
					'kg' => $berat_jenis_satu,
					't' => $temperatur,
					'info' => $informasi,
					'kg2' => $berat_jenis_dua,
					't2' => $temperatur_lapangan,
					'status' => $status_utama,
					'status_input_qc' => $status_qc,
					'checktime' => date('Y-m-d H:i:s'),
					'checkby' => $this->session->userdata('uid')
				);
		$this->qa_sample_model->uDataRetesting('retesting', $data, $idqa);

		$this->session->set_flashdata('message_ok', 'Data input succesfully');
		redirect('qa_sample/qaSample/viewListBARetesting');
	}

	public function doEditDataRetesting()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$idqa = $this->input->post('idqa');
		$test_bahan_kimia = $this->input->post('txt_tbk');
		$kadar_air = $this->input->post('txt_air');
		$kadar_bahan_bakar = $this->input->post('txt_bbakar');
		$kadar_residu = $this->input->post('txt_residu');
		$sedimen = $this->input->post('txt_residub');
		$berat_jenis_satu = $this->input->post('txt_kg');
		$temperatur = $this->input->post('txt_t');
		$berat_jenis_dua = $this->input->post('qc_kg2');
		$temperatur_lapangan = $this->input->post('qc_t2');
		$chlorine = $this->input->post('txt_cl');

		$idba = $this->db->get_where('retesting', array('retesting_id' => $idqa))->row('retesting_ba');
		$pengirim = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row('pengirim');

		if($pengirim == 'CABANG')
		{
			if($kadar_air <= 8.0)
			{
				$status_kadar_air = 'DITERIMA';
			} else
			{
				$status_kadar_air = 'DITOLAK';
			}
		} else
		{
			if($kadar_air <= 5.0)
			{
				$status_kadar_air = 'DITERIMA';
			} elseif($kadar_air > 5.0 && $kadar_air <= 8.0)
			{
				$kadar_air_potong = $kadar_air - 5.0;
				$status_kadar_air = 'KADAR AIR DIPOTONG '.$kadar_air_potong.'%';
			} else
			{
				$status_kadar_air = 'DITOLAK';
			}
		}

		if($chlorine == 'NEGATIF')
		{
			$status_chlorine = 'DITERIMA';
		} else
		{
			$status_chlorine = 'DITOLAK';
		}

		if($nama_pengirim == 'COLL BANJARMASIN' || $nama_pengirim == 'COLL SAMARINDA' || $nama_pengirim == 'PT. Nazar' || $nama_pengirim == 'PT. MAJU Kalimantan')
		{
			if($berat_jenis_satu <= 0.900)
			{
				$status_berat_jenis = 'DITERIMA';
			} else
			{
				$status_berat_jenis = 'DITOLAK';
			}
		} else
		{
			if($berat_jenis_satu <= 0.885)
			{
				$status_berat_jenis = 'DITERIMA';
			} elseif($berat_jenis_satu > 0.885 && $berat_jenis_satu <= 0.890 && $viscositas > 10)
			{
				$status_berat_jenis = 'DITERIMA';
			} else
			{
				$status_berat_jenis = 'DITOLAK';
			}
		}

		if($test_bahan_kimia == 'NEGATIF')
		{
			$status_test_bahan_kimia = 'DITERIMA';
		} else
		{
			$status_test_bahan_kimia = 'DITOLAK';
		}

		if($kadar_bahan_bakar <= 5)
		{
			$status_kadar_bahan_bakar = 'DITERIMA';
		} else
		{
			$status_kadar_bahan_bakar = 'DITOLAK';
		}

		if($kadar_residu <= 7)
		{
			$status_kadar_residu = 'DITERIMA';
		} else
		{
			$status_kadar_residu = 'DITOLAK';
		}

		if($sedimen <= 0.8)
		{
			$status_sedimen = 'DITERIMA';
		} else
		{
			$status_sedimen = 'DITOLAK';
		}

		if($status_kadar_air == 'DITOLAK' || $status_chlorine == 'DITOLAK' || $status_berat_jenis == 'DITOLAK' || $status_test_bahan_kimia == 'DITOLAK' || $status_kadar_bahan_bakar == 'DITOLAK' || $status_kadar_residu == 'DITOLAK' || $status_sedimen == 'DITOLAK')
		{
			$status_utama = 'DITOLAK';
		} else
		{
			$status_utama = 'DITERIMA';
		}

		$informasi = '&emsp;&emsp;STATUS : '.$status_utama.'<br>'.'&emsp;&emsp;KADAR AIR : '.$status_kadar_air.'<br>'.'&emsp;&emsp;CHLORINE/PCB : '.$status_chlorine.'<br>'.'&emsp;&emsp;BERAT JENIS : '.$status_berat_jenis.'<br>'.'&emsp;&emsp;FATTY ACID : '.$status_test_bahan_kimia.'<br>'.'&emsp;&emsp;KADAR BAHAN BAKAR : '.$status_kadar_bahan_bakar.'<br>'.'&emsp;&emsp;KADAR RESIDU : '.$status_kadar_residu.'<br>'.'&emsp;&emsp;SEDIMEN : '.$status_sedimen;

		if($status_utama == 'DITERIMA')
		{
			$status_qc = '1';
			$status_approval_qc = '1';
		} else
		{
			$status_qc = '2';
			$status_approval_qc = '0';
		}

		$update = array('tbk' => $test_bahan_kimia,
						'air' => $kadar_air,
						'cl' => $chlorine,
						'bakar' => $kadar_bahan_bakar,
						'residu' => $kadar_residu,
						'residu_b' => $sedimen,
						'kg' => $berat_jenis_satu,
						't' => $temperatur,
						'info' => $informasi,
						'kg2' => $berat_jenis_dua,
						't2' => $temperatur_lapangan,
						'status' => $status_utama,
						'status_input_qc' => $status_qc,
						'checktime' => date('Y-m-d H:i:s'),
						'checkby' => $this->session->userdata('uid')
				  );
		$this->qa_sample_model->uDataRetesting('retesting', $update, $idqa);

		$this->session->set_flashdata('message_ok', 'Data input succesfully');
		redirect('qa_sample/qaSample/viewListSampleQARetesting');
	}

	public function doInsertDataAnalisis_baru()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$idqa = $this->input->post('idqa');
		$test_bahan_kimia = $this->input->post('txt_tbk');
		$kadar_air = $this->input->post('txt_air');
		$kadar_bahan_bakar = $this->input->post('txt_bbakar');
		$kadar_residu = $this->input->post('txt_residu');
		$sedimen = $this->input->post('txt_residub');
		$berat_jenis_satu = $this->input->post('txt_kg');
		$temperatur = $this->input->post('txt_t');
		$berat_jenis_dua = $this->input->post('qc_kg2');
		$temperatur_lapangan = $this->input->post('qc_t2');
		$chlorine = $this->input->post('txt_cl');
		$viscositas = $this->input->post('txt_visco');

		$idba = $this->db->get_where('t_qa', array('idqa' => $idqa))->row('idba');
		$pengirim = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row('pengirim');
		$nama_pengirim = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row('nama_sup');

		if($kadar_air <= 5.0)
		{
			$status_kadar_air = 'DITERIMA';
		} elseif($kadar_air > 5.0 && $kadar_air <= 10.0)
		{
			$kadar_air_potong_air = $kadar_air - 5.0;
			$air_potong = $kadar_air_potong_air;
			$status_kadar_air = 'KADAR VOLUME DIPOTONG '.$kadar_air_potong_air.'%';
		} else
		{
			$status_kadar_air = 'DITOLAK';
		}

		if($chlorine == 'NEGATIF')
		{
			$status_chlorine = 'DITERIMA';
		} else
		{
			$status_chlorine = 'DITOLAK';
		}

		if($berat_jenis_satu <= 0.8900)
		{
			$status_berat_jenis = 'DITERIMA';
		} else
		{
			$status_berat_jenis = 'DITOLAK';
		}

		if($test_bahan_kimia == 'NEGATIF')
		{
			$status_test_bahan_kimia = 'DITERIMA';
		} else
		{
			$status_test_bahan_kimia = 'DITERIMA';
		}

		if($kadar_bahan_bakar <= 5)
		{
			$status_kadar_bahan_bakar = 'DITERIMA';
		} else
		{
			$status_kadar_bahan_bakar = 'DITOLAK';
		}

		if($kadar_residu <= 7)
		{
			$status_kadar_residu = 'DITERIMA';
		} elseif($kadar_residu > 7 && $kadar_residu <= 9)
		{
			if($kadar_residu >= 7.1 && $kadar_residu <= 7.5)
			{
				$kadar_air_potong_residu = 0.5;
			} elseif($kadar_residu >= 7.6 && $kadar_residu <= 8.0)
			{
				$kadar_air_potong_residu = 1.0;
			} elseif($kadar_residu >= 8.1 && $kadar_residu <= 8.5)
			{
				$kadar_air_potong_residu = 1.5;
			} elseif($kadar_residu >= 8.6 && $kadar_residu <= 9.0)
			{
				$kadar_air_potong_residu = 2.0;
			}
			$air_potong = $air_potong + $kadar_air_potong_residu;
			$status_kadar_residu = 'KADAR VOLUME DIPOTONG '.$kadar_air_potong_residu.'%';
		} else
		{
			$status_kadar_residu = 'DITOLAK';
		}

		if($sedimen <= 0.8)
		{
			$status_sedimen = 'DITERIMA';
		} elseif($sedimen > 0.8 && $sedimen <= 1.0)
		{
			if($sedimen == 0.9)
			{
				$kadar_air_potong_sedimen = 2;
			} elseif($sedimen == 1.0)
			{
				$kadar_air_potong_sedimen = 4;
			}
			$air_potong = $air_potong + $kadar_air_potong_sedimen;
			$status_sedimen = 'KADAR VOLUME DIPOTONG '.$kadar_air_potong_sedimen.'%';
		} else
		{
			$status_sedimen = 'DITOLAK';
		}

		if($status_kadar_air == 'DITOLAK' || $status_chlorine == 'DITOLAK' || $status_berat_jenis == 'DITOLAK' || $status_test_bahan_kimia == 'DITOLAK' || $status_kadar_bahan_bakar == 'DITOLAK' || $status_kadar_residu == 'DITOLAK' || $status_sedimen == 'DITOLAK')
		{
			$status_utama = 'DITOLAK';
		} else
		{
			$status_utama = 'DITERIMA';
		}

		$informasi = '&emsp;&emsp;STATUS : '.$status_utama.'<br>'.'&emsp;&emsp;KADAR AIR : '.$status_kadar_air.'<br>'.'&emsp;&emsp;CHLORINE/PCB : '.$status_chlorine.'<br>'.'&emsp;&emsp;BERAT JENIS : '.$status_berat_jenis.'<br>'.'&emsp;&emsp;FATTY ACID : '.$status_test_bahan_kimia.'<br>'.'&emsp;&emsp;KADAR BAHAN BAKAR : '.$status_kadar_bahan_bakar.'<br>'.'&emsp;&emsp;KADAR RESIDU : '.$status_kadar_residu.'<br>'.'&emsp;&emsp;SEDIMEN : '.$status_sedimen;

		if($status_utama == 'DITERIMA')
		{
			$status_qc = '1';
			$status_approval_qc = '1';
		} else
		{
			$status_qc = '2';
			$status_approval_qc = '0';
		}

		$updateDataRLIS = array('qctbk' => $test_bahan_kimia,
							'qcair' => $kadar_air,
							'qccl' => $chlorine,
							'qcvisco' => $viscositas,
							'qcbakar' => $kadar_bahan_bakar,
							'qcresidu' => $kadar_residu,
							'qcresidub' => $sedimen,
							'qckg' => $berat_jenis_satu,
							'qct' => $temperatur,
							'inf' => $informasi,
							'qckg2' => $berat_jenis_dua,
							'qct2' => $temperatur_lapangan,
							'status' => $status_utama,
							'status_qc' => $status_qc,
							'waktu_periksa_qa' => date('Y-m-d H:i:s'),
							'checkby' => $this->session->userdata('uid')
					  	);
		$this->qa_sample_model->uData('t_qa', $updateDataRLIS, $idqa);


		$updateDataCIS = array('qc_tbk' => $test_bahan_kimia,
							   'qc_air' => $kadar_air,
							   'qc_cl' => $chlorine,
							   'qc_bakar' => $kadar_bahan_bakar,
							   'qc_residu' => $kadar_residu,
							   'status_qc' => $status_qc,
							   'status_approval_qc' => $status_approval_qc
					 	 );
		//$this->qa_sample_model->uDataToCIS('berita_acara', $updateDataCIS, $id_ba);

		$this->session->set_flashdata('message_ok', 'Data input succesfully');
		redirect('qa_sample/qaSample');
	}

	public function doEditDataAnalisis_baru()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$idqa = $this->input->post('idqa');
		$test_bahan_kimia = $this->input->post('txt_tbk');
		$kadar_air = $this->input->post('txt_air');
		$kadar_bahan_bakar = $this->input->post('txt_bbakar');
		$kadar_residu = $this->input->post('txt_residu');
		$sedimen = $this->input->post('txt_residub');
		$berat_jenis_satu = $this->input->post('txt_kg');
		$temperatur = $this->input->post('txt_t');
		$berat_jenis_dua = $this->input->post('qc_kg2');
		$temperatur_lapangan = $this->input->post('qc_t2');
		$chlorine = $this->input->post('txt_cl');
		$viscositas = $this->input->post('txt_visco');

		$idba = $this->db->get_where('t_qa', array('idqa' => $idqa))->row('idba');
		$pengirim = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row('pengirim');

		if($kadar_air <= 5.0)
		{
			$status_kadar_air = 'DITERIMA';
		} elseif($kadar_air > 5.0 && $kadar_air <= 10.0)
		{
			$kadar_air_potong_air = $kadar_air - 5.0;
			$air_potong = $kadar_air_potong_air;
			$status_kadar_air = 'KADAR VOLUME DIPOTONG '.$kadar_air_potong_air.'%';
		} else
		{
			$status_kadar_air = 'DITOLAK';
		}

		if($chlorine == 'NEGATIF')
		{
			$status_chlorine = 'DITERIMA';
		} else
		{
			$status_chlorine = 'DITOLAK';
		}

		if($berat_jenis_satu <= 0.8900)
		{
			$status_berat_jenis = 'DITERIMA';
		} else
		{
			$status_berat_jenis = 'DITOLAK';
		}

		if($test_bahan_kimia == 'NEGATIF')
		{
			$status_test_bahan_kimia = 'DITERIMA';
		} else
		{
			$status_test_bahan_kimia = 'DITERIMA';
		}

		if($kadar_bahan_bakar <= 5)
		{
			$status_kadar_bahan_bakar = 'DITERIMA';
		} else
		{
			$status_kadar_bahan_bakar = 'DITOLAK';
		}

		if($kadar_residu <= 7)
		{
			$status_kadar_residu = 'DITERIMA';
		} elseif($kadar_residu > 7 && $kadar_residu <= 9)
		{
			if($kadar_residu >= 7.1 && $kadar_residu <= 7.5)
			{
				$kadar_air_potong_residu = 0.5;
			} elseif($kadar_residu >= 7.6 && $kadar_residu <= 8.0)
			{
				$kadar_air_potong_residu = 1.0;
			} elseif($kadar_residu >= 8.1 && $kadar_residu <= 8.5)
			{
				$kadar_air_potong_residu = 1.5;
			} elseif($kadar_residu >= 8.6 && $kadar_residu <= 9.0)
			{
				$kadar_air_potong_residu = 2.0;
			}
			$air_potong = $air_potong + $kadar_air_potong_residu;
			$status_kadar_residu = 'KADAR VOLUME DIPOTONG '.$kadar_air_potong_residu.'%';
		} else
		{
			$status_kadar_residu = 'DITOLAK';
		}

		if($sedimen <= 0.8)
		{
			$status_sedimen = 'DITERIMA';
		} elseif($sedimen > 0.8 && $sedimen <= 1.0)
		{
			if($sedimen == 0.9)
			{
				$kadar_air_potong_sedimen = 2;
			} elseif($sedimen == 1.0)
			{
				$kadar_air_potong_sedimen = 4;
			}
			$air_potong = $air_potong + $kadar_air_potong_sedimen;
			$status_sedimen = 'KADAR VOLUME DIPOTONG '.$kadar_air_potong_sedimen.'%';
		} else
		{
			$status_sedimen = 'DITOLAK';
		}

		if($status_kadar_air == 'DITOLAK' || $status_chlorine == 'DITOLAK' || $status_berat_jenis == 'DITOLAK' || $status_test_bahan_kimia == 'DITOLAK' || $status_kadar_bahan_bakar == 'DITOLAK' || $status_kadar_residu == 'DITOLAK' || $status_sedimen == 'DITOLAK')
		{
			$status_utama = 'DITOLAK';
		} else
		{
			$status_utama = 'DITERIMA';
		}

		$informasi = '&emsp;&emsp;STATUS : '.$status_utama.'<br>'.'&emsp;&emsp;KADAR AIR : '.$status_kadar_air.'<br>'.'&emsp;&emsp;CHLORINE/PCB : '.$status_chlorine.'<br>'.'&emsp;&emsp;BERAT JENIS : '.$status_berat_jenis.'<br>'.'&emsp;&emsp;FATTY ACID : '.$status_test_bahan_kimia.'<br>'.'&emsp;&emsp;KADAR BAHAN BAKAR : '.$status_kadar_bahan_bakar.'<br>'.'&emsp;&emsp;KADAR RESIDU : '.$status_kadar_residu.'<br>'.'&emsp;&emsp;SEDIMEN : '.$status_sedimen;

		if($status_utama == 'DITERIMA')
		{
			$status_qc = '1';
			$status_approval_qc = '1';
		} else
		{
			$status_qc = '2';
			$status_approval_qc = '0';
		}

		$updateDataRLIS = array('qctbk' => $test_bahan_kimia,
							'qcair' => $kadar_air,
							'qccl' => $chlorine,
							'qcvisco' => $viscositas,
							'qcbakar' => $kadar_bahan_bakar,
							'qcresidu' => $kadar_residu,
							'qcresidub' => $sedimen,
							'qckg' => $berat_jenis_satu,
							'qct' => $temperatur,
							'inf' => $informasi,
							'qckg2' => $berat_jenis_dua,
							'qct2' => $temperatur_lapangan,
							'status' => $status_utama,
							'status_qc' => $status_qc,
							'waktu_periksa_qa' => date('Y-m-d H:i:s'),
							'checkby' => $this->session->userdata('uid')
					  	);
		$this->qa_sample_model->uData('t_qa', $updateDataRLIS, $idqa);

		$kode_label_lab = $this->qa_sample_model->getKodeLabelLab($idqa);
		$nomor_sample = $this->tsfs->detsfs($this->tsfs->detsfs($kode_label_lab));
		$id_ba = 'BA/'.$nomor_sample;
		$id_ba = substr_replace($id_ba, '/', 7, 0);
		$id_ba = substr_replace($id_ba, '/', 9, 0);
		$updateDataCIS = array('status_qc' => $status_qc,
							   'status_approval_qc' => $status_approval_qc
						);
		$this->qa_sample_model->uDataToCIS('berita_acara', $updateDataCIS, $id_ba);

		$this->session->set_flashdata('message_ok', 'Data input succesfully');
		redirect('qa_sample/qaSample/viewListSampleQA');
	}

	public function doInsertDataAnalisis_gajadi_baru_soalnya()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$idqa = $this->input->post('idqa');
		$test_bahan_kimia = $this->input->post('txt_tbk');
		$kadar_air = $this->input->post('txt_air');
		$kadar_bahan_bakar = $this->input->post('txt_bbakar');
		$kadar_residu = $this->input->post('txt_residu');
		$sedimen = $this->input->post('txt_residub');
		$berat_jenis_satu = $this->input->post('txt_kg');
		$temperatur = $this->input->post('txt_t');
		$berat_jenis_dua = $this->input->post('qc_kg2');
		$temperatur_lapangan = $this->input->post('qc_t2');
		$chlorine = $this->input->post('txt_cl');
		$viscositas = $this->input->post('txt_visco');

		$idba = $this->db->get_where('t_qa', array('idqa' => $idqa))->row('idba');
		$pengirim = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row('pengirim');
		$nama_pengirim = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row('nama_sup');

		if($kadar_air <= 7.0)
		{
			$status_kadar_air = 'DITERIMA';
		} elseif($kadar_air > 5.0 && $kadar_air <= 7.0)
		{
			$kadar_air_potong = $kadar_air - 5.0;
			$status_kadar_air = 'KADAR AIR DIPOTONG '.$kadar_air_potong.'%';
		} else
		{
			$status_kadar_air = 'DITOLAK';
		}

		if($chlorine == 'NEGATIF')
		{
			$status_chlorine = 'DITERIMA';
		} else
		{
			$status_chlorine = 'DITOLAK';
		}

		if($berat_jenis_satu <= 0.8850)
		{
			$status_berat_jenis = 'DITERIMA';
		} else
		{
			$status_berat_jenis = 'DITOLAK';
		}

		if($test_bahan_kimia == 'NEGATIF')
		{
			$status_test_bahan_kimia = 'DITERIMA';
		} else
		{
			$status_test_bahan_kimia = 'DITERIMA';
		}

		if($kadar_bahan_bakar <= 5)
		{
			$status_kadar_bahan_bakar = 'DITERIMA';
		} else
		{
			$status_kadar_bahan_bakar = 'DITOLAK';
		}

		if($kadar_residu <= 7)
		{
			$status_kadar_residu = 'DITERIMA';
		} else
		{
			$status_kadar_residu = 'DITOLAK';
		}

		if($sedimen <= 0.8)
		{
			$status_sedimen = 'DITERIMA';
		} else
		{
			$status_sedimen = 'DITOLAK';
		}

		if($status_kadar_air == 'DITOLAK' || $status_chlorine == 'DITOLAK' || $status_berat_jenis == 'DITOLAK' || $status_test_bahan_kimia == 'DITOLAK' || $status_kadar_bahan_bakar == 'DITOLAK' || $status_kadar_residu == 'DITOLAK' || $status_sedimen == 'DITOLAK')
		{
			$status_utama = 'DITOLAK';
		} else
		{
			$status_utama = 'DITERIMA';
		}

		$informasi = '&emsp;&emsp;STATUS : '.$status_utama.'<br>'.'&emsp;&emsp;KADAR AIR : '.$status_kadar_air.'<br>'.'&emsp;&emsp;CHLORINE/PCB : '.$status_chlorine.'<br>'.'&emsp;&emsp;BERAT JENIS : '.$status_berat_jenis.'<br>'.'&emsp;&emsp;FATTY ACID : '.$status_test_bahan_kimia.'<br>'.'&emsp;&emsp;KADAR BAHAN BAKAR : '.$status_kadar_bahan_bakar.'<br>'.'&emsp;&emsp;KADAR RESIDU : '.$status_kadar_residu.'<br>'.'&emsp;&emsp;SEDIMEN : '.$status_sedimen;

		if($status_utama == 'DITERIMA')
		{
			$status_qc = '1';
			$status_approval_qc = '1';
		} else
		{
			$status_qc = '2';
			$status_approval_qc = '0';
		}

		$updateDataRLIS = array('qctbk' => $test_bahan_kimia,
							'qcair' => $kadar_air,
							'qccl' => $chlorine,
							'qcvisco' => $viscositas,
							'qcbakar' => $kadar_bahan_bakar,
							'qcresidu' => $kadar_residu,
							'qcresidub' => $sedimen,
							'qckg' => $berat_jenis_satu,
							'qct' => $temperatur,
							'inf' => $informasi,
							'qckg2' => $berat_jenis_dua,
							'qct2' => $temperatur_lapangan,
							'status' => $status_utama,
							'status_qc' => $status_qc,
							'waktu_periksa_qa' => date('Y-m-d H:i:s'),
							'checkby' => $this->session->userdata('uid')
					  	);
		$this->qa_sample_model->uData('t_qa', $updateDataRLIS, $idqa);


		$updateDataCIS = array('qc_tbk' => $test_bahan_kimia,
							   'qc_air' => $kadar_air,
							   'qc_cl' => $chlorine,
							   'qc_bakar' => $kadar_bahan_bakar,
							   'qc_residu' => $kadar_residu,
							   'status_qc' => $status_qc,
							   'status_approval_qc' => $status_approval_qc
					 	 );
		//$this->qa_sample_model->uDataToCIS('berita_acara', $updateDataCIS, $id_ba);

		$this->session->set_flashdata('message_ok', 'Data input succesfully');
		redirect('qa_sample/qaSample');
	}

	public function doEditDataAnalisis_gajadi_baru_soalnya()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$idqa = $this->input->post('idqa');
		$test_bahan_kimia = $this->input->post('txt_tbk');
		$kadar_air = $this->input->post('txt_air');
		$kadar_bahan_bakar = $this->input->post('txt_bbakar');
		$kadar_residu = $this->input->post('txt_residu');
		$sedimen = $this->input->post('txt_residub');
		$berat_jenis_satu = $this->input->post('txt_kg');
		$temperatur = $this->input->post('txt_t');
		$berat_jenis_dua = $this->input->post('qc_kg2');
		$temperatur_lapangan = $this->input->post('qc_t2');
		$chlorine = $this->input->post('txt_cl');
		$viscositas = $this->input->post('txt_visco');

		$idba = $this->db->get_where('t_qa', array('idqa' => $idqa))->row('idba');
		$pengirim = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row('pengirim');

		if($kadar_air <= 7.0)
		{
			$status_kadar_air = 'DITERIMA';
		} elseif($kadar_air > 5.0 && $kadar_air <= 7.0)
		{
			$kadar_air_potong = $kadar_air - 5.0;
			$status_kadar_air = 'KADAR AIR DIPOTONG '.$kadar_air_potong.'%';
		} else
		{
			$status_kadar_air = 'DITOLAK';
		}

		if($chlorine == 'NEGATIF')
		{
			$status_chlorine = 'DITERIMA';
		} else
		{
			$status_chlorine = 'DITOLAK';
		}

		if($berat_jenis_satu <= 0.8850)
		{
			$status_berat_jenis = 'DITERIMA';
		} else
		{
			$status_berat_jenis = 'DITOLAK';
		}

		if($test_bahan_kimia == 'NEGATIF')
		{
			$status_test_bahan_kimia = 'DITERIMA';
		} else
		{
			$status_test_bahan_kimia = 'DITERIMA';
		}

		if($kadar_bahan_bakar <= 5)
		{
			$status_kadar_bahan_bakar = 'DITERIMA';
		} else
		{
			$status_kadar_bahan_bakar = 'DITOLAK';
		}

		if($kadar_residu <= 7)
		{
			$status_kadar_residu = 'DITERIMA';
		} else
		{
			$status_kadar_residu = 'DITOLAK';
		}

		if($sedimen <= 0.8)
		{
			$status_sedimen = 'DITERIMA';
		} else
		{
			$status_sedimen = 'DITOLAK';
		}

		if($status_kadar_air == 'DITOLAK' || $status_chlorine == 'DITOLAK' || $status_berat_jenis == 'DITOLAK' || $status_test_bahan_kimia == 'DITOLAK' || $status_kadar_bahan_bakar == 'DITOLAK' || $status_kadar_residu == 'DITOLAK' || $status_sedimen == 'DITOLAK')
		{
			$status_utama = 'DITOLAK';
		} else
		{
			$status_utama = 'DITERIMA';
		}

		$informasi = '&emsp;&emsp;STATUS : '.$status_utama.'<br>'.'&emsp;&emsp;KADAR AIR : '.$status_kadar_air.'<br>'.'&emsp;&emsp;CHLORINE/PCB : '.$status_chlorine.'<br>'.'&emsp;&emsp;BERAT JENIS : '.$status_berat_jenis.'<br>'.'&emsp;&emsp;FATTY ACID : '.$status_test_bahan_kimia.'<br>'.'&emsp;&emsp;KADAR BAHAN BAKAR : '.$status_kadar_bahan_bakar.'<br>'.'&emsp;&emsp;KADAR RESIDU : '.$status_kadar_residu.'<br>'.'&emsp;&emsp;SEDIMEN : '.$status_sedimen;

		if($status_utama == 'DITERIMA')
		{
			$status_qc = '1';
			$status_approval_qc = '1';
		} else
		{
			$status_qc = '2';
			$status_approval_qc = '0';
		}

		$updateDataRLIS = array('qctbk' => $test_bahan_kimia,
							'qcair' => $kadar_air,
							'qccl' => $chlorine,
							'qcvisco' => $viscositas,
							'qcbakar' => $kadar_bahan_bakar,
							'qcresidu' => $kadar_residu,
							'qcresidub' => $sedimen,
							'qckg' => $berat_jenis_satu,
							'qct' => $temperatur,
							'inf' => $informasi,
							'qckg2' => $berat_jenis_dua,
							'qct2' => $temperatur_lapangan,
							'status' => $status_utama,
							'status_qc' => $status_qc,
							'waktu_periksa_qa' => date('Y-m-d H:i:s'),
							'checkby' => $this->session->userdata('uid')
					  	);
		$this->qa_sample_model->uData('t_qa', $updateDataRLIS, $idqa);

		$kode_label_lab = $this->qa_sample_model->getKodeLabelLab($idqa);
		$nomor_sample = $this->tsfs->detsfs($this->tsfs->detsfs($kode_label_lab));
		$id_ba = 'BA/'.$nomor_sample;
		$id_ba = substr_replace($id_ba, '/', 7, 0);
		$id_ba = substr_replace($id_ba, '/', 9, 0);
		$updateDataCIS = array('status_qc' => $status_qc,
							   'status_approval_qc' => $status_approval_qc
						);
		$this->qa_sample_model->uDataToCIS('berita_acara', $updateDataCIS, $id_ba);

		$this->session->set_flashdata('message_ok', 'Data input succesfully');
		redirect('qa_sample/qaSample/viewListSampleQA');
	}

	public function viewListSampleQA()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }

		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->qa_sample_model->viewListSample($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->qa_sample_model->countListSample($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('qa_sample/qaSample/viewListSampleQA');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;

			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);

			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Sample', 'Options');

			foreach($berita_acara as $row)
			{
				if($row->approval_spv_qc == '0')
				{
					$this->table->add_row($row->id_sample_lab, anchor('qa_sample/qaSample/formEditData/'.$row->idqa,'Edit Data',array('class' => 'update')));
				} else
				{
					$this->table->add_row($row->id_sample_lab, anchor('qa_sample/qaSample/viewData/'.$row->idqa,'View Data',array('class' => 'update')));
				}
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}
		$data['menu_path'] = 'CIBITUNG > QA LAB > LIST SAMPLE QA';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));
		$data['form_action']= site_url('qa_sample/qaSample/viewListSampleQA');
		$this->load->view('qa_sample/list_sample_qa', $data);
	}

	public function viewListSampleQARetesting()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }

		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->qa_sample_model->viewListSampleRetesting($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->qa_sample_model->countListSampleRetesting($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('qa_sample/qaSample/viewListSampleQARetesting');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;

			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);

			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Sample', 'Options');

			foreach($berita_acara as $row)
			{
				if($row->status_approval_qc == '0')
				{
					$this->table->add_row($row->retesting_lab, anchor('qa_sample/qaSample/formEditDataRetesting/'.$row->retesting_id,'Edit Data',array('class' => 'update')));
				} else
				{
					$this->table->add_row($row->retesting_lab, anchor('qa_sample/qaSample/viewDataRetesting/'.$row->retesting_id,'View Data',array('class' => 'update')));
				}
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}
		$data['menu_path'] = 'CIBITUNG > QA LAB > LIST SAMPLE QA RETESTING';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));
		$data['form_action']= site_url('qa_sample/qaSample/viewListSampleQARetesting');
		$this->load->view('qa_sample/list_sample_qa', $data);
	}

	public function formEditData($idqa)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > QA LAB > EDIT BA FOR ANALISIS';

		$data['data'] = $this->qa_sample_model->getDataAnalisis($idqa)->row();
		$this->load->view('qa_sample/formulir_analisis_edit', $data);
	}

	public function formEditDataRetesting($idqa)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > QA LAB > EDIT BA FOR RETESTING';

		$data['data'] = $this->qa_sample_model->getDataAnalisisRetesting($idqa)->row();
		$this->load->view('qa_sample/formulir_retesting_edit', $data);
	}

	public function viewListApproval()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_approve_qa);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }

		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->qa_sample_model->viewListSampleApp($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->qa_sample_model->countListSampleApp($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('qa_sample/qaSample/viewListApproval');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;

			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);

			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Sample', 'Options');

			foreach($berita_acara as $row)
			{
				$this->table->add_row($row->id_sample_lab, anchor('qa_sample/qaSample/detailData/'.$row->idqa,'Detail',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}
		$data['menu_path'] = 'CIBITUNG > QA LAB > LIST APPROVAL SAMPLE';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));
		$data['form_action']= site_url('qa_sample/qaSample/viewListApproval');
		$this->load->view('qa_sample/list_sample_qa', $data);
	}

	public function viewListApprovalRetesting()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_approve_qa);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }

		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->qa_sample_model->viewListSampleAppRetesting($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->qa_sample_model->countListSampleAppRetesting($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('qa_sample/qaSample/viewListApprovalRetesting');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;

			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);

			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Sample', 'Options');

			foreach($berita_acara as $row)
			{
				$this->table->add_row($row->retesting_lab, anchor('qa_sample/qaSample/detailDataRetesting/'.$row->retesting_id,'Detail',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}
		$data['menu_path'] = 'CIBITUNG > QA LAB > LIST APPROVAL RETESTING';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));
		$data['form_action']= site_url('qa_sample/qaSample/viewListApprovalRetesting');
		$this->load->view('qa_sample/list_sample_qa', $data);
	}

	public function detailData($idqa)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_approve_qa);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > QA LAB > APPROVAL DATA ANALISIS';

		$data['data'] = $this->qa_sample_model->getDataAnalisis($idqa)->row();
		$this->load->view('qa_sample/detail_data', $data);
	}

	public function detailDataRetesting($idqa)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_approve_qa);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > QA LAB > APPROVAL DATA RETESTING';

		$data['data'] = $this->qa_sample_model->getDataAnalisisRetesting($idqa)->row();
		$this->load->view('qa_sample/detail_data_retesting', $data);
	}

	public function doApprove($idqa)
	{
		$data = array(
					'approval_spv_qc' => '1',
					'appby' => $this->session->userdata('uid'),
					'waktu_approve_qa' => date('Y-m-d H:i:s')
				);
		$this->qa_sample_model->uData('t_qa', $data, $idqa);
		$this->session->set_flashdata('message_ok', 'Data has been approved');
		redirect('qa_sample/qaSample/viewListApproval');
	}

	public function doApproveRetesting($idqa)
	{
		$data = array(
					'status_approval_qc' => '1',
					'appby' => $this->session->userdata('uid'),
					'apptime' => date('Y-m-d H:i:s')
				);
		$this->qa_sample_model->uDataRetesting('retesting', $data, $idqa);
		$this->session->set_flashdata('message_ok', 'Data has been approved');
		redirect('qa_sample/qaSample/viewListApprovalRetesting');
	}

	public function viewData($idqa)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > QA LAB > LIST SAMPLE QA';

		$data['data'] = $this->qa_sample_model->getDataAnalisis($idqa)->row();
		$this->load->view('qa_sample/view_data', $data);
	}

	public function viewDataRetesting($idqa)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba_analisis);

		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > QA LAB > LIST SAMPLE QA';

		$data['data'] = $this->qa_sample_model->getDataAnalisisRetesting($idqa)->row();
		$this->load->view('qa_sample/view_data_retesting', $data);
	}
}
