<?php 
/*
Fungsi : Controller untuk frame body
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class PrintBA extends CI_Controller {
	
	//Menu ID utk keperluan otorisasi
	var $menu_print_ba = 179;
	
	public function index()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_print_ba);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->reflog_model->viewBeritaAcara($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->reflog_model->countBeritaAcara($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('reflog/printBA/index');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Nomor Polisi', 'Nomor Polisi', 'Nomor Sertifikat', 'Pengirim', 'Tanggal', 'Volume', 'Options');
				
			foreach($berita_acara as $row)
			{

				if($row->pengirim == 'CABANG')
				{
					$pengirim = $this->reflog_model->getNamaCabangFromSJ($row->no_sj);
				} else
				{
					$pengirim = $this->reflog_model->getNamaSupplier($row->id_supp);
				}

				$this->table->add_row($row->id_ba, $row->no_pol, $row->no_pol2, $row->no_sertifikat, $pengirim, date('d-M-Y', strtotime($row->tgl_app_qc)), number_format($row->vol_coll), anchor('reflog/printBA/cetakBA?id_ba='.$row->id_ba,'Cetak BA',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > GEO COLLECT > PRINT BA';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('reflog/printBA/index');
		$this->load->view('ppic_sample/tampil_berita_acara', $data);
	}

	function cetakBA()
	{
		$id_ba = $this->input->get('id_ba');
		$data['berita_acara'] = $this->reflog_model->getBeritaAcaraByIDBA($id_ba)->row();
		$this->load->view('reflog/cetak_ba', $data);
	}
}