<?php 
/*
Fungsi : Controller untuk change user password
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_chg_pwd extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/admin_model', '', TRUE);
	}
	
	//Menu ID utk keperluan otorisasi
	var $menu_user_chg_pwd  = 26;
	
	public function index()
	{	
		$this->user_chg_pwd_form();
	}
	
	/* Display change password form */
	function user_chg_pwd_form()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_user_chg_pwd);
		
		$data['menu_path'] = 'USER TOOLS > CHANGE PASSWORD';
		$data['form_action']= site_url('user/user_chg_pwd/chg_pwd');
		$this->load->view('user/user_chg_pwd_form', $data);
		
	}
	
	/* Change password */
	function chg_pwd()
	{
		/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_pass',
                     'label'   => 'New password',
                     'rules'   => 'required|min_length[6]'
                  ),
               array(
                     'field'   => 'txt_pass2',
                     'label'   => 'Re-type password',
                     'rules'   => 'required|min_length[6]|matches[txt_pass]'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				$pass = array( 	'pass'		=> $this->fungsi->encrypt1($this->input->post('txt_pass')),
								'chby'		=> $this->session->userdata('uid'),
								'chdate' 	=> date( 'Y-m-d'),
								'chtime' 	=> date( 'H:i:s' ),
						);
						
				$this->admin_model->update_user($this->session->userdata('uid'), $pass);
				$this->session->set_flashdata('message_ok', 'Password change, please logout and login again');
				redirect('user/user_chg_pwd');
			}
		else
			{
				$this->user_chg_pwd_form();
			}
	}
	
	
}
?>