<?php
/*
Fungsi : Model untuk modul accounting
*/
class Acc_model extends CI_Model {
	/**
	 * Constructor
	 */
	function Acc_model()
	{
		parent::__construct();
	}
	
/* Insialiasi nama table */

	var $table_m_op			= 'm_op';
	var $table_po			= 't_po';
	var $table_hmirocan     = 'h_miro_cancel';
	var $table_h_pcop_trf     = 'h_pcop_trf';
	var $table_hglcancel     = 'h_gl_cancel';
	var $table_tcpv     = 't_cpv';
	
/*-----------------------CPV MODEL---------------------------*/	
function get_cpv_bynocpvform($nocpvform)
		{
			$this->db->where('nocpvform', $nocpvform);
			return $this->db->get($this->table_tcpv);
		}
/*-----------------------CPV MODEL---------------------------*/	

/*-----------------------G/L Cancel MODEL---------------------------*/	

function add_hglcancel($glcancel)
	{
  		$this->db->insert($this->table_hglcancel,$glcancel);
	}

/*-----------------------G/L Cancel MODEL---------------------------*/	

/*-----------------------PR MODEL---------------------------*/	

function get_pr_byponum($ponum, $year)
{
	
	$this->db->select('m_op.inf');
	$this->db->from('t_po');
	$this->db->join('m_op', 't_po.preq_no = m_op.prnumb');
	$this->db->where('t_po.ebeln',$ponum);
	$this->db->where('t_po.year',$year);
	$query = $this->db->get();
	return $query;
	
}


/*-----------------------PR MODEL---------------------------*/
	
/*-----------------------H PC OP MODEL---------------------------*/
function add_h_pcop($hpcop)
	{
  		$this->db->insert($this->table_h_pcop_trf,$hpcop);
	}

function get_h_pcop_bynocpvform($nocpvform)
	{
		$this->db->where('rlis_ref', $nocpvform);
		$this->db->order_by('adddate', 'DESC'); 
		return $this->db->get($this->table_h_pcop_trf);
	}	
/*-----------------------H PC OP MODEL---------------------------*/

/*-----------------------BPKK MODEL---------------------------*/
//Get PC OP type
function get_pcoptyp_bynocpv($nocpv)
{
	$this->db->select('t_bpkk_header.idpcoprtyp');
			$this->db->from('t_rmb_header');
			$this->db->join('t_rmb_detail', 't_rmb_header.normb = t_rmb_detail.normb AND t_rmb_header.year = t_rmb_detail.year AND t_rmb_header.idcab = t_rmb_detail.idcab');
			$this->db->join('t_bpkk_header', 't_rmb_detail.nobpkk = t_bpkk_header.nobpkk AND t_rmb_detail.year = t_bpkk_header.year AND t_rmb_detail.idcab = t_bpkk_header.idcab');
			$this->db->where('t_rmb_header.nocpvform',$nocpv);
			$query = $this->db->get();
			return $query;
}

function get_bpkk_bynocpv($nocpv)
{
	
	$this->db->select('t_bpkk_detail.uraian,
					  t_bpkk_detail.total_item,
					  t_bpkk_detail.glacc,
					  t_bpkk_detail.itemno,
					  t_bpkk_detail.nobpkk,
					  t_bpkk_detail.year,
					  t_bpkk_detail.idcab,
					  m_gl_opr.`desc`,
					  m_gl_opr.`cashflow`,
					   m_cab.costctr');
			$this->db->from('t_rmb_header');
			
			/* Replace 18.11.2013 *
			$this->db->join('t_rmb_detail', 't_rmb_header.normb = t_rmb_detail.normb');
			$this->db->join('t_bpkk_detail', 't_rmb_detail.nobpkk = t_bpkk_detail.nobpkk');
			*/
			$this->db->join('t_rmb_detail', 't_rmb_header.normb = t_rmb_detail.normb AND t_rmb_detail.idcab = t_rmb_header.idcab AND t_rmb_header.year = t_rmb_detail.year');
			$this->db->join('t_bpkk_detail', 't_rmb_detail.nobpkk = t_bpkk_detail.nobpkk AND t_bpkk_detail.idcab = t_rmb_detail.idcab AND t_rmb_detail.year = t_bpkk_detail.year');
			
			$this->db->join('m_gl_opr', ' t_bpkk_detail.glacc = m_gl_opr.glacc');
			$this->db->join('m_cab', '  t_bpkk_detail.idcab = m_cab.idcab');
			$this->db->where('t_rmb_header.nocpvform',$nocpv);
			$query = $this->db->get();
			return $query;
}
/*-----------------------BPKK MODEL---------------------------*/

/*-----------------------MIRO CANCEL MODEL---------------------------*/
function add_hmirocan($hmirocan)
	{
  		$this->db->insert($this->table_hmirocan,$hmirocan);
	}
/*-----------------------MIRO CANCEL MODEL---------------------------*/

/*-----------------------PO MODEL---------------------------*/	
/*Get list PO for CPV*/
	function get_list_po_cpv($limit, $offset)
		{	
			/*$where = "t_po.miro <> '' AND t_po.nocpvform = ''";*/
			$where = "t_po.nocpvform = ''";
			$this->db->select('*');
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->join('m_top', 'm_top.idtop = t_po.idtop');
			$this->db->where($where);
			$this->db->order_by('t_po.ebeln', 'DESC'); 
			$this->db->order_by('t_po.year', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}
/*Count list PO for CPV*/
	function get_list_po_count_cpv()
		{	
			/*$where = "t_po.miro <> '' AND t_po.nocpvform = ''";*/
			$where = "t_po.nocpvform = ''";
			$this->db->select('*'
							 );
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where($where);
			$query = $this->db->get();
			return $query->num_rows;
		}
				
/*Get list PO for clearing*/
	function get_list_po_clr($limit, $offset)
		{	
			$where = "t_po.miro <> '' AND t_po.clearno = ''";
			$this->db->select('m_cab.cabname,
							  t_po.preq_no,
							  t_po.ebeln,
							  t_po.mblnr,
							  t_po.net_price,
							  t_po.vendor,
							  t_po.quantity,
							  t_po.disc,
							  t_po.tax,
							  t_po.year,
							  t_po.addby,
							  t_po.adddate'
							 );
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where($where);
			$this->db->order_by('t_po.ebeln', 'DESC'); 
			$this->db->order_by('t_po.year', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}
		
/*Count list PO for clearing*/
	function get_list_po_count_clr()
		{	
			$where = "t_po.miro <> '' AND t_po.clearno = ''";
			$this->db->select('m_cab.cabname,
							  t_po.preq_no,
							  t_po.ebeln,
							  t_po.mblnr,
							  t_po.net_price,
							  t_po.vendor,
							  t_po.quantity,
							  t_po.year,
							  t_po.addby,
							  t_po.adddate'
							 );
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where($where);
			$query = $this->db->get();
			return $query->num_rows;
		}

/*Get list PO Pending*/
	function get_list_po($limit, $offset)
		{
			$where = "t_po.mblnr <> 0 and t_po.miro = ''";
			$this->db->select('m_cab.cabname,
							  t_po.preq_no,
							  t_po.ebeln,
							  t_po.mblnr,
							  t_po.net_price,
							  t_po.disc,
							  t_po.tax,
							  t_po.vendor,
							  t_po.quantity,
							  t_po.year,
							  t_po.addby,
							  t_po.adddate'
							 );
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where($where); 
			//$this->db->where('t_po.miro', ''); 
			$this->db->order_by('t_po.ebeln', 'DESC'); 
			$this->db->order_by('t_po.year', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}
		
/*Count list PO Pending*/
	function get_list_po_count()
		{
			$where = "t_po.mblnr <> 0 and t_po.miro = ''";
			$this->db->select('m_cab.cabname,
							  t_po.preq_no,
							  t_po.ebeln,
							  t_po.mblnr,
							  t_po.net_price,
							  t_po.vendor,
							  t_po.quantity,
							  t_po.year,
							  t_po.addby,
							  t_po.adddate'
							 );
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where($where); 
			//$this->db->where('t_po.miro', ''); 
			$query = $this->db->get();
			return $query->num_rows;
		}
		
/*Get PO Detail*/
	function get_po_detail($ebeln, $year)
		{
			$this->db->select('m_cab.cabname,
							  t_po.idcab,
							  t_po.preq_no,
							  t_po.ebeln,
							  t_po.mblnr,
							  t_po.net_price,
							   t_po.disc,
							    t_po.tax,
							  t_po.vendor,
							  t_po.quantity,
							  t_po.year,
							  t_po.addby,
							  t_po.adddate'
							 );
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			//$this->db->where('t_po.miro', ''); 
			$this->db->where('t_po.ebeln', $ebeln);
			$this->db->where('t_po.year', $year);
			$query = $this->db->get();
			return $query;
		}

/*Get PO Detail by No.CPV*/
	function get_po_detail_bycpv($nocpvform)
		{
			$this->db->select('m_cab.cabname,
							  t_po.idcab,
							  t_po.preq_no,
							  t_po.ebeln,
							  t_po.mblnr,
							  t_po.net_price,
							  t_po.vendor,
							  t_po.quantity,
							  t_po.disc,
							  t_po.tax,
							  t_po.year,
							  t_po.addby,
							  t_po.adddate,
							  t_po.miraddby,
							  t_po.miradddate,
							  t_po.miro,
							  '
							  );
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where('t_po.nocpvform', $nocpvform);
			$query = $this->db->get();
			return $query;
		}


	/*Update PO*/
  function update_po($ebeln, $year,$po)
	{	
		$this->db->where('ebeln', $ebeln);
		$this->db->where('year', $year);
		$this->db->update($this->table_po, $po);
  
	}
/*-----------------------PO MODEL---------------------------*/	

}