<?php
/*
Fungsi : Model untuk modul accounting report
*/
class Acc_report_model extends CI_Model {
	/**
	 * Constructor
	 */
	function Acc_model()
	{
		parent::__construct();
	}
	
/* Insialiasi nama table */

	var $table_m_op			= 'm_op';
	var $table_po			= 't_po';
	var $table_hmirocan     = 'h_miro_cancel';
	var $table_h_pcop_trf 	= 'h_pcop_trf';
	var $table_hglcancel 	= 'h_gl_cancel';
	var $table_tcpv     	= 't_cpv';
	var $table_m_cab		= 'm_cab';
	var $table_pc_cab		= 't_pc_cab';
	var $table_bank_bal		= 't_bankbal';
	var $table_pcuo_bal		= 't_pcbal';
	var $table_pcop_bal		= 't_pcbal_op';
	var $table_stock_bal    = 't_stockbal';

/*-----------------------BPKK MODEL---------------------------*/
function get_bpkk_byidcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(postdate, '%Y-%m-%d') between '".$date1."' and '".$date2."' and t_bpkk_header.idcab = '".$idcab."'";
			$this->db->select('t_bpkk_header.addby,
							  t_bpkk_header.postdate,
							  t_bpkk_header.adddate,
							  t_bpkk_header.chby,
							  t_bpkk_header.chdate,
							  t_bpkk_header.nobpkkform,
							  t_bpkk_detail.itemno,
							  t_bpkk_detail.uraian,
							  t_bpkk_detail.total_item,
							  t_bpkk_detail.glacc,
							  m_gl_opr.desc'
							 );
			$this->db->from('t_bpkk_header');
			$this->db->join('t_bpkk_detail', 't_bpkk_header.idcab = t_bpkk_detail.idcab AND t_bpkk_header.nobpkk = t_bpkk_detail.nobpkk AND t_bpkk_header.year = t_bpkk_detail.year');
			$this->db->join('m_gl_opr', 't_bpkk_detail.glacc = m_gl_opr.glacc');
			$this->db->where($where); 
			//$this->db->order_by('t_po.ebeln', 'DESC'); 
			//$this->db->order_by('t_po.year', 'DESC'); 
			$query = $this->db->get();
			return $query;
		}

/*-----------------------BPKK MODEL---------------------------*/

/*-----------------------PO MODEL---------------------------*/
function get_po_byidcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(postdate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->where($where);
			$this->db->where('idcab',$idcab);
			$this->db->order_by('postdate', 'ASC'); 
  			return $this->db->get($this->table_po);
		}
/*-----------------------PO MODEL---------------------------*/

/*-----------------------MIRO HISTORY MODEL---------------------------*/

function get_list_miro($date1, $date2)
		{
			$where = "t_po.mblnr <> 0 and t_po.miro <> '' and DATE_FORMAT(t_po.miradddate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->select('m_cab.cabname,
							  t_po.ebeln,
							  t_po.miro,
							  t_po.miraddby,
							  t_po.miradddate,
							  t_po.net_price,
							  t_po.disc,
							  t_po.tax,
							  t_po.vendor,
							  t_po.quantity,
							  t_po.year,
							  t_po.addby,
							  t_po.adddate'
							 );
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where($where); 
			$this->db->order_by('t_po.ebeln', 'DESC'); 
			$this->db->order_by('t_po.year', 'DESC'); 
			$query = $this->db->get();
			return $query;
		}
/*-----------------------MIRO HISTORY MODEL---------------------------*/
	
/*-----------------------STOCK HISTORY MODEL---------------------------*/	

function get_stock_hist_bydate_idcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(postdate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->where($where);
			$this->db->where('idcab',$idcab);
			$this->db->order_by('postdate', 'ASC'); 
  			return $this->db->get($this->table_stock_bal);
		}

/*-----------------------STOCK HISTORY MODEL---------------------------*/	
	
/*-----------------------PC OP BALANCE MODEL---------------------------*/	

function get_pcop_bal_bydate_idcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(postdate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->where($where);
			$this->db->where('idcab',$idcab);
			$this->db->order_by('postdate', 'ASC'); 
  			return $this->db->get($this->table_pcop_bal);
		}

/*-----------------------PC OP BALANCE MODEL---------------------------*/

/*-----------------------PC UO BALANCE MODEL---------------------------*/	

function get_pcuo_bal_bydate_idcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(postdate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->where($where);
			$this->db->where('idcab',$idcab);
			$this->db->order_by('postdate', 'ASC'); 
  			return $this->db->get($this->table_pcuo_bal);
		}

/*-----------------------PC UO BALANCE MODEL---------------------------*/
	
/*-----------------------BANK BALANCE MODEL---------------------------*/	

function get_bank_bal_bydate_idcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(postdate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->where($where);
			$this->db->where('idcab',$idcab);
			$this->db->order_by('postdate', 'ASC'); 
  			return $this->db->get($this->table_bank_bal);
		}

/*-----------------------BANK BALANCE MODEL---------------------------*/		
	
/*-----------------------CABANG MODEL---------------------------*/	
	function get_cabang()
	{
		$where = "idcab <> '1'";
		$this->db->where($where);
  		return $this->db->get($this->table_m_cab);
	}	
	
	function get_cabang_byidcab($idcab)
	{
		$this->db->where('idcab',$idcab);
  		return $this->db->get($this->table_m_cab);
	}	
/*-----------------------CABANG MODEL---------------------------*/	

/*-----------------------CPV CABANG G/L REPORT MODEL---------------------------*/	
function get_cpv_cab_bydate($date1, $date2)
		{
			$where = "DATE_FORMAT(t_pc_cab.adddate, '%Y-%m-%d') between '".$date1."' and '".$date2."' and t_pc_cab.accglno <> ''";
			$this->db->select('m_cab.cabname,
							   m_cab.idcab,
							   t_pc_cab.nopc,
							   t_pc_cab.nopcform,
							  t_pc_cab.amount,
							  t_pc_cab.desc,
							  t_pc_cab.addby,
							  t_pc_cab.adddate,
							  t_pc_cab.accglno,
							  t_pc_cab.pctyp,
							  m_pc_typ.`desc` as desc2');
			$this->db->from('t_pc_cab');
			$this->db->join('m_cab', 'm_cab.idcab = t_pc_cab.idcab');
			$this->db->join('m_pc_typ', 't_pc_cab.pctyp = m_pc_typ.idpctyp');
			$this->db->where($where);
			$this->db->order_by('t_pc_cab.adddate', 'ASC'); 
			$query = $this->db->get();
			return $query;
		}
/*-----------------------CPV CABANG G/L REPORT MODEL---------------------------*/	

/*-----------------------CPV PUSAT G/L REPORT MODEL---------------------------*/	
function get_cpv_pusat_bydate($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(t_cpv.accglpostdate, '%Y-%m-%d') between '".$date1."' and '".$date2."' AND t_cpv.idcab = '".$idcab."'";
			$this->db->select('m_cab.cabname,
							   m_cab.idcab,
							  t_cpv.nocpv,
							  t_cpv.nocpdu,
							  t_cpv.nocpvform,
							  t_cpv.miro,
							  t_cpv.amount_trf,
							  t_cpv.amount_req,
							  t_cpv.`desc`,
							  t_cpv.status,
							  t_cpv.pctyp,
							  t_cpv.year,
							  t_cpv.accglpost,
							  t_cpv.accglpostby,
							  t_cpv.accglpostdate,
							  t_cpv.accglno,
							  t_cpv.pctrans,
							  m_pc_typ.`desc` as desc2,
							  m_pc_trans.`desc` as desc3');
			$this->db->from('t_cpv');
			$this->db->join('m_cab', 'm_cab.idcab = t_cpv.idcab');
			$this->db->join('m_pc_typ', 't_cpv.pctyp = m_pc_typ.idpctyp');
			$this->db->join('m_pc_trans', 't_cpv.pctrans = m_pc_trans.idpctrans');
			$this->db->where('t_cpv.accglpost', 1);
			$this->db->where($where);
			$this->db->order_by('t_cpv.accglpostdate', 'ASC'); 
			$query = $this->db->get();
			return $query;
		}
/*-----------------------CPV PUSAT G/L REPORT MODEL---------------------------*/	


}