<?php
/*
Fungsi : Model untuk modul admin
*/
class Admin_model extends CI_Model {
	/**
	 * Constructor
	 */
	function Admin_model()
	{
		parent::__construct();
	}
	
/* Insialiasi nama table */

	var $table_menu			= 'master_menu';
	var $table_role 		= 'master_role';
	var $table_role_menu 	= 'role_menu';
	var $table_user 		= 'master_user';
	var $table_cabang		= 'm_cab';
	var $table_type		    = 'm_supptype';
	var $table_suppgrp		= 'm_suppgrp';
	var $table_notgrp		= 'm_notgrp';
	var $table_notgrp_member = 'notgrp_member';
	var $table_counter = 't_count';
	
/*-----------------------COUNTER MODEL---------------------------*/

//update counter
function update_count($idcab,$count)
	{
		$this->db->where('idcab', $idcab);
		$this->db->where('year', date('Y'));
		$this->db->update($this->table_counter, $count);
	}
//Get last number
function get_lastnum_count($idcab)
	{
		$this->db->where('idcab', $idcab);
		$this->db->where('year', date('Y'));
		return $this->db->get($this->table_counter);
	}
/*-----------------------COUNTER MODEL---------------------------*/			

/*-----------------------NOTIFICATION GROUP MODEL---------------------------*/	
/* Insert notification group */
   function add_notgrp($notgrp)
		{
			$this->db->insert($this->table_notgrp, $notgrp);
		}

/* List not group paging */
	function get_notgrp_paging($limit, $offset)
	{
  		$this->db->get($this->table_notgrp);
		$this->db->order_by('idnotgrp','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_notgrp);
	}
	
	/* Total not group */
	function count_all_notgrp()
	{
		$this->db->get($this->table_notgrp);
		return $this->db->count_all_results($this->table_notgrp);
	}
	
	/* Get data not group detail*/
	function get_notgrp_detail($idnotgrp)
	{
		$this->db->where('idnotgrp', $idnotgrp);
		return $this->db->get($this->table_notgrp);
	}
	
	/* Get data not group */
	function update_notgrp($idnotgrp, $desc)
	{
		$this->db->where('idnotgrp', $idnotgrp);
		$this->db->update($this->table_notgrp, $desc);
	}

	/* Get data user list */
	function get_usrnotgrp()
	{
		$this->db->get($this->table_user);
		return $this->db->get($this->table_user);
	}
	
	/* Insert member group batch */
   function add_grpmem_batch($grpmem)
		{
			$this->db->insert_batch($this->table_notgrp_member, $grpmem); 
		}
	/* Get member group by group ID*/
	function get_grpmem_bygid($idnotgrp)
	{
		$this->db->where('idnotgrp', $idnotgrp);
		return $this->db->get($this->table_notgrp_member);
	}
	
	/* Delete member group */
	function del_memgrp($idnotgrp)
	{
		$this->db->where('idnotgrp', $idnotgrp);
		$this->db->delete($this->table_notgrp_member);
		
	}
	/* Delete not group */
	function del_notgrp($idnotgrp)
	{	
		//Delete not group
		$this->db->where('idnotgrp', $idnotgrp);
		$this->db->delete($this->table_notgrp);
		//Delete group member
		$this->db->where('idnotgrp', $idnotgrp);
		$this->db->delete($this->table_notgrp_member);
		
	}		
	
	/* Get user by not group ID */
	function get_user_notgrp_bynotid($idnotgrp)
		{
			$this->db->select('*');
			$this->db->from('master_user');
			$this->db->join('notgrp_member', 'notgrp_member.notgrp_uid = master_user.uid');
			$this->db->where('notgrp_member.idnotgrp ', $idnotgrp);
			$query = $this->db->get();
			return $query;
		}
/*-----------------------NOTIFICATION GROUP MODEL---------------------------*/	





/*-----------------------SUPPLIER GROUP MODEL---------------------------*/	
	
	/* Insert supplier group */
   function add_suppgrp($suppgrp)
		{
			$this->db->insert($this->table_suppgrp, $suppgrp);
		}
		
/* List supplier group paging */
	function get_suppgrp_paging($limit, $offset)
	{
  		$this->db->get($this->table_suppgrp);
		$this->db->order_by('idgroup','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_suppgrp);
	}
	
	/* Total supplier group */
	function count_all_suppgrp()
	{
		$this->db->get($this->table_suppgrp);
		return $this->db->count_all_results($this->table_suppgrp);
	}
	
	/* Delete supplier group */
	function del_suppgrp($idgroup)
	{
		$this->db->where('idgroup', $idgroup);
		$this->db->delete($this->table_suppgrp);
		
	}
	
	/* Get data supplier group detail*/
	function get_suppgrp_detail($idgroup)
	{
		$this->db->where('idgroup', $idgroup);
		return $this->db->get($this->table_suppgrp);
	}
	
	/* Update data supplier group */
	function update_suppgrp($idgroup, $desc)
	{
		$this->db->where('idgroup',$idgroup);
		$this->db->update($this->table_suppgrp, $desc);
	}
/*-----------------------SUPPLIER GROUP MODEL---------------------------*/	

/*-----------------------CABANG MODEL---------------------------*/	
	/* Insert cabang */
   function add_cabang($cabang)
		{
			$this->db->insert($this->table_cabang, $cabang);
		}
		
	/* Search ID Cabang */
	function search_idcab($idcab)
	{
		$this->db->where('idcab', $idcab);
		return $this->db->get($this->table_cabang);
	}
	
	/* List cabang paging */
	function get_cabang_paging($limit, $offset)
	{
  		$this->db->get($this->table_cabang);
		$this->db->order_by('idcab','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_cabang);
	}
	
	/* Total data cabang */
	function count_all_cabang()
	{
		$this->db->get($this->table_cabang);
		return $this->db->count_all_results($this->table_cabang);
	}
	
	/* Get data cabang detail*/
	function get_cab_detail($idcab)
	{
		$this->db->where('idcab', $idcab);
		return $this->db->get($this->table_cabang);
	}
	
	/* Update data cabang */
	function update_cab($idcab, $cab)
	{
		$this->db->where('idcab',$idcab);
		$this->db->update($this->table_cabang,  $cab);
	}
	
	/*Get list cabang aktif*/
  function get_cabang_list()
	{
  		$sql_cabang =  $this->db->get_where($this->table_cabang, array('active' => 1));
  		return $sql_cabang;
	}
	
/*-----------------------CABANG MODEL---------------------------*/	
/*-----------------------Type MODEL---------------------------*/
/*Get list supplier type*/
  function get_type_list()
	{
  		$sql_type =  $this->db->get_where($this->table_type, array('active' => 1));
  		return $sql_type;
	}
/*-----------------------type MODEL---------------------------*/

/*-----------------------MENU MODEL---------------------------*/	
	/* Insert menu */
   function add_menu($menu)
		{
			$this->db->insert($this->table_menu, $menu);
		}
		
   /* Get menu */
   function get_menu()
		{
			$this->db->where('pid', '0');
			$this->db->order_by('mid','pid','ASC');
			return $this->db->get($this->table_menu);
		}
		
  /* Get menu paging */
  function get_menu_paging($limit, $offset, $search)
	{	
		if(!empty($search)) {
  		$this->db->like('mname',$search);
		$this->db->or_like('murl',$search);
		}
		$this->db->order_by('mid','pid','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_menu);
	}

	/* Get menu total rows */
	function count_rows_menu($search)
	{	
		if(!empty($search)) {
  		$this->db->like('mname',$search);
		$this->db->or_like('murl',$search);
		}
		return $this->db->count_all_results($this->table_menu);
	}
	
	/* Delete menu */
	function del_menu($mid)
	{
		$this->db->where('mid', $mid);
		$this->db->delete($this->table_menu);
		
	}
	
	/* Get menu by mid */
	function get_menu_mid($mid)
	{
		$this->db->where('mid', $mid);
		return $this->db->get($this->table_menu);
	}
	
	/* Update menu */
	function update_menu($mid, $menu)
	{
		$this->db->where('mid',$mid);
		$this->db->update($this->table_menu,  $menu);
	}
	
	/* Get all menu */
	function get_menu_all()
	{
		$this->db->order_by('mid','pid','ASC');
		return $this->db->get($this->table_menu);
		
	}
/*-----------------------MENU MODEL---------------------------*/	

/*-----------------------ROLE MODEL---------------------------*/

	/* Insert role */
   function add_role($role)
		{
			$this->db->insert($this->table_role, $role);
		}
		
	/* Get last roleid
   function get_last_roleid()
		{
			$query = $this->db->query(" SHOW TABLE STATUS LIKE 'master_role' ");
			return $query;
		} */
		
	/* Insert role menu batch */
   function add_rolemenu_batch($role_menu)
		{
			$this->db->insert_batch($this->table_role_menu, $role_menu); 
		}
		
	/* Get role paging */
  function get_role_paging($limit, $offset, $search)
	{	
		$this->db->where('rolename !=', 'ADMIN');
		if(!empty($search)) {
			$this->db->like('rolename',$search);
			$this->db->or_like('roledesc',$search);
			}
		$this->db->order_by('roleid','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_role);
	}

	/* Get menu total rows */
	function count_rows_role($search)
	{	
		if(!empty($search)) {
			$this->db->like('rolename',$search);
			$this->db->or_like('roledesc',$search);
			}
		return $this->db->count_all_results($this->table_role);
	}
	
	/* Delete role */
	function del_role($roleid)
	{
		$this->db->where('roleid', $roleid);
		$this->db->delete($this->table_role);
		
	}
	
	/* Get role by roleid */
	function get_role_roleid($roleid)
	{
		$this->db->where('roleid', $roleid);
		return $this->db->get($this->table_role);
	}
	
	/* Get role menu by roleid */
	function get_rolemenu_roleid($roleid)
	{
		$this->db->where('roleid', $roleid);
		return $this->db->get($this->table_role_menu);
	}
	
	/* Update role */
	function update_role($roleid, $role)
	{
		$this->db->where('roleid',$roleid);
		$this->db->update($this->table_role, $role);
	}
	
	/* Delete role menu */
	function del_role_menu($roleid)
	{
		$this->db->where('roleid', $roleid);
		$this->db->delete($this->table_role_menu);
		
	}
	
	/* Search role name */
	function search_rolename($rolename)
	{
		$this->db->like('rolename', $rolename); 
		return $this->db->get($this->table_role);
	}
	
	/* Get role list */
  function get_role_list()
	{
  		$query = $this->db->get($this->table_role);
  		return $query;
	}
	
	/* Get last role */
	
	function get_last_role()
	{
		$this->db->select_max('roleid');
		$query = $this->db->get($this->table_role);
		return $query;	
	}
		
/*-----------------------ROLE MODEL---------------------------*/	

/*-----------------------USER MODEL---------------------------*/	

	/* Search role name */
	function search_username($username)
	{
		$this->db->like('uid', $username); 
		return $this->db->get($this->table_user);
	}
	
	/* Add user */
	 function add_user($user)
		{
			$this->db->insert($this->table_user, $user);
		}
		
	/* Get user paging */
  	function get_user_paging($limit, $offset, $search)
		{	
			$this->db->select('*');
			$this->db->from('master_user');
			$this->db->join('master_role', 'master_role.roleid = master_user.roleid');
			if(!empty($search)) {
			$this->db->like('master_user.uid',$search);
			$this->db->or_like('master_user.dispname',$search);
			$this->db->or_like('master_user.email',$search);
			$this->db->or_like('master_role.rolename',$search);
			}
			$this->db->order_by('master_user.uid','ASC');
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			
			return $query ;
		}

	/* Get user total rows */
	function count_rows_user($search)
		{
			$this->db->select('*');
			$this->db->from('master_user');
			$this->db->join('master_role', 'master_role.roleid = master_user.roleid');
			if(!empty($search)) {
			$this->db->like('master_user.uid',$search);
			$this->db->or_like('master_user.dispname',$search);
			$this->db->or_like('master_user.email',$search);
			$this->db->or_like('master_role.rolename',$search);
			}
			$query = $this->db->get();
			return $query->num_rows;
		}
		
	/* Delete user */
	function del_user($uid)
	{
		$this->db->where('uid', $uid);
		$this->db->delete($this->table_user);
		
	}
	
	/* Get user by uid */
	function get_user_uid($uid)
	{
		$this->db->where('uid', $uid);
		return $this->db->get($this->table_user);
	}
	
	/* Update user */
	function update_user($uid, $user)
	{
		$this->db->where('uid',$uid);
		$this->db->update($this->table_user, $user);
	}
	
	/* Get user by idcab */
	function get_user_idcab($idcab)
	{
		$this->db->where('idcab', $idcab);
		return $this->db->get($this->table_user);
	}
/*-----------------------USER MODEL---------------------------*/	

}