<?php
/*
Fungsi : Model untuk modul branch
*/
class Branch_model extends CI_Model {
	/**
	 * Constructor
	 */
	function Branch_model()
	{
		parent::__construct();
	}
	
/* Insialiasi nama table */

	var $table_pc_cab			= 't_pc_cab';
	var $table_pcbal			= 't_pcbal';
	var $table_pr			    = 't_pr';
	var $table_stb			    = 't_stb';
	var $table_po			    = 't_po';
	var $table_stock			= 't_stockbal';
	var $table_pcbal_op         = 't_pcbal_op';
	
	var $table_gl_op        	   = 'm_gl_opr';
	var $table_bpkk_header         = 't_bpkk_header';
	var $table_bpkk_detail         = 't_bpkk_detail';
	
	var $table_rmb_header         = 't_rmb_header';
	var $table_rmb_detail         = 't_rmb_detail';
	
	var $table_hmigocan     = 'h_migo_cancel';
	
	var $table_pcoprtyp     = 'm_pc_opr_typ';
	
/*-----------------------PC OPR TYP MODEL---------------------------*/
/* Get List pc opr typ */
 function get_pc_opr_typ()
	{
		return $this->db->get($this->table_pcoprtyp);
	}	
/* Get List pc opr typ by ID */
 function get_pc_opr_typ_byid($idpcoprtyp)
	{
		$this->db->where('idpcoprtyp', $idpcoprtyp);
		return $this->db->get($this->table_pcoprtyp);
	}	
/*-----------------------PC OPR TYP MODEL---------------------------*/
/*-----------------------H MIGO CANCEL MODEL---------------------------*/
function add_h_migocan($migo)
	{
  		$this->db->insert($this->table_hmigocan,$migo);
	}
/*------------------------H MIGO CANCEL MODEL---------------------------*/

/*-------------RMB MODEL---------------------*/	

/*Get RMH Header by ID Cab, No. RMB & Year*/
 function get_rmbheader_byidcabnoyear($idcab, $normb, $year)
	{
  		$this->db->where('idcab', $idcab);
		$this->db->where('normb', $normb);
		$this->db->where('year', $year);
		return $this->db->get($this->table_rmb_header);
	}
	
/* Get List RMB */
function get_rmb_header_pending($idcab, $limit, $offset)
{
	$this->db->select('m_cab.cabname,
								t_rmb_header.idcab,
								t_rmb_header.normb,
								t_rmb_header.normbform,
								t_rmb_header.total,
								t_rmb_header.addby,
								t_rmb_header.adddate,
								t_rmb_header.year');
			$this->db->from('t_rmb_header');
			$this->db->join('m_cab', 'm_cab.idcab = t_rmb_header.idcab');
			$this->db->where('t_rmb_header.status', 0); 
			$this->db->where('t_rmb_header.idcab', $idcab);
			$this->db->order_by('t_rmb_header.normb', 'DESC'); 
			$this->db->order_by('t_rmb_header.year', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
}
/* Get List RMB Count */
function get_rmb_header_pending_count()
		{
			$this->db->select('*');
			$this->db->from('t_rmb_header');
			$this->db->join('m_cab', 'm_cab.idcab = t_rmb_header.idcab');
			$this->db->where('t_rmb_header.status', 0); 
			$query = $this->db->get();
			return $query;
		}
/* Add RMB Header */
function add_rmb_header($rmbheader)
	{
  		$this->db->insert($this->table_rmb_header,$rmbheader);
	}
/* Add RMB Detail */
function add_rmb_detail($rmbdetail)
	{
  		$this->db->insert_batch($this->table_rmb_detail,$rmbdetail);
	}
/*Update RMB Header*/
 function update_rmbheader($idcab, $normb, $year, $header)
	{
  		$this->db->where('idcab', $idcab);
		$this->db->where('normb', $normb);
		$this->db->where('year', $year);
		$this->db->update($this->table_rmb_header, $header);
	}
/*-------------RMB MODEL---------------------*/	

/*-------------BPKK MODEL---------------------*/	

/* Get List G/L Account */
 function get_list_gl()
	{
		return $this->db->get($this->table_gl_op);
	}	
/* Get List G/L Account By G/L No */
function get_list_gl_byglacc($glacc)
	{
		$this->db->where('glacc', $glacc);
		return $this->db->get($this->table_gl_op);
	}
/* Add BPKK Header */
function add_bpkk_header($bpkkheader)
	{
  		$this->db->insert($this->table_bpkk_header,$bpkkheader);
	}
/* Add BPKK Detail */
function add_bpkk_detail($bpkkdetail)
	{
  		$this->db->insert_batch($this->table_bpkk_detail,$bpkkdetail);
	}

/*Get list BPKK*/
	function get_list_bpkk($idcab,$limit, $offset)
		{
			$this->db->select('m_cab.cabname,
								t_bpkk_header.idcab,
								t_bpkk_header.nobpkk,
								t_bpkk_header.nobpkkform,
								t_bpkk_header.idpcoprtyp,
								t_bpkk_header.total,
								t_bpkk_header.addby,
								t_bpkk_header.adddate,
								t_bpkk_header.year,
								t_bpkk_header.idpcoprtyp,
								m_pc_opr_typ.desc');
			$this->db->from('t_bpkk_header');
			$this->db->join('m_cab', 'm_cab.idcab = t_bpkk_header.idcab');
			$this->db->join('m_pc_opr_typ', 'm_pc_opr_typ.idpcoprtyp = t_bpkk_header.idpcoprtyp');
			$this->db->where('t_bpkk_header.idcab', $idcab); 
			$this->db->where('t_bpkk_header.status', 0); 
			$this->db->order_by('t_bpkk_header.nobpkk', 'DESC'); 
			$this->db->order_by('t_bpkk_header.year', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}
		/*Get list PO*/
	/*function get_list_po($idcab,$limit, $offset)
		{
			$this->db->select('m_cab.cabname,
								t_bpkk_header.idcab,
								t_bpkk_header.nobpkk,
								t_bpkk_header.nobpkkform,
								t_bpkk_header.idpcoprtyp,
								t_bpkk_header.total,
								t_bpkk_header.addby,
								t_bpkk_header.adddate,
								t_bpkk_header.year,
								t_bpkk_header.idpcoprtyp,
								m_pc_opr_typ.desc');
			$this->db->from('t_bpkk_header');
			$this->db->join('m_cab', 'm_cab.idcab = t_bpkk_header.idcab');
			$this->db->join('m_pc_opr_typ', 'm_pc_opr_typ.idpcoprtyp = t_bpkk_header.idpcoprtyp');
			$this->db->where('t_bpkk_header.idcab', $idcab); 
			$this->db->where('t_bpkk_header.status', 0); 
			$this->db->order_by('t_bpkk_header.nobpkk', 'DESC'); 
			$this->db->order_by('t_bpkk_header.year', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}*/
		
		
/*Get Count list BPKK*/
	function get_list_bpkk_count($idcab)
		{
			$this->db->select('*');
			$this->db->from('t_bpkk_header');
			$this->db->join('m_cab', 'm_cab.idcab = t_bpkk_header.idcab');
			$this->db->where('t_bpkk_header.idcab', $idcab); 
			$this->db->where('t_bpkk_header.status', 0); 
			$this->db->order_by('t_bpkk_header.nobpkk', 'DESC'); 
			$this->db->order_by('t_bpkk_header.year', 'DESC'); 
			$query = $this->db->get();
			return $query;
		}

/*Get list BPKK 2*/
	function get_list_bpkk2($idcab,$limit, $offset)
		{
			$this->db->select('m_cab.cabname,
								t_bpkk_header.idcab,
								t_bpkk_header.nobpkk,
								t_bpkk_header.nobpkkform,
								t_bpkk_header.idpcoprtyp,
								t_bpkk_header.total,
								t_bpkk_header.addby,
								t_bpkk_header.adddate,
								t_bpkk_header.year,
								t_bpkk_header.idpcoprtyp,
								m_pc_opr_typ.desc');
			$this->db->from('t_bpkk_header');
			$this->db->join('m_cab', 'm_cab.idcab = t_bpkk_header.idcab');
			$this->db->join('m_pc_opr_typ', 'm_pc_opr_typ.idpcoprtyp = t_bpkk_header.idpcoprtyp');
			$this->db->where('t_bpkk_header.idcab', $idcab); 
			$this->db->where('t_bpkk_header.status !=', 1); 
			//$this->db->order_by('t_bpkk_header.nobpkk', 'DESC'); 
			//$this->db->order_by('t_bpkk_header.year', 'DESC'); 
			$this->db->order_by('t_bpkk_header.adddate', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}
/*Get Count list BPKK 2*/
	function get_list_bpkk_count2($idcab)
		{
			$this->db->select('*');
			$this->db->from('t_bpkk_header');
			$this->db->join('m_cab', 'm_cab.idcab = t_bpkk_header.idcab');
			$this->db->where('t_bpkk_header.idcab', $idcab); 
			$this->db->where('t_bpkk_header.status !=',1); 
			$this->db->order_by('t_bpkk_header.nobpkk', 'DESC'); 
			$this->db->order_by('t_bpkk_header.year', 'DESC'); 
			$query = $this->db->get();
			return $query;
		}
		
/*Get BPKK by ID Cab, No. BPKK & Year*/
 function get_bpkkheader_byidcabnoyear($idcab, $nobpkk, $year)
	{
  		$this->db->where('idcab', $idcab);
		$this->db->where('nobpkk', $nobpkk);
		$this->db->where('year', $year);
		return $this->db->get($this->table_bpkk_header);
	}
	
/*Get BPKK by ID Cab, No. BPKK & Year*/
 function get_bpkkdetail_byidcabnoyear($idcab, $nobpkk, $year)
	{
  		$this->db->where('idcab', $idcab);
		$this->db->where('nobpkk', $nobpkk);
		$this->db->where('year', $year);
		return $this->db->get($this->table_bpkk_detail);
	}	

/*Get Count list BPKK Join G/L Acc*/
	function get_bpkkdetail_byidcabnoyear_glacc($idcab, $nobpkk, $year)
		{
			$this->db->select('*');
			$this->db->from('t_bpkk_detail');
			$this->db->join('m_gl_opr', 'm_gl_opr.glacc = t_bpkk_detail.glacc');
			$this->db->where('t_bpkk_detail.idcab', $idcab); 
			$this->db->where('t_bpkk_detail.nobpkk', $nobpkk);
			$this->db->where('t_bpkk_detail.year', $year);
			$query = $this->db->get();
			return $query;
		}
/*Get BPKK by ID Cab, No. BPKK & Year & Item*/
 function get_bpkkdetail_byidcabnoyearno($idcab, $nobpkk, $year, $itemno)
	{
  		$this->db->where('idcab', $idcab);
		$this->db->where('nobpkk', $nobpkk);
		$this->db->where('year', $year);
		$this->db->where('itemno', $itemno);
		return $this->db->get($this->table_bpkk_detail);
	}	
	
/*Update BPKK Detail*/
 function update_bpkkdetail($idcab, $nobpkk, $year, $itemno, $detail)
	{
  		$this->db->where('idcab', $idcab);
		$this->db->where('nobpkk', $nobpkk);
		$this->db->where('year', $year);
		$this->db->where('itemno', $itemno);
		$this->db->update($this->table_bpkk_detail, $detail);
	}
/*Update BPKK Header*/
 function update_bpkkheader($idcab, $nobpkk, $year, $header)
	{
  		$this->db->where('idcab', $idcab);
		$this->db->where('nobpkk', $nobpkk);
		$this->db->where('year', $year);
		$this->db->update($this->table_bpkk_header, $header);
	}	
/*-------------BPKK MODEL---------------------*/
/*-------------STOCK MODEL---------------------*/	
function add_stock($stock)
	{
  		$this->db->insert($this->table_stock,$stock);
	}
/*-------------STOCK MODEL---------------------*/	

/*-------------PO MODEL---------------------*/	
/*Get PO by PR NO*/
 function get_po_byprno($pr, $year)
	{
  		$this->db->where('preq_no', $pr);
		$this->db->where('year', $year);
		return $this->db->get($this->table_po);
	}		
/*Add PO*/
/*Get list PO*/
	function get_list_po2($idcab,$limit, $offset)
		{
			$this->db->select('m_cab.cabname,
								t_po.ebeln,
								t_po.idcab,
								t_po.net_price,
								t_po.disc,
								t_po.tax,
								t_po.quantity,
								t_po.addby,
								t_po.adddate,
								t_po.year');
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where('t_po.idcab', $idcab); 
			$this->db->order_by('t_po.ebeln', 'DESC'); 
			$this->db->order_by('t_po.year', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}
/*Get list PO count*/
function get_list_po_count($idcab)
		{
			$this->db->select('*');
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where('t_po.idcab', $idcab);
			$query = $this->db->get();
			return $query->num_rows;
		}
/*Get PO by No. PO & Year*/
 function get_po_bynoyear($ebeln, $year)
	{
  		$this->db->where('ebeln', $ebeln);
		$this->db->where('year', $year);
		return $this->db->get($this->table_po);
	}	
/*Get PO by MIRO & Year*/
 function get_po_bymiroyear($miro, $year)
	{
  		$this->db->where('miro', $miro);
		$this->db->where('year', $year);
		return $this->db->get($this->table_po);
	}	
/*Get PO by CPV*/
 function get_po_bycpv($nocpvform)
	{
  		$this->db->where('nocpvform', $nocpvform);
		return $this->db->get($this->table_po);
	}		
/*Get PO by No. PO & Year & ID CAB*/
 function get_po_bynoyearidcab($ebeln, $year, $idcab)
	{
  		$this->db->where('ebeln', $ebeln);
		$this->db->where('year', $year);
		//$this->db->where('idcab', $idcab);
		return $this->db->get($this->table_po);
	}
/*Update PO*/
  function update_po($ebeln, $year,$po)
	{	
		$this->db->where('ebeln', $ebeln);
		$this->db->where('year', $year);
		$this->db->update($this->table_po, $po);
	}		
  function add_po($po)
	{
  		$this->db->insert($this->table_po,$po);
	}		
/*-------------PR MODEL---------------------*/

/*Get PR by No. PR & Year*/
 function get_pr_bynoyear($preq_no, $year)
	{
  		$this->db->where('preq_no', $preq_no);
		$this->db->where('year', $year);
		return $this->db->get($this->table_pr);
	}	
			
	/*Add PR*/
  function add_pr($pr)
	{
  		$this->db->insert($this->table_pr,$pr);
	}
	
	/*Update PR*/
  function update_pr($preq_no, $year,$pr)
	{	
		$this->db->where('preq_no', $preq_no);
		$this->db->where('year', $year);
		$this->db->update($this->table_pr, $pr);
  
	}
	
	/*Get list PR*/
	function get_list_pr($idcab,$limit, $offset, $closed)
		{
			$this->db->select('m_cab.cabname,
							  t_pr.preq_no,
							  t_pr.c_amt_bapi,
							  t_pr.quantity,
							  t_pr.year,
							  t_pr.closed,
							  t_pr.addby,
							  t_pr.adddate'
							 );
			$this->db->from('t_pr');
			$this->db->join('m_cab', 'm_cab.idcab = t_pr.idcab');
			$this->db->where('t_pr.idcab', $idcab); 
			$this->db->where('t_pr.closed', $closed); 
			$this->db->order_by('t_pr.preq_no', 'DESC'); 
			$this->db->order_by('t_pr.year', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}
		
		
/*Get list PR count*/
function get_list_pr_count($idcab,$closed)
		{
			$this->db->select('m_cab.cabname,
							  t_pr.preq_no,
							  t_pr.c_amt_bapi,
							  t_pr.quantity,
							  t_pr.year,
							  t_pr.closed,
							  t_pr.addby,
							  t_pr.adddate'
							 );
			$this->db->from('t_pr');
			$this->db->join('m_cab', 'm_cab.idcab = t_pr.idcab');
			$this->db->where('t_pr.idcab', $idcab); 
			$this->db->where('t_pr.closed', $closed); 
			$query = $this->db->get();
			return $query->num_rows;
		}
//Cari Data KREDIT CABANG
	function search_pr_credit($limit, $offset, $cari)
	{  	
		$this->db->select('preq_no, c_amt_bapi, quantity, closed, year');
		
		$this->db->order_by('preq_no','ASC');
		$this->db->where('closed', 0);
		$this->db->where('t_pr.idtop', 1);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_pr);
	}
//CARI DATA KREDIT PUSAT	
	function search_pr_credit_pusat($limit, $offset, $cari)
	{  	
		$this->db->select('preq_no, c_amt_bapi, quantity, closed, year');
		
		$this->db->order_by('preq_no','ASC');
		$this->db->where('closed', 0);
		$this->db->where('t_pr.idtop', 2);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_pr);
	}
	
	function search_pr($limit, $offset, $cari)
	{  	
		$this->db->select('preq_no, c_amt_bapi, quantity, closed, year');
		
		$this->db->order_by('preq_no','ASC');
		$this->db->where('closed', 0);
		$this->db->where('t_pr.idtop', 0);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_pr);
	}
/*Hitung Hasil Cari*/
	function count_all_pr($cari)
	{
		$this->db->select('preq_no, c_amt_bapi, quantity, closed, year');
		
		$this->db->order_by('preq_no','ASC');
		return $this->db->count_all_results($this->table_pr);
	}	

/*-------------PR MODEL---------------------*/	

/*-------------STB MODEL---------------------*/		
/*Get list stb count*/
function get_list_stb_count($idcab,$closed)
		{
			$this->db->select('m_cab.cabname,
							  t_stb.idstb,
							  t_stb.type,
							  t_stb.vol,
							  t_stb.year,
							  t_stb.closed,
							  t_stb.addby,
							  t_stb.adddate'
							 );
			$this->db->from('t_stb');
			$this->db->join('m_cab', 'm_cab.idcab = t_stb.idcab');
			$this->db->where('t_stb.idcab', $idcab); 
			$this->db->where('t_stb.closed', $closed); 
			$query = $this->db->get();
			return $query->num_rows;
		}
/*Cari Data*/
	function search_stb($limit, $offset, $cari)
	{  	
		$this->db->select('idstb, type, donumb, mnfst, vol, idsupp, suppname, idtrans, transname, vnumb, year');
		
		$this->db->order_by('idstb','ASC');
		$this->db->where('closed', 0);
		$this->db->where('idtop', 0);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_stb);
	}
	
	function search_stb_credit($limit, $offset, $cari)
	{  	
		$this->db->select('t_stb.idstb, t_stb.type, t_stb.donumb, t_stb.mnfst, t_stb.vol, t_stb.idsupp, t_stb.suppname, t_stb.idtrans, t_stb.transname, t_stb.vnumb, t_stb.year, m_supp.codevendor');
		$this->db->from('t_stb');
		$this->db->join('m_supp', 'm_supp.idsupp = t_stb.idsupp');
		$this->db->order_by('t_stb.idstb','ASC');
		$this->db->where('t_stb.closed', 0);
		$this->db->where('t_stb.idtop', 1);
		$this->db->where('t_stb.idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		$query = $this->db->get();
	    return $query;
	}
	
/*Get list stb count*/
function get_list_stb_credit_count()
		{
			$this->db->select('t_stb.idstb, t_stb.type, t_stb.donumb, t_stb.mnfst, t_stb.vol, t_stb.idsupp, t_stb.suppname, t_stb.idtrans, t_stb.transname, t_stb.vnumb, t_stb.year, m_supp.codevendor');
		$this->db->from('t_stb');
		$this->db->join('m_supp', 'm_supp.idsupp = t_stb.idsupp');
		$this->db->order_by('t_stb.idstb','ASC');
		$this->db->where('t_stb.closed', 0);
		$this->db->where('t_stb.idtop', 1);
		$this->db->where('t_stb.idcab', $this->session->userdata('idcab'));
			$query = $this->db->get();
			return $query->num_rows;
		}
			
//STB CREDIT PUSAT	
	function search_stb_credit_pusat($limit, $offset, $cari)
	{  	
		$this->db->select('idstb, type, donumb, mnfst, vol, idsupp, suppname, idtrans, transname, vnumb, year');
		
		$this->db->order_by('idstb','ASC');
		$this->db->where('closed', 0);
		$this->db->where('idtop', 2);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_stb);
	}
	
/*Hitung Hasil Cari*/
	function count_all_stb($cari)
	{
		$this->db->select('idstb, vol, closed, year');
		
		$this->db->order_by('idstb','ASC');
		$this->db->where('closed', 0);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		return $this->db->count_all_results($this->table_stb);
	}		
/*-------------STB MODEL---------------------*/	
	
/*-------------PETTY CASH / CPV MODEL---------------------*/	

/*Get PC by No. PR & Year*/
 function get_pc_bynoyear($nopc, $year, $idcab)
	{
  		$this->db->where('nopc', $nopc);
		$this->db->where('year', $year);
		$this->db->where('idcab', $idcab);
		return $this->db->get($this->table_pc_cab);
	}	
	
	/*Add CPV*/
  function add_cpv($cpv)
	{
  		$this->db->insert($this->table_pc_cab,$cpv);
	}
	
	/*Add branch petty cash*/
  function add_pc_branch($pcbal)
	{
  		$this->db->insert($this->table_pcbal,$pcbal);
	}

/*Add branch petty cash operasional*/
  function add_pcopr_branch($pcbalop)
	{
  		$this->db->insert($this->table_pcbal_op,$pcbalop);
	}

/*Get list CPV*/
	function get_list_cpv($idcab,$limit, $offset)
		{
			$this->db->select('m_cab.cabname,
							  t_pc_cab.nopc,
							  m_pc_typ.desc as pcdesc,
							  t_pc_cab.nopcform,
							  t_pc_cab.amount,
							  t_pc_cab.desc,
							  t_pc_cab.year,
							  t_pc_cab.addby,
							  t_pc_cab.adddate,
							  t_pc_cab.idcab,'
							 );
			$this->db->from('t_pc_cab');
			$this->db->join('m_cab', 'm_cab.idcab = t_pc_cab.idcab');
			$this->db->join('m_pc_typ', 'm_pc_typ.idpctyp = t_pc_cab.pctyp');
			$this->db->where('t_pc_cab.idcab', $idcab); 
			$this->db->order_by('t_pc_cab.nopc', 'DESC'); 
			$this->db->order_by('t_pc_cab.year', 'DESC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}
/*Get list CPV count*/
function get_list_cpv_count($idcab)
		{
			$this->db->select('m_cab.cabname,
							  t_pc_cab.nopc,
							  t_pc_cab.nopcform,
							  t_pc_cab.amount,
							  t_pc_cab.desc,
							  t_pc_cab.year,
							  t_pc_cab.addby,
							  t_pc_cab.adddate'
							 );
			$this->db->from('t_pc_cab');
			$this->db->join('m_cab', 'm_cab.idcab = t_pc_cab.idcab');
			$this->db->join('m_pc_typ', 'm_pc_typ.idpctyp = t_pc_cab.pctyp');
			$this->db->where('t_pc_cab.idcab', $idcab); 
			$this->db->order_by('t_pc_cab.nopc', 'DESC'); 
			$this->db->order_by('t_pc_cab.year', 'DESC'); 
			$query = $this->db->get();
			return $query->num_rows;
		}
/*-------------PETTY CASH / CPV MODEL---------------------*/

}