<?php
/*
Fungsi : Model Notifikasi
Create By : Rony
Date : 16-03-2014

Last Change By :
Last Date Change :
*/
class Notifikasi_model extends CI_Model {
	/**
	 * Constructor
	 */
	function Notifikasi_model()
	{
		parent::__construct();
	} 
	
	/* Insialiasi nama table */
	var $table_group			= 'group';
	var $table_grouping			= 'grouping';
	var $table_reminder			= 'reminder_events';
	
	
	/* =========== Model Master Data Perijinan ==========*/
	
	/* Insert data perijinan */
   		function add_perijinan($perijinan)
		{
			$this->db->insert($this->table_group, $perijinan);
		}
		
	/* Get Daycode by ID Daycode */
	function get_group()
	{
		$this->db->select('*');
		$query = $this->db->get($this->table_group);
  		return $query;
	}
	
	/* Get Daycode by ID Daycode */
	function get_grouping()
	{
		$this->db->select('*');
		$query = $this->db->get($this->table_grouping);
  		return $query;
	}
	
	/* ================================================= */
	
	
	
	/* =========== Model Data Perijinan Reminder ==========*/
	
	/* Insert data perijinan */
   		function add_reminder($perijinan)
		{
			$this->db->insert($this->table_reminder, $perijinan);
		}
		
		/* List perijinan paging */
	function get_paging_expired($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.exp_date', date('Y-m-d'));
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* List perijinan paging */
	function get_paging_reminder($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.reminder_date', date('Y-m-d'));
		$this->db->or_where('reminder_events.reminder_date2', date('Y-m-d'));
		$this->db->or_where('reminder_events.reminder_date3', date('Y-m-d'));
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan */
	function count_rows_expired()
	{
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.exp_date', date('Y-m-d'));
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* Total data perijinan */
	function count_rows_reminder()
	{
		if(!empty($search)){
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.reminder_date', date('Y-m-d'));
		$this->db->or_where('reminder_events.reminder_date2', date('Y-m-d'));
		$this->db->or_where('reminder_events.reminder_date3', date('Y-m-d'));
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging */
	function get_paging_next_perijinan($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->where('exp_date >=', date('Y-m-d'));
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan */
	function count_rows_next_perijinan()
	{
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->where('exp_date >=', date('Y-m-d'));
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging */
	function get_paging_last_perijinan($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan */
	function count_rows_last_perijinan()
	{
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* Get DIV by div id*/
	function get_data($id)
	{
		$this->db->where('reminder_id', $id);
		return $this->db->get($this->table_reminder);
	}
	
	/* ==================================================== */


	/* ============= Model Data Notifikasi =============*/

	/* Total data perijinan */
	function count_reminder()
	{	
		$this->db->select('*');
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->where('reminder_date =', date('Y-m-d'));
		return $this->db->count_all_results($this->table_reminder);
	}

	/* ================================================= */
}