<?php
/*
Fungsi : Model untuk modul admin
*/
class Ppic_sample_model extends CI_Model {

	function Ppic_sample_model()
	{
		parent::__construct();
		$this->default2 = $this->load->database('default2', TRUE);
	}

	function viewResampleStatus($id_ba)
	{
		$cek = $this->db->get_where('berita_acara', array('id_ba' => $id_ba, 'resample >=' => '1'))->num_rows();
		if($cek > 0)
		{
			return $this->db->get_where('berita_acara', array('id_ba' => $id_ba))->row('resample');
		} else
		{
			return '0';
		}
	}
	
	function viewBeritaAcara($limit, $offset, $search)
	{
		$this->default2->where('status_approval_qc', '0');
		$this->default2->where('status_approval_ppic', '0');
		if(!empty($search))
		{
			$this->default2->like('id_ba',$search);
		}
		$this->default2->order_by('id','DESC');
		$this->default2->limit($limit, $offset);
  		return $this->default2->get('berita_acara');
	}

	function countBeritaAcara($search)
	{	
		$this->default2->where('status_approval_qc', '0');
		$this->default2->where('status_approval_ppic', '0');
		if(!empty($search))
		{
			$this->default2->like('id_ba',$search);
		}
		return $this->default2->count_all_results('berita_acara');
	}

	function getNomorBeritaAcara($id)
	{
		$this->default2->where('id', $id);
		return $this->default2->get('berita_acara')->row('id_ba');
	}

	function getDataWhere($table, $where)
	{
		return $this->db->get_where($table, $where);
	}

	function createDataToQA($table, $data)
	{
		$this->db->insert($table, $data);
	}

	function viewNomorSampleForSertifikat($limit, $offset, $search)
	{
		$this->db->where('approval_spv_qc', '1');
		if(!empty($search))
		{
			$this->db->like('idba', $search);
		}
		$this->db->order_by('idqa','DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get('t_qa');
	}

	function countNomorSampleForSertifikat($search)
	{	
		$this->db->where('approval_spv_qc', '1');
		if(!empty($search))
		{
			$this->db->like('idba', $search);
		}
		$this->db->order_by('idqa','DESC');
		return $this->db->count_all_results('t_qa');
	}

	function viewRetestingForSertifikat($limit, $offset, $search)
	{
		$this->db->where('status_approval_qc', '1');
		if(!empty($search))
		{
			$this->db->like('retesting_ba', $search);
		}
		$this->db->order_by('retesting_ba','DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get('retesting');
	}

	function countRetestingForSertifikat($search)
	{	
		$this->db->where('status_approval_qc', '1');
		if(!empty($search))
		{
			$this->db->like('retesting_ba', $search);
		}
		$this->db->order_by('retesting_ba','DESC');
		return $this->db->count_all_results('retesting');
	}

	function viewNomorSampleWithRange($awal, $akhir)
	{
		$this->db->where('approval_spv_qc', '1');
		$this->db->where('adddate >=', $awal);
		$this->db->where('adddate <=', $akhir);
		$this->db->order_by('idba','DESC');
  		return $this->db->get('t_qa');
	}
}