<?php
/*
Fungsi : Model untuk modul admin
*/
class qa_sample_model extends CI_Model {

	function qa_sample_model()
	{
		parent::__construct();
		$this->default2 = $this->load->database('default2', TRUE);
	}
	
	function viewNomorAnalisa($limit, $offset, $search)
	{
		$this->db->where('approval_spv_qc', '0');
		$this->db->where('status_qc', '0');
		if(!empty($search))
		{
			$this->db->like('id_sample_lab',$search);
		}
		$this->db->order_by('idqa','DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get('t_qa');
	}

	function countNomorAnalisa($search)
	{	
		$this->db->where('approval_spv_qc', '0');
		$this->db->where('status_qc', '0');
		if(!empty($search))
		{
			$this->db->like('id_sample_lab',$search);
		}
		return $this->db->count_all_results('t_qa');
	}

	function viewBARetesting($limit, $offset, $search)
	{
		$this->db->where('status_input_qc', '0');
		$this->db->where('status_approval_qc', '0');
		if(!empty($search))
		{
			$this->db->like('retesting_lab',$search);
		}
		$this->db->order_by('retesting_lab','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get('retesting');
	}

	function countBARetesting($search)
	{	
		$this->db->where('status_input_qc', '0');
		$this->db->where('status_approval_qc', '0');
		if(!empty($search))
		{
			$this->db->like('retesting_lab',$search);
		}
		return $this->db->count_all_results('retesting');
	}

	function getKodeLabelLab($idqa)
	{
		$this->db->where('idqa', $idqa);
		return $this->db->get('t_qa')->row('id_sample_lab');
	}

	function uData($table, $data, $idqa)
	{
		$this->db->where('idqa', $idqa);
		$this->db->update($table, $data);
	}

	function uDataRetesting($table, $data, $idqa)
	{
		$this->db->where('retesting_id', $idqa);
		$this->db->update($table, $data);
	}

	function uDataToCIS($table, $data, $id_ba)
	{
		$this->default2->where('id_ba', $id_ba);
		$this->default2->update($table, $data);
	}

	function viewListSample($limit, $offset, $search)
	{
		if(!empty($search))
		{
			$this->db->like('id_sample_lab',$search);
		}
		$this->db->order_by('adddate','DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get('t_qa');
	}

	function countListSample($search)
	{	
		if(!empty($search))
		{
			$this->db->like('id_sample_lab',$search);
		}
		return $this->db->count_all_results('t_qa');
	}

	function viewListSampleRetesting($limit, $offset, $search)
	{
		if(!empty($search))
		{
			$this->db->like('retesting_lab',$search);
		}
		$this->db->order_by('adddate','DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get('retesting');
	}

	function countListSampleRetesting($search)
	{	
		if(!empty($search))
		{
			$this->db->like('retesting_lab',$search);
		}
		return $this->db->count_all_results('retesting');
	}
	
	function viewListSampleApp($limit, $offset, $search)
	{
		$this->db->where('approval_spv_qc', '0');
		if(!empty($search))
		{
			$this->db->like('id_sample_lab',$search);
		}
		$this->db->order_by('idqa','DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get('t_qa');
	}

	function countListSampleApp($search)
	{	
		$this->db->where('approval_spv_qc', '0');
		if(!empty($search))
		{
			$this->db->like('id_sample_lab',$search);
		}
		return $this->db->count_all_results('t_qa');
	}

	function viewListSampleAppRetesting($limit, $offset, $search)
	{
		$this->db->where('status_approval_qc', '0');
		if(!empty($search))
		{
			$this->db->like('retesting_lab',$search);
		}
		$this->db->order_by('retesting_lab','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get('retesting');
	}

	function countListSampleAppRetesting($search)
	{	
		$this->db->where('status_approval_qc', '0');
		if(!empty($search))
		{
			$this->db->like('retesting_lab',$search);
		}
		return $this->db->count_all_results('retesting');
	}

	function getDataAnalisis($idqa)
	{
		$this->db->where('idqa', $idqa);
		return $this->db->get('t_qa');
	}

	function getDataAnalisisRetesting($idqa)
	{
		$this->db->where('retesting_id', $idqa);
		return $this->db->get('retesting');
	}
}